/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.TransformedSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformedSetTest<E>
extends AbstractSetTest<E> {
    public TransformedSetTest() {
        super(TransformedSetTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public Set<E> makeConfirmedCollection() {
        return new HashSet();
    }

    @Override
    public Set<E> makeConfirmedFullCollection() {
        return new HashSet(Arrays.asList(this.getFullElements()));
    }

    @Override
    public Set<E> makeFullCollection() {
        HashSet list = new HashSet(Arrays.asList(this.getFullElements()));
        return TransformedSet.transformingSet(list, TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Override
    public Set<E> makeObject() {
        return TransformedSet.transformingSet(new HashSet(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Test
    public void testTransformedSet() {
        TransformedSet set = TransformedSet.transformingSet(new HashSet(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)0, (int)set.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (int i = 0; i < els.length; ++i) {
            set.add(els[i]);
            Assertions.assertEquals((int)(i + 1), (int)set.size());
            Assertions.assertTrue((boolean)set.contains(Integer.valueOf((String)els[i])));
            Assertions.assertFalse((boolean)set.contains(els[i]));
        }
        Assertions.assertFalse((boolean)set.remove(els[0]));
        Assertions.assertTrue((boolean)set.remove(Integer.valueOf((String)els[0])));
    }

    @Test
    public void testTransformedSet_decorateTransform() {
        HashSet originalSet = new HashSet();
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        Collections.addAll(originalSet, els);
        Set set = TransformedSet.transformedSet(originalSet, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)els.length, (int)set.size());
        for (Object el : els) {
            Assertions.assertTrue((boolean)set.contains(Integer.valueOf((String)el)));
            Assertions.assertFalse((boolean)set.contains(el));
        }
        Assertions.assertFalse((boolean)set.remove(els[0]));
        Assertions.assertTrue((boolean)set.remove(Integer.valueOf((String)els[0])));
    }
}

