/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.collections4.map.AbstractHashedMap;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReferenceMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    WeakReference<K> keyReference;
    WeakReference<V> valueReference;

    private static void gc() {
        try {
            byte[][] tooLarge = new byte[1000000000][1000000000];
            Assertions.fail((String)"you have too much RAM");
        }
        catch (OutOfMemoryError ex) {
            System.gc();
        }
    }

    public ReferenceMapTest() {
        super(ReferenceMapTest.class.getSimpleName());
    }

    public Map<K, V> buildRefMap() {
        Object key = new Object();
        Object value = new Object();
        this.keyReference = new WeakReference<Object>(key);
        this.valueReference = new WeakReference<Object>(value);
        ReferenceMap testMap = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD, true);
        testMap.put(key, value);
        Assertions.assertEquals((Object)value, testMap.get(key), (String)"In map");
        Assertions.assertNotNull(this.keyReference.get(), (String)"Weak reference released early (1)");
        Assertions.assertNotNull(this.valueReference.get(), (String)"Weak reference released early (2)");
        return testMap;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public boolean isAllowNullValue() {
        return false;
    }

    @Override
    public ReferenceMap<K, V> makeObject() {
        return new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.WEAK);
    }

    @Test
    public void testCustomPurge() {
        ArrayList expiredValues = new ArrayList();
        final Consumer consumer = expiredValues::add;
        ReferenceMap<Integer, Integer> map = new ReferenceMap<Integer, Integer>(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD, false){
            private static final long serialVersionUID = 1L;

            protected AbstractReferenceMap.ReferenceEntry<Integer, Integer> createEntry(AbstractHashedMap.HashEntry<Integer, Integer> next, int hashCode, Integer key, Integer value) {
                return new AccessibleEntry<Integer, Integer>((AbstractReferenceMap<Integer, Integer>)this, next, hashCode, key, value, consumer);
            }
        };
        for (int i = 100000; i < 100010; ++i) {
            map.put(i, i);
        }
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50 || bytz < 0) {
                Assertions.fail((String)"Max iterations reached before resource released.");
            }
            map.isEmpty();
            if (!expiredValues.isEmpty()) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
        Assertions.assertFalse((boolean)expiredValues.isEmpty(), (String)"Value should be stored");
    }

    @Test
    public void testDataSizeAfterSerialization() throws IOException, ClassNotFoundException {
        ReferenceMap serializeMap = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.WEAK, true);
        serializeMap.put((Object)"KEY", (Object)"VALUE");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(baos);){
            out.writeObject(serializeMap);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream in = new ObjectInputStream(bais);){
            ReferenceMap deserializedMap = (ReferenceMap)in.readObject();
            Assertions.assertEquals((int)1, (int)deserializedMap.size());
            Assertions.assertEquals((int)serializeMap.data.length, (int)deserializedMap.data.length);
        }
    }

    @Test
    public void testIteratorLastEntryCanBeRemovedAfterHasNext() {
        ReferenceMap map = new ReferenceMap();
        map.put((Object)1, (Object)2);
        Iterator iter = map.entrySet().iterator();
        Assertions.assertTrue((boolean)iter.hasNext());
        iter.next();
        Assertions.assertFalse((boolean)iter.hasNext());
        iter.remove();
        Assertions.assertTrue((boolean)map.isEmpty(), (String)("Expect empty but have entry: " + map));
    }

    @Test
    public void testNullHandling() {
        this.resetFull();
        Assertions.assertNull(this.map.get(null));
        Assertions.assertFalse((boolean)this.map.containsKey(null));
        Assertions.assertFalse((boolean)this.map.containsValue(null));
        Assertions.assertNull(this.map.remove(null));
        Assertions.assertFalse((boolean)this.map.entrySet().contains(null));
        Assertions.assertFalse((boolean)this.map.containsKey(null));
        Assertions.assertFalse((boolean)this.map.containsValue(null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.put(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.put(new Object(), null));
        Assertions.assertThrows(NullPointerException.class, () -> this.map.put(null, new Object()));
    }

    @Test
    public void testPurgeValues() throws Exception {
        Map<K, V> testMap = this.buildRefMap();
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50) {
                Assertions.fail((String)"Max iterations reached before resource released.");
            }
            testMap.isEmpty();
            if (this.keyReference.get() == null && this.valueReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    private static final class AccessibleEntry<K, V>
    extends AbstractReferenceMap.ReferenceEntry<K, V> {
        final AbstractReferenceMap<K, V> parent;
        final Consumer<V> consumer;

        AccessibleEntry(AbstractReferenceMap<K, V> parent, AbstractHashedMap.HashEntry<K, V> next, int hashCode, K key, V value, Consumer<V> consumer) {
            super(parent, next, hashCode, key, value);
            this.parent = parent;
            this.consumer = consumer;
        }

        protected void onPurge() {
            if (this.parent.isValueType(AbstractReferenceMap.ReferenceStrength.HARD)) {
                this.consumer.accept(this.getValue());
            }
        }
    }
}

