/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.list.AbstractLinkedListForJava21;
import org.apache.commons.collections4.list.AbstractListTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultAbstractLinkedListForJava21Test<E>
extends AbstractListTest<E> {
    public DefaultAbstractLinkedListForJava21Test() {
        super(DefaultAbstractLinkedListForJava21Test.class.getSimpleName());
    }

    protected void checkNodes() {
        AbstractLinkedListForJava21<E> list = this.getCollection();
        for (int i = 0; i < list.size; ++i) {
            Assertions.assertEquals((Object)list.getNode((int)i, (boolean)false).next, (Object)list.getNode(i + 1, true));
            if (i >= list.size - 1) continue;
            Assertions.assertEquals((Object)list.getNode((int)(i + 1), (boolean)false).previous, (Object)list.getNode(i, false));
        }
    }

    @Override
    public AbstractLinkedListForJava21<E> getCollection() {
        return (AbstractLinkedListForJava21)super.getCollection();
    }

    @Override
    public String getCompatibilityVersion() {
        return null;
    }

    @Override
    public List<E> makeObject() {
        return new DefaultAbstractLinkedListForJava21();
    }

    @Override
    protected boolean skipSerializedCanonicalTests() {
        return true;
    }

    @Test
    public void testAddNodeAfter() {
        this.resetEmpty();
        AbstractLinkedListForJava21<E> list = this.getCollection();
        if (!this.isAddSupported()) {
            try {
                list.addFirst(null);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        list.addFirst((Object)"value1");
        list.addNodeAfter(list.getNode(0, false), (Object)"value2");
        Assertions.assertEquals((Object)"value1", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value2", (Object)list.getLast());
        list.removeFirst();
        this.checkNodes();
        list.addNodeAfter(list.getNode(0, false), (Object)"value3");
        this.checkNodes();
        Assertions.assertEquals((Object)"value2", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value3", (Object)list.getLast());
        list.addNodeAfter(list.getNode(0, false), (Object)"value4");
        this.checkNodes();
        Assertions.assertEquals((Object)"value2", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value3", (Object)list.getLast());
        Assertions.assertEquals((Object)"value4", (Object)list.get(1));
        list.addNodeAfter(list.getNode(2, false), (Object)"value5");
        this.checkNodes();
        Assertions.assertEquals((Object)"value2", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value4", (Object)list.get(1));
        Assertions.assertEquals((Object)"value3", (Object)list.get(2));
        Assertions.assertEquals((Object)"value5", (Object)list.getLast());
    }

    @Test
    public void testGetNode() {
        this.resetEmpty();
        AbstractLinkedListForJava21 list = this.getCollection();
        Assertions.assertEquals((Object)list.getNode((int)0, (boolean)true).previous, (Object)list.getNode((int)0, (boolean)true).next);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> list.getNode(0, false), (String)"Expecting IndexOutOfBoundsException.");
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        this.checkNodes();
        list.addFirst((Object)"value0");
        this.checkNodes();
        list.removeNode(list.getNode(1, false));
        this.checkNodes();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> list.getNode(2, false), (String)"Expecting IndexOutOfBoundsException.");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> list.getNode(-1, false), (String)"Expecting IndexOutOfBoundsException.");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> list.getNode(3, true), (String)"Expecting IndexOutOfBoundsException.");
    }

    @Test
    public void testRemoveFirst() {
        this.resetEmpty();
        AbstractLinkedListForJava21<E> list = this.getCollection();
        if (!this.isRemoveSupported()) {
            try {
                list.removeFirst();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        Assertions.assertEquals((Object)"value1", (Object)list.removeFirst());
        this.checkNodes();
        list.addLast((Object)"value3");
        this.checkNodes();
        Assertions.assertEquals((Object)"value2", (Object)list.removeFirst());
        Assertions.assertEquals((Object)"value3", (Object)list.removeFirst());
        this.checkNodes();
        list.addLast((Object)"value4");
        this.checkNodes();
        Assertions.assertEquals((Object)"value4", (Object)list.removeFirst());
        this.checkNodes();
    }

    @Test
    public void testRemoveLast() {
        this.resetEmpty();
        AbstractLinkedListForJava21<E> list = this.getCollection();
        if (!this.isRemoveSupported()) {
            try {
                list.removeLast();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        Assertions.assertEquals((Object)"value2", (Object)list.removeLast());
        list.addFirst((Object)"value3");
        this.checkNodes();
        Assertions.assertEquals((Object)"value1", (Object)list.removeLast());
        Assertions.assertEquals((Object)"value3", (Object)list.removeLast());
        list.addFirst((Object)"value4");
        this.checkNodes();
        Assertions.assertEquals((Object)"value4", (Object)list.removeFirst());
    }

    @Test
    public void testRemoveNode() {
        this.resetEmpty();
        if (!this.isAddSupported() || !this.isRemoveSupported()) {
            return;
        }
        AbstractLinkedListForJava21<E> list = this.getCollection();
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        list.removeNode(list.getNode(0, false));
        this.checkNodes();
        Assertions.assertEquals((Object)"value2", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value2", (Object)list.getLast());
        list.addFirst((Object)"value1");
        list.addFirst((Object)"value0");
        this.checkNodes();
        list.removeNode(list.getNode(1, false));
        Assertions.assertEquals((Object)"value0", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value2", (Object)list.getLast());
        this.checkNodes();
        list.removeNode(list.getNode(1, false));
        Assertions.assertEquals((Object)"value0", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value0", (Object)list.getLast());
        this.checkNodes();
    }

    @Test
    public void testSubList() {
        Collection list = this.makeObject();
        list.add("A");
        list.add("B");
        list.add("C");
        list.add("D");
        list.add("E");
        Assertions.assertEquals((Object)"[A, B, C, D, E]", (Object)list.toString());
        Assertions.assertEquals((Object)"[A, B, C, D, E]", (Object)list.subList(0, 5).toString());
        Assertions.assertEquals((Object)"[B, C, D, E]", (Object)list.subList(1, 5).toString());
        Assertions.assertEquals((Object)"[C, D, E]", (Object)list.subList(2, 5).toString());
        Assertions.assertEquals((Object)"[D, E]", (Object)list.subList(3, 5).toString());
        Assertions.assertEquals((Object)"[E]", (Object)list.subList(4, 5).toString());
        Assertions.assertEquals((Object)"[]", (Object)list.subList(5, 5).toString());
    }

    @Test
    public void testSubListAddBegin() {
        Collection list = this.makeObject();
        list.add("A");
        list.add("B");
        list.add("C");
        list.add("D");
        list.add("E");
        List<String> sublist = list.subList(0, 0);
        sublist.add("a");
        Assertions.assertEquals((Object)"[a, A, B, C, D, E]", (Object)list.toString());
        Assertions.assertEquals((Object)"[a]", (Object)sublist.toString());
        sublist.add("b");
        Assertions.assertEquals((Object)"[a, b, A, B, C, D, E]", (Object)list.toString());
        Assertions.assertEquals((Object)"[a, b]", (Object)sublist.toString());
    }

    @Test
    public void testSubListAddEnd() {
        Collection list = this.makeObject();
        list.add("A");
        list.add("B");
        list.add("C");
        list.add("D");
        list.add("E");
        List<String> sublist = list.subList(5, 5);
        sublist.add("F");
        Assertions.assertEquals((Object)"[A, B, C, D, E, F]", (Object)list.toString());
        Assertions.assertEquals((Object)"[F]", (Object)sublist.toString());
        sublist.add("G");
        Assertions.assertEquals((Object)"[A, B, C, D, E, F, G]", (Object)list.toString());
        Assertions.assertEquals((Object)"[F, G]", (Object)sublist.toString());
    }

    @Test
    public void testSubListAddMiddle() {
        Collection list = this.makeObject();
        list.add("A");
        list.add("B");
        list.add("C");
        list.add("D");
        list.add("E");
        List<String> sublist = list.subList(1, 3);
        sublist.add("a");
        Assertions.assertEquals((Object)"[A, B, C, a, D, E]", (Object)list.toString());
        Assertions.assertEquals((Object)"[B, C, a]", (Object)sublist.toString());
        sublist.add("b");
        Assertions.assertEquals((Object)"[A, B, C, a, b, D, E]", (Object)list.toString());
        Assertions.assertEquals((Object)"[B, C, a, b]", (Object)sublist.toString());
    }

    @Test
    public void testSubListRemove() {
        Collection list = this.makeObject();
        list.add("A");
        list.add("B");
        list.add("C");
        list.add("D");
        list.add("E");
        List sublist = list.subList(1, 4);
        Assertions.assertEquals((Object)"[B, C, D]", (Object)sublist.toString());
        Assertions.assertEquals((Object)"[A, B, C, D, E]", (Object)list.toString());
        sublist.remove("C");
        Assertions.assertEquals((Object)"[B, D]", (Object)sublist.toString());
        Assertions.assertEquals((Object)"[A, B, D, E]", (Object)list.toString());
        sublist.remove(1);
        Assertions.assertEquals((Object)"[B]", (Object)sublist.toString());
        Assertions.assertEquals((Object)"[A, B, E]", (Object)list.toString());
        sublist.clear();
        Assertions.assertEquals((Object)"[]", (Object)sublist.toString());
        Assertions.assertEquals((Object)"[A, E]", (Object)list.toString());
    }

    private static class DefaultAbstractLinkedListForJava21<E>
    extends AbstractLinkedListForJava21<E> {
        DefaultAbstractLinkedListForJava21() {
            this.init();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.doReadObject(in);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            this.doWriteObject(out);
        }
    }
}

