/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.list.AbstractLinkedListTest;
import org.apache.commons.collections4.list.CursorableLinkedList;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class CursorableLinkedListTest<E>
extends AbstractLinkedListTest<E> {
    private CursorableLinkedList<E> list;

    public CursorableLinkedListTest() {
        super(CursorableLinkedListTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public String[] ignoredTests() {
        String[] ignored;
        ArrayList<String> list = new ArrayList<String>();
        String prefix = "CursorableLinkedListTest";
        String bulk = ".bulkTestSubList";
        for (String element : ignored = new String[]{".testEmptyListSerialization", ".testFullListSerialization", ".testEmptyListCompatibility", ".testFullListCompatibility", ".testSimpleSerialization", ".testCanonicalEmptyCollectionExists", ".testCanonicalFullCollectionExists", ".testSerializeDeserializeThenCompare"}) {
            list.add("CursorableLinkedListTest.bulkTestSubList" + element);
            list.add("CursorableLinkedListTest.bulkTestSubList.bulkTestSubList" + element);
        }
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    public CursorableLinkedList<E> makeObject() {
        return new CursorableLinkedList();
    }

    @BeforeEach
    public void setUp() {
        this.list = new CursorableLinkedList();
    }

    @Test
    public void testAdd() {
        Assertions.assertEquals((Object)"[]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.add((Object)1));
        Assertions.assertEquals((Object)"[1]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.add((Object)2));
        Assertions.assertEquals((Object)"[1, 2]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.add((Object)3));
        Assertions.assertEquals((Object)"[1, 2, 3]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.addFirst((Object)0));
        Assertions.assertEquals((Object)"[0, 1, 2, 3]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.addLast((Object)4));
        Assertions.assertEquals((Object)"[0, 1, 2, 3, 4]", (Object)this.list.toString());
        this.list.add(0, (Object)-2);
        Assertions.assertEquals((Object)"[-2, 0, 1, 2, 3, 4]", (Object)this.list.toString());
        this.list.add(1, (Object)-1);
        Assertions.assertEquals((Object)"[-2, -1, 0, 1, 2, 3, 4]", (Object)this.list.toString());
        this.list.add(7, (Object)5);
        Assertions.assertEquals((Object)"[-2, -1, 0, 1, 2, 3, 4, 5]", (Object)this.list.toString());
        LinkedList<String> list2 = new LinkedList<String>();
        list2.add("A");
        list2.add("B");
        list2.add("C");
        Assertions.assertTrue((boolean)this.list.addAll(list2));
        Assertions.assertEquals((Object)"[-2, -1, 0, 1, 2, 3, 4, 5, A, B, C]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.addAll(3, list2));
        Assertions.assertEquals((Object)"[-2, -1, 0, A, B, C, 1, 2, 3, 4, 5, A, B, C]", (Object)this.list.toString());
    }

    @Test
    public void testClear() {
        Assertions.assertEquals((int)0, (int)this.list.size());
        Assertions.assertTrue((boolean)this.list.isEmpty());
        this.list.clear();
        Assertions.assertEquals((int)0, (int)this.list.size());
        Assertions.assertTrue((boolean)this.list.isEmpty());
        this.list.add((Object)"element");
        Assertions.assertEquals((int)1, (int)this.list.size());
        Assertions.assertFalse((boolean)this.list.isEmpty());
        this.list.clear();
        Assertions.assertEquals((int)0, (int)this.list.size());
        Assertions.assertTrue((boolean)this.list.isEmpty());
        this.list.add((Object)"element1");
        this.list.add((Object)"element2");
        Assertions.assertEquals((int)2, (int)this.list.size());
        Assertions.assertFalse((boolean)this.list.isEmpty());
        this.list.clear();
        Assertions.assertEquals((int)0, (int)this.list.size());
        Assertions.assertTrue((boolean)this.list.isEmpty());
        for (int i = 0; i < 1000; ++i) {
            this.list.add((Object)i);
        }
        Assertions.assertEquals((int)1000, (int)this.list.size());
        Assertions.assertFalse((boolean)this.list.isEmpty());
        this.list.clear();
        Assertions.assertEquals((int)0, (int)this.list.size());
        Assertions.assertTrue((boolean)this.list.isEmpty());
    }

    @Test
    public void testContains() {
        Assertions.assertFalse((boolean)this.list.contains((Object)"A"));
        Assertions.assertTrue((boolean)this.list.add((Object)"A"));
        Assertions.assertTrue((boolean)this.list.contains((Object)"A"));
        Assertions.assertTrue((boolean)this.list.add((Object)"B"));
        Assertions.assertTrue((boolean)this.list.contains((Object)"A"));
        Assertions.assertTrue((boolean)this.list.addFirst((Object)"a"));
        Assertions.assertTrue((boolean)this.list.contains((Object)"A"));
        Assertions.assertTrue((boolean)this.list.remove((Object)"a"));
        Assertions.assertTrue((boolean)this.list.contains((Object)"A"));
        Assertions.assertTrue((boolean)this.list.remove((Object)"A"));
        Assertions.assertFalse((boolean)this.list.contains((Object)"A"));
    }

    @Test
    public void testContainsAll() {
        Assertions.assertTrue((boolean)this.list.containsAll(this.list));
        LinkedList<String> list2 = new LinkedList<String>();
        Assertions.assertTrue((boolean)this.list.containsAll(list2));
        list2.add("A");
        Assertions.assertFalse((boolean)this.list.containsAll(list2));
        this.list.add((Object)"B");
        this.list.add((Object)"A");
        Assertions.assertTrue((boolean)this.list.containsAll(list2));
        list2.add("B");
        Assertions.assertTrue((boolean)this.list.containsAll(list2));
        list2.add("C");
        Assertions.assertFalse((boolean)this.list.containsAll(list2));
        this.list.add((Object)"C");
        Assertions.assertTrue((boolean)this.list.containsAll(list2));
        list2.add("C");
        Assertions.assertTrue((boolean)this.list.containsAll(list2));
        Assertions.assertTrue((boolean)this.list.containsAll(this.list));
    }

    @Test
    public void testCursorAdd() {
        CursorableLinkedList.Cursor it = this.list.cursor();
        it.add((Object)"1");
        Assertions.assertEquals((Object)"[1]", (Object)this.list.toString());
        it.add((Object)"3");
        Assertions.assertEquals((Object)"[1, 3]", (Object)this.list.toString());
        it.add((Object)"5");
        Assertions.assertEquals((Object)"[1, 3, 5]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"5", (Object)it.previous());
        it.add((Object)"4");
        Assertions.assertEquals((Object)"[1, 3, 4, 5]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"4", (Object)it.previous());
        Assertions.assertEquals((Object)"3", (Object)it.previous());
        it.add((Object)"2");
        Assertions.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)this.list.toString());
        it.close();
    }

    @Test
    public void testCursorConcurrentModification() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        this.list.add((Object)"7");
        this.list.add((Object)"9");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        CursorableLinkedList.Cursor c2 = this.list.cursor();
        Iterator li = this.list.iterator();
        Assertions.assertEquals((Object)"1", li.next());
        Assertions.assertEquals((Object)"2", li.next());
        li.remove();
        Assertions.assertEquals((Object)"3", li.next());
        Assertions.assertEquals((Object)"1", (Object)c1.next());
        Assertions.assertEquals((Object)"3", (Object)c1.next());
        Assertions.assertEquals((Object)"1", (Object)c2.next());
        c1.remove();
        Assertions.assertEquals((Object)"5", (Object)c2.next());
        c2.add((Object)"6");
        Assertions.assertEquals((Object)"5", (Object)c1.next());
        Assertions.assertEquals((Object)"6", (Object)c1.next());
        Assertions.assertEquals((Object)"7", (Object)c1.next());
        this.list.add(0, (Object)"0");
        this.list.add(5, (Object)"8");
        Assertions.assertEquals((Object)"8", (Object)c1.next());
        Assertions.assertEquals((Object)"9", (Object)c1.next());
        c1.add((Object)"10");
        Assertions.assertEquals((Object)"7", (Object)c2.next());
        Assertions.assertEquals((Object)"8", (Object)c2.next());
        Assertions.assertEquals((Object)"9", (Object)c2.next());
        Assertions.assertEquals((Object)"10", (Object)c2.next());
        Assertions.assertThrows(NoSuchElementException.class, () -> c2.next());
        Assertions.assertThrows(ConcurrentModificationException.class, () -> li.next());
        c1.close();
        c2.close();
    }

    @Test
    public void testCursorNavigation() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor it = this.list.cursor();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"1", (Object)it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"1", (Object)it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"1", (Object)it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"2", (Object)it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"2", (Object)it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"2", (Object)it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"3", (Object)it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"4", (Object)it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"5", (Object)it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"5", (Object)it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"4", (Object)it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"3", (Object)it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"2", (Object)it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"1", (Object)it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertFalse((boolean)it.hasPrevious());
        it.close();
    }

    @Test
    public void testCursorNextIndexAddAfter() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((int)0, (int)c1.nextIndex());
        this.list.add(1, (Object)"0");
        Assertions.assertEquals((int)0, (int)c1.nextIndex());
        Assertions.assertEquals((Object)"1", (Object)c1.next());
        Assertions.assertEquals((int)1, (int)c1.nextIndex());
        Assertions.assertEquals((Object)"0", (Object)c1.next());
    }

    @Test
    public void testCursorNextIndexAddBefore() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((int)0, (int)c1.nextIndex());
        Assertions.assertEquals((Object)"1", (Object)c1.next());
        this.list.add(0, (Object)"0");
        Assertions.assertEquals((int)2, (int)c1.nextIndex());
        Assertions.assertEquals((Object)"2", (Object)c1.next());
    }

    @Test
    public void testCursorNextIndexAddNext() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((int)0, (int)c1.nextIndex());
        this.list.add(0, (Object)"0");
        Assertions.assertEquals((int)0, (int)c1.nextIndex());
        Assertions.assertEquals((Object)"0", (Object)c1.next());
        Assertions.assertEquals((int)1, (int)c1.nextIndex());
        Assertions.assertEquals((Object)"1", (Object)c1.next());
    }

    @Test
    public void testCursorNextIndexFirst() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((int)0, (int)c1.nextIndex());
        this.list.remove(0);
        Assertions.assertEquals((int)0, (int)c1.nextIndex());
        Assertions.assertEquals((Object)"2", (Object)c1.next());
        Assertions.assertEquals((int)1, (int)c1.nextIndex());
        Assertions.assertEquals((Object)"3", (Object)c1.next());
    }

    @Test
    public void testCursorNextIndexMid() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Iterator li = this.list.iterator();
        Assertions.assertEquals((Object)"1", li.next());
        Assertions.assertEquals((Object)"2", li.next());
        li.remove();
        Assertions.assertEquals((int)0, (int)c1.nextIndex());
        Assertions.assertEquals((Object)"1", (Object)c1.next());
        Assertions.assertEquals((int)1, (int)c1.nextIndex());
        Assertions.assertEquals((Object)"3", (Object)c1.next());
    }

    @Test
    public void testCursorRemove() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor it = this.list.cursor();
        Assertions.assertThrows(IllegalStateException.class, () -> it.remove());
        Assertions.assertEquals((Object)"1", (Object)it.next());
        Assertions.assertEquals((Object)"2", (Object)it.next());
        Assertions.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)this.list.toString());
        it.remove();
        Assertions.assertEquals((Object)"[1, 3, 4, 5]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"3", (Object)it.next());
        Assertions.assertEquals((Object)"3", (Object)it.previous());
        Assertions.assertEquals((Object)"1", (Object)it.previous());
        it.remove();
        Assertions.assertEquals((Object)"[3, 4, 5]", (Object)this.list.toString());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"3", (Object)it.next());
        it.remove();
        Assertions.assertEquals((Object)"[4, 5]", (Object)this.list.toString());
        try {
            it.remove();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)"4", (Object)it.next());
        Assertions.assertEquals((Object)"5", (Object)it.next());
        it.remove();
        Assertions.assertEquals((Object)"[4]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"4", (Object)it.previous());
        it.remove();
        Assertions.assertEquals((Object)"[]", (Object)this.list.toString());
        it.close();
    }

    @Test
    public void testCursorSet() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        CursorableLinkedList.Cursor it = this.list.cursor();
        Assertions.assertEquals((Object)"1", (Object)it.next());
        it.set((Object)"a");
        Assertions.assertEquals((Object)"a", (Object)it.previous());
        it.set((Object)"A");
        Assertions.assertEquals((Object)"A", (Object)it.next());
        Assertions.assertEquals((Object)"2", (Object)it.next());
        it.set((Object)"B");
        Assertions.assertEquals((Object)"3", (Object)it.next());
        Assertions.assertEquals((Object)"4", (Object)it.next());
        it.set((Object)"D");
        Assertions.assertEquals((Object)"5", (Object)it.next());
        it.set((Object)"E");
        Assertions.assertEquals((Object)"[A, B, 3, D, E]", (Object)this.list.toString());
        it.close();
    }

    @Test
    public void testEqualsAndHashCode() {
        Assertions.assertEquals(this.list, this.list);
        Assertions.assertEquals((int)this.list.hashCode(), (int)this.list.hashCode());
        this.list.add((Object)"A");
        Assertions.assertEquals(this.list, this.list);
        Assertions.assertEquals((int)this.list.hashCode(), (int)this.list.hashCode());
        CursorableLinkedList list2 = new CursorableLinkedList();
        Assertions.assertFalse((boolean)this.list.equals((Object)list2));
        Assertions.assertFalse((boolean)list2.equals(this.list));
        LinkedList<String> list3 = new LinkedList<String>();
        Assertions.assertFalse((boolean)this.list.equals(list3));
        Assertions.assertFalse((boolean)list3.equals(this.list));
        Assertions.assertEquals((Object)list2, list3);
        Assertions.assertEquals(list3, (Object)list2);
        Assertions.assertEquals((int)list2.hashCode(), (int)list3.hashCode());
        list2.add((Object)"A");
        Assertions.assertEquals(this.list, (Object)list2);
        Assertions.assertEquals((Object)list2, this.list);
        Assertions.assertFalse((boolean)list2.equals(list3));
        Assertions.assertFalse((boolean)list3.equals(list2));
        list3.add("A");
        Assertions.assertEquals((Object)list2, list3);
        Assertions.assertEquals(list3, (Object)list2);
        Assertions.assertEquals((int)list2.hashCode(), (int)list3.hashCode());
        this.list.add((Object)"B");
        Assertions.assertEquals(this.list, this.list);
        Assertions.assertFalse((boolean)this.list.equals((Object)list2));
        Assertions.assertFalse((boolean)list2.equals(this.list));
        Assertions.assertFalse((boolean)this.list.equals(list3));
        Assertions.assertFalse((boolean)list3.equals(this.list));
        list2.add((Object)"B");
        list3.add("B");
        Assertions.assertEquals(this.list, this.list);
        Assertions.assertEquals(this.list, (Object)list2);
        Assertions.assertEquals((Object)list2, this.list);
        Assertions.assertEquals((Object)list2, list3);
        Assertions.assertEquals(list3, (Object)list2);
        Assertions.assertEquals((int)list2.hashCode(), (int)list3.hashCode());
        this.list.add((Object)"C");
        list2.add((Object)"C");
        list3.add("C");
        Assertions.assertEquals(this.list, this.list);
        Assertions.assertEquals(this.list, (Object)list2);
        Assertions.assertEquals((Object)list2, this.list);
        Assertions.assertEquals((Object)list2, list3);
        Assertions.assertEquals(list3, (Object)list2);
        Assertions.assertEquals((int)this.list.hashCode(), (int)list2.hashCode());
        Assertions.assertEquals((int)list2.hashCode(), (int)list3.hashCode());
        this.list.add((Object)"D");
        list2.addFirst((Object)"D");
        Assertions.assertEquals(this.list, this.list);
        Assertions.assertFalse((boolean)this.list.equals((Object)list2));
        Assertions.assertFalse((boolean)list2.equals(this.list));
    }

    @Test
    public void testGet() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.list.get(0), (String)"shouldn't get here");
        Assertions.assertTrue((boolean)this.list.add((Object)"A"));
        Assertions.assertEquals((Object)"A", (Object)this.list.get(0));
        Assertions.assertTrue((boolean)this.list.add((Object)"B"));
        Assertions.assertEquals((Object)"A", (Object)this.list.get(0));
        Assertions.assertEquals((Object)"B", (Object)this.list.get(1));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.list.get(-1), (String)"shouldn't get here"), () -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.list.get(2), (String)"shouldn't get here")});
    }

    @Test
    public void testIndexOf() {
        Assertions.assertEquals((int)-1, (int)this.list.indexOf((Object)"A"));
        Assertions.assertEquals((int)-1, (int)this.list.lastIndexOf((Object)"A"));
        this.list.add((Object)"A");
        Assertions.assertEquals((int)0, (int)this.list.indexOf((Object)"A"));
        Assertions.assertEquals((int)0, (int)this.list.lastIndexOf((Object)"A"));
        Assertions.assertEquals((int)-1, (int)this.list.indexOf((Object)"B"));
        Assertions.assertEquals((int)-1, (int)this.list.lastIndexOf((Object)"B"));
        this.list.add((Object)"B");
        Assertions.assertEquals((int)0, (int)this.list.indexOf((Object)"A"));
        Assertions.assertEquals((int)0, (int)this.list.lastIndexOf((Object)"A"));
        Assertions.assertEquals((int)1, (int)this.list.indexOf((Object)"B"));
        Assertions.assertEquals((int)1, (int)this.list.lastIndexOf((Object)"B"));
        this.list.addFirst((Object)"B");
        Assertions.assertEquals((int)1, (int)this.list.indexOf((Object)"A"));
        Assertions.assertEquals((int)1, (int)this.list.lastIndexOf((Object)"A"));
        Assertions.assertEquals((int)0, (int)this.list.indexOf((Object)"B"));
        Assertions.assertEquals((int)2, (int)this.list.lastIndexOf((Object)"B"));
    }

    @Test
    public void testInternalState_CursorNextAddIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        this.list.add(1, (Object)"Z");
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)1, (int)c1.nextIndex);
        Assertions.assertEquals((Object)"A", (Object)c1.current.value);
        Assertions.assertEquals((Object)"Z", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, Z, B, C]", (Object)this.list.toString());
        c1.remove();
        Assertions.assertEquals((Object)"[Z, B, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextNextAddByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        c1.add((Object)"Z");
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)3, (int)c1.nextIndex);
        Assertions.assertFalse((boolean)c1.currentRemovedByAnother);
        Assertions.assertNull((Object)c1.current);
        Assertions.assertEquals((Object)"C", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, B, Z, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextNextAddIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        this.list.add(1, (Object)"Z");
        Assertions.assertFalse((boolean)c1.nextIndexValid);
        Assertions.assertEquals((Object)"B", (Object)c1.current.value);
        Assertions.assertEquals((Object)"C", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, Z, B, C]", (Object)this.list.toString());
        c1.remove();
        Assertions.assertEquals((Object)"[A, Z, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextNextNextRemoveIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        Assertions.assertEquals((Object)"C", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)this.list.remove(1));
        Assertions.assertFalse((boolean)c1.nextIndexValid);
        Assertions.assertFalse((boolean)c1.currentRemovedByAnother);
        Assertions.assertEquals((Object)"C", (Object)c1.current.value);
        Assertions.assertEquals((Object)"D", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, C, D]", (Object)this.list.toString());
        c1.remove();
        Assertions.assertEquals((Object)"[A, D]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextNextPreviousAddByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.previous());
        c1.add((Object)"Z");
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)2, (int)c1.nextIndex);
        Assertions.assertNull((Object)c1.current);
        Assertions.assertEquals((Object)"B", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, Z, B, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextNextPreviousAddIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.previous());
        this.list.add(1, (Object)"Z");
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)1, (int)c1.nextIndex);
        Assertions.assertEquals((Object)"B", (Object)c1.current.value);
        Assertions.assertEquals((Object)"Z", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, Z, B, C]", (Object)this.list.toString());
        c1.remove();
        Assertions.assertEquals((Object)"[A, Z, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextNextPreviousRemoveByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.previous());
        c1.remove();
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)1, (int)c1.nextIndex);
        Assertions.assertFalse((boolean)c1.currentRemovedByAnother);
        Assertions.assertNull((Object)c1.current);
        Assertions.assertEquals((Object)"C", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextNextPreviousRemoveIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.previous());
        Assertions.assertEquals((Object)"B", (Object)this.list.remove(1));
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)1, (int)c1.nextIndex);
        Assertions.assertTrue((boolean)c1.currentRemovedByAnother);
        Assertions.assertNull((Object)c1.current);
        Assertions.assertEquals((Object)"C", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, C]", (Object)this.list.toString());
        c1.remove();
        Assertions.assertEquals((Object)"[A, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextNextPreviousSetByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.previous());
        c1.set((Object)"Z");
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)1, (int)c1.nextIndex);
        Assertions.assertEquals((Object)"Z", (Object)c1.current.value);
        Assertions.assertEquals((Object)"Z", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, Z, C]", (Object)this.list.toString());
        c1.remove();
        Assertions.assertEquals((Object)"[A, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextNextRemoveByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        c1.remove();
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)1, (int)c1.nextIndex);
        Assertions.assertFalse((boolean)c1.currentRemovedByAnother);
        Assertions.assertNull((Object)c1.current);
        Assertions.assertEquals((Object)"C", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextNextRemoveByListSetByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        this.list.remove(1);
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)1, (int)c1.nextIndex);
        Assertions.assertNull((Object)c1.current);
        Assertions.assertEquals((Object)"C", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.set((Object)"Z"));
    }

    @Test
    public void testInternalState_CursorNextNextRemoveIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)this.list.remove(1));
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)1, (int)c1.nextIndex);
        Assertions.assertTrue((boolean)c1.currentRemovedByAnother);
        Assertions.assertNull((Object)c1.current);
        Assertions.assertEquals((Object)"C", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, C]", (Object)this.list.toString());
        c1.remove();
        Assertions.assertEquals((Object)"[A, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextNextSetByIterator() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)c1.next());
        c1.set((Object)"Z");
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)2, (int)c1.nextIndex);
        Assertions.assertEquals((Object)"Z", (Object)c1.current.value);
        Assertions.assertEquals((Object)"C", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, Z, C]", (Object)this.list.toString());
        c1.remove();
        Assertions.assertEquals((Object)"[A, C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testInternalState_CursorNextRemoveIndex1ByList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        CursorableLinkedList.Cursor c1 = this.list.cursor();
        Assertions.assertEquals((Object)"A", (Object)c1.next());
        Assertions.assertEquals((Object)"B", (Object)this.list.remove(1));
        Assertions.assertTrue((boolean)c1.nextIndexValid);
        Assertions.assertEquals((int)1, (int)c1.nextIndex);
        Assertions.assertFalse((boolean)c1.currentRemovedByAnother);
        Assertions.assertEquals((Object)"A", (Object)c1.current.value);
        Assertions.assertEquals((Object)"C", (Object)c1.next.value);
        Assertions.assertEquals((Object)"[A, C]", (Object)this.list.toString());
        c1.remove();
        Assertions.assertEquals((Object)"[C]", (Object)this.list.toString());
        Assertions.assertThrows(IllegalStateException.class, () -> c1.remove());
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)this.list.isEmpty());
        this.list.add((Object)"element");
        Assertions.assertFalse((boolean)this.list.isEmpty());
        this.list.remove((Object)"element");
        Assertions.assertTrue((boolean)this.list.isEmpty());
        this.list.add((Object)"element");
        Assertions.assertFalse((boolean)this.list.isEmpty());
        this.list.clear();
        Assertions.assertTrue((boolean)this.list.isEmpty());
    }

    @Test
    public void testIterator() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        Iterator it = this.list.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"1", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"2", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"3", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"4", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"5", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        it = this.list.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"1", it.next());
        it.remove();
        Assertions.assertEquals((Object)"[2, 3, 4, 5]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"2", it.next());
        it.remove();
        Assertions.assertEquals((Object)"[3, 4, 5]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"3", it.next());
        it.remove();
        Assertions.assertEquals((Object)"[4, 5]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"4", it.next());
        it.remove();
        Assertions.assertEquals((Object)"[5]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"5", it.next());
        it.remove();
        Assertions.assertEquals((Object)"[]", (Object)this.list.toString());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Override
    @Test
    public void testListIteratorAdd() {
        ListIterator it = this.list.listIterator();
        it.add("1");
        Assertions.assertEquals((Object)"[1]", (Object)this.list.toString());
        it.add("3");
        Assertions.assertEquals((Object)"[1, 3]", (Object)this.list.toString());
        it.add("5");
        Assertions.assertEquals((Object)"[1, 3, 5]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"5", it.previous());
        it.add("4");
        Assertions.assertEquals((Object)"[1, 3, 4, 5]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"4", it.previous());
        Assertions.assertEquals((Object)"3", it.previous());
        it.add("2");
        Assertions.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)this.list.toString());
    }

    @Test
    public void testListIteratorNavigation() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        ListIterator it = this.list.listIterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((int)-1, (int)it.previousIndex());
        Assertions.assertEquals((int)0, (int)it.nextIndex());
        Assertions.assertEquals((Object)"1", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)0, (int)it.previousIndex());
        Assertions.assertEquals((int)1, (int)it.nextIndex());
        Assertions.assertEquals((Object)"1", it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((int)-1, (int)it.previousIndex());
        Assertions.assertEquals((int)0, (int)it.nextIndex());
        Assertions.assertEquals((Object)"1", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)0, (int)it.previousIndex());
        Assertions.assertEquals((int)1, (int)it.nextIndex());
        Assertions.assertEquals((Object)"2", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)1, (int)it.previousIndex());
        Assertions.assertEquals((int)2, (int)it.nextIndex());
        Assertions.assertEquals((Object)"2", it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)0, (int)it.previousIndex());
        Assertions.assertEquals((int)1, (int)it.nextIndex());
        Assertions.assertEquals((Object)"2", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)1, (int)it.previousIndex());
        Assertions.assertEquals((int)2, (int)it.nextIndex());
        Assertions.assertEquals((Object)"3", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)2, (int)it.previousIndex());
        Assertions.assertEquals((int)3, (int)it.nextIndex());
        Assertions.assertEquals((Object)"4", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)3, (int)it.previousIndex());
        Assertions.assertEquals((int)4, (int)it.nextIndex());
        Assertions.assertEquals((Object)"5", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)4, (int)it.previousIndex());
        Assertions.assertEquals((int)5, (int)it.nextIndex());
        Assertions.assertEquals((Object)"5", it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)3, (int)it.previousIndex());
        Assertions.assertEquals((int)4, (int)it.nextIndex());
        Assertions.assertEquals((Object)"4", it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)2, (int)it.previousIndex());
        Assertions.assertEquals((int)3, (int)it.nextIndex());
        Assertions.assertEquals((Object)"3", it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)1, (int)it.previousIndex());
        Assertions.assertEquals((int)2, (int)it.nextIndex());
        Assertions.assertEquals((Object)"2", it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)0, (int)it.previousIndex());
        Assertions.assertEquals((int)1, (int)it.nextIndex());
        Assertions.assertEquals((Object)"1", it.previous());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((int)-1, (int)it.previousIndex());
        Assertions.assertEquals((int)0, (int)it.nextIndex());
    }

    @Test
    public void testListIteratorRemove() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        ListIterator it = this.list.listIterator();
        try {
            it.remove();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)"1", it.next());
        Assertions.assertEquals((Object)"2", it.next());
        Assertions.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)this.list.toString());
        it.remove();
        Assertions.assertEquals((Object)"[1, 3, 4, 5]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"3", it.next());
        Assertions.assertEquals((Object)"3", it.previous());
        Assertions.assertEquals((Object)"1", it.previous());
        it.remove();
        Assertions.assertEquals((Object)"[3, 4, 5]", (Object)this.list.toString());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"3", it.next());
        it.remove();
        Assertions.assertEquals((Object)"[4, 5]", (Object)this.list.toString());
        try {
            it.remove();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)"4", it.next());
        Assertions.assertEquals((Object)"5", it.next());
        it.remove();
        Assertions.assertEquals((Object)"[4]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"4", it.previous());
        it.remove();
        Assertions.assertEquals((Object)"[]", (Object)this.list.toString());
    }

    @Override
    @Test
    public void testListIteratorSet() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        ListIterator it = this.list.listIterator();
        Assertions.assertEquals((Object)"1", it.next());
        it.set("a");
        Assertions.assertEquals((Object)"a", it.previous());
        it.set("A");
        Assertions.assertEquals((Object)"A", it.next());
        Assertions.assertEquals((Object)"2", it.next());
        it.set("B");
        Assertions.assertEquals((Object)"3", it.next());
        Assertions.assertEquals((Object)"4", it.next());
        it.set("D");
        Assertions.assertEquals((Object)"5", it.next());
        it.set("E");
        Assertions.assertEquals((Object)"[A, B, 3, D, E]", (Object)this.list.toString());
    }

    @Test
    public void testLongSerialization() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            this.list.add((Object)i);
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buf);
        out.writeObject(this.list);
        out.flush();
        out.close();
        ByteArrayInputStream bufin = new ByteArrayInputStream(buf.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bufin);
        Object list2 = in.readObject();
        Assertions.assertNotSame(this.list, (Object)list2);
        Assertions.assertEquals((Object)list2, this.list);
        Assertions.assertEquals(this.list, (Object)list2);
    }

    @Test
    public void testRemove() {
        this.list.add((Object)"1");
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        Assertions.assertEquals((Object)"[1, 1, 2, 3, 4, 5, 2, 3, 4, 5]", (Object)this.list.toString());
        Assertions.assertFalse((boolean)this.list.remove((Object)"6"));
        Assertions.assertTrue((boolean)this.list.remove((Object)"5"));
        Assertions.assertEquals((Object)"[1, 1, 2, 3, 4, 2, 3, 4, 5]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.remove((Object)"5"));
        Assertions.assertEquals((Object)"[1, 1, 2, 3, 4, 2, 3, 4]", (Object)this.list.toString());
        Assertions.assertFalse((boolean)this.list.remove((Object)"5"));
        Assertions.assertTrue((boolean)this.list.remove((Object)"1"));
        Assertions.assertEquals((Object)"[1, 2, 3, 4, 2, 3, 4]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.remove((Object)"1"));
        Assertions.assertEquals((Object)"[2, 3, 4, 2, 3, 4]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.remove((Object)"2"));
        Assertions.assertEquals((Object)"[3, 4, 2, 3, 4]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.remove((Object)"2"));
        Assertions.assertEquals((Object)"[3, 4, 3, 4]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.remove((Object)"3"));
        Assertions.assertEquals((Object)"[4, 3, 4]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.remove((Object)"3"));
        Assertions.assertEquals((Object)"[4, 4]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.remove((Object)"4"));
        Assertions.assertEquals((Object)"[4]", (Object)this.list.toString());
        Assertions.assertTrue((boolean)this.list.remove((Object)"4"));
        Assertions.assertEquals((Object)"[]", (Object)this.list.toString());
    }

    @Test
    public void testRemoveAll() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        HashSet<String> set = new HashSet<String>();
        set.add("A");
        set.add("2");
        set.add("C");
        set.add("4");
        set.add("D");
        Assertions.assertTrue((boolean)this.list.removeAll(set));
        Assertions.assertEquals((Object)"[1, 3, 5]", (Object)this.list.toString());
        Assertions.assertFalse((boolean)this.list.removeAll(set));
    }

    @Test
    public void testRemoveByIndex() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        Assertions.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"1", (Object)this.list.remove(0));
        Assertions.assertEquals((Object)"[2, 3, 4, 5]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"3", (Object)this.list.remove(1));
        Assertions.assertEquals((Object)"[2, 4, 5]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"4", (Object)this.list.remove(1));
        Assertions.assertEquals((Object)"[2, 5]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"5", (Object)this.list.remove(1));
        Assertions.assertEquals((Object)"[2]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"2", (Object)this.list.remove(0));
        Assertions.assertEquals((Object)"[]", (Object)this.list.toString());
    }

    @Test
    public void testRetainAll() {
        this.list.add((Object)"1");
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        this.list.add((Object)"5");
        HashSet<String> set = new HashSet<String>();
        set.add("A");
        set.add("2");
        set.add("C");
        set.add("4");
        set.add("D");
        Assertions.assertTrue((boolean)this.list.retainAll(set));
        Assertions.assertEquals((Object)"[2, 2, 4, 4]", (Object)this.list.toString());
        Assertions.assertFalse((boolean)this.list.retainAll(set));
    }

    @Test
    public void testSerialization() throws Exception {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buf);
        out.writeObject(this.list);
        out.flush();
        out.close();
        ByteArrayInputStream bufIn = new ByteArrayInputStream(buf.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bufIn);
        Object list2 = in.readObject();
        Assertions.assertNotSame(this.list, (Object)list2);
        Assertions.assertEquals((Object)list2, this.list);
        Assertions.assertEquals(this.list, (Object)list2);
    }

    @Test
    public void testSerializationWithOpenCursor() throws Exception {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buf);
        out.writeObject(this.list);
        out.flush();
        out.close();
        ByteArrayInputStream bufin = new ByteArrayInputStream(buf.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bufin);
        Object list2 = in.readObject();
        Assertions.assertNotSame(this.list, (Object)list2);
        Assertions.assertEquals((Object)list2, this.list);
        Assertions.assertEquals(this.list, (Object)list2);
    }

    @Test
    public void testSet() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        Assertions.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)this.list.toString());
        this.list.set(0, (Object)"A");
        Assertions.assertEquals((Object)"[A, 2, 3, 4, 5]", (Object)this.list.toString());
        this.list.set(1, (Object)"B");
        Assertions.assertEquals((Object)"[A, B, 3, 4, 5]", (Object)this.list.toString());
        this.list.set(2, (Object)"C");
        Assertions.assertEquals((Object)"[A, B, C, 4, 5]", (Object)this.list.toString());
        this.list.set(3, (Object)"D");
        Assertions.assertEquals((Object)"[A, B, C, D, 5]", (Object)this.list.toString());
        this.list.set(4, (Object)"E");
        Assertions.assertEquals((Object)"[A, B, C, D, E]", (Object)this.list.toString());
    }

    @Test
    public void testSubList() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        Assertions.assertEquals((Object)"[A, B, C, D, E]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"[A, B, C, D, E]", (Object)this.list.subList(0, 5).toString());
        Assertions.assertEquals((Object)"[B, C, D, E]", (Object)this.list.subList(1, 5).toString());
        Assertions.assertEquals((Object)"[C, D, E]", (Object)this.list.subList(2, 5).toString());
        Assertions.assertEquals((Object)"[D, E]", (Object)this.list.subList(3, 5).toString());
        Assertions.assertEquals((Object)"[E]", (Object)this.list.subList(4, 5).toString());
        Assertions.assertEquals((Object)"[]", (Object)this.list.subList(5, 5).toString());
    }

    @Test
    public void testSubListAddBegin() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        List sublist = this.list.subList(0, 0);
        sublist.add("a");
        Assertions.assertEquals((Object)"[a, A, B, C, D, E]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"[a]", (Object)sublist.toString());
        sublist.add("b");
        Assertions.assertEquals((Object)"[a, b, A, B, C, D, E]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"[a, b]", (Object)sublist.toString());
    }

    @Test
    public void testSubListAddEnd() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        List sublist = this.list.subList(5, 5);
        sublist.add("F");
        Assertions.assertEquals((Object)"[A, B, C, D, E, F]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"[F]", (Object)sublist.toString());
        sublist.add("G");
        Assertions.assertEquals((Object)"[A, B, C, D, E, F, G]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"[F, G]", (Object)sublist.toString());
    }

    @Test
    public void testSubListAddMiddle() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        List sublist = this.list.subList(1, 3);
        sublist.add("a");
        Assertions.assertEquals((Object)"[A, B, C, a, D, E]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"[B, C, a]", (Object)sublist.toString());
        sublist.add("b");
        Assertions.assertEquals((Object)"[A, B, C, a, b, D, E]", (Object)this.list.toString());
        Assertions.assertEquals((Object)"[B, C, a, b]", (Object)sublist.toString());
    }

    @Test
    public void testSubListRemove() {
        this.list.add((Object)"A");
        this.list.add((Object)"B");
        this.list.add((Object)"C");
        this.list.add((Object)"D");
        this.list.add((Object)"E");
        List sublist = this.list.subList(1, 4);
        Assertions.assertEquals((Object)"[B, C, D]", (Object)sublist.toString());
        Assertions.assertEquals((Object)"[A, B, C, D, E]", (Object)this.list.toString());
        sublist.remove("C");
        Assertions.assertEquals((Object)"[B, D]", (Object)sublist.toString());
        Assertions.assertEquals((Object)"[A, B, D, E]", (Object)this.list.toString());
        sublist.remove(1);
        Assertions.assertEquals((Object)"[B]", (Object)sublist.toString());
        Assertions.assertEquals((Object)"[A, B, E]", (Object)this.list.toString());
        sublist.clear();
        Assertions.assertEquals((Object)"[]", (Object)sublist.toString());
        Assertions.assertEquals((Object)"[A, E]", (Object)this.list.toString());
    }

    @Test
    public void testToArray() {
        this.list.add((Object)"1");
        this.list.add((Object)"2");
        this.list.add((Object)"3");
        this.list.add((Object)"4");
        this.list.add((Object)"5");
        Object[] elts = this.list.toArray();
        Assertions.assertEquals((Object)"1", (Object)elts[0]);
        Assertions.assertEquals((Object)"2", (Object)elts[1]);
        Assertions.assertEquals((Object)"3", (Object)elts[2]);
        Assertions.assertEquals((Object)"4", (Object)elts[3]);
        Assertions.assertEquals((Object)"5", (Object)elts[4]);
        Assertions.assertEquals((int)5, (int)elts.length);
        String[] elts2 = (String[])this.list.toArray((Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        Assertions.assertEquals((Object)"1", (Object)elts2[0]);
        Assertions.assertEquals((Object)"2", (Object)elts2[1]);
        Assertions.assertEquals((Object)"3", (Object)elts2[2]);
        Assertions.assertEquals((Object)"4", (Object)elts2[3]);
        Assertions.assertEquals((Object)"5", (Object)elts2[4]);
        Assertions.assertEquals((int)5, (int)elts2.length);
        Object[] elts3 = new String[5];
        Assertions.assertSame((Object)elts3, (Object)this.list.toArray(elts3));
        Assertions.assertEquals((Object)"1", (Object)elts3[0]);
        Assertions.assertEquals((Object)"2", (Object)elts3[1]);
        Assertions.assertEquals((Object)"3", (Object)elts3[2]);
        Assertions.assertEquals((Object)"4", (Object)elts3[3]);
        Assertions.assertEquals((Object)"5", (Object)elts3[4]);
        Assertions.assertEquals((int)5, (int)elts3.length);
        Object[] elts4 = new String[3];
        String[] elts4b = (String[])this.list.toArray(elts4);
        Assertions.assertNotSame((Object)elts4, (Object)elts4b);
        Assertions.assertEquals((Object)"1", (Object)elts4b[0]);
        Assertions.assertEquals((Object)"2", (Object)elts4b[1]);
        Assertions.assertEquals((Object)"3", (Object)elts4b[2]);
        Assertions.assertEquals((Object)"4", (Object)elts4b[3]);
        Assertions.assertEquals((Object)"5", (Object)elts4b[4]);
        Assertions.assertEquals((int)5, (int)elts4b.length);
    }
}

