/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractListIteratorTest;
import org.apache.commons.collections4.iterators.SingletonListIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SingletonListIteratorTest<E>
extends AbstractListIteratorTest<E> {
    private static final Object testValue = "foo";

    public SingletonListIteratorTest() {
        super(SingletonListIteratorTest.class.getSimpleName());
    }

    @Override
    public SingletonListIterator<E> makeEmptyIterator() {
        SingletonListIterator<E> iter = this.makeObject();
        iter.next();
        iter.remove();
        iter.reset();
        return iter;
    }

    @Override
    public SingletonListIterator<E> makeObject() {
        return new SingletonListIterator(testValue);
    }

    @Override
    public boolean supportsAdd() {
        return false;
    }

    @Override
    public boolean supportsEmptyIterator() {
        return true;
    }

    @Override
    public boolean supportsRemove() {
        return true;
    }

    @Test
    public void testIterator() {
        SingletonListIterator<E> iter = this.makeObject();
        Assertions.assertTrue((boolean)iter.hasNext(), (String)"Iterator should have next item");
        Assertions.assertFalse((boolean)iter.hasPrevious(), (String)"Iterator should have no previous item");
        Assertions.assertEquals((int)0, (int)iter.nextIndex(), (String)"Iteration next index");
        Assertions.assertEquals((int)-1, (int)iter.previousIndex(), (String)"Iteration previous index");
        Object iterValue = iter.next();
        Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Iterator should have no next item");
        Assertions.assertTrue((boolean)iter.hasPrevious(), (String)"Iterator should have previous item");
        Assertions.assertEquals((int)1, (int)iter.nextIndex(), (String)"Iteration next index");
        Assertions.assertEquals((int)0, (int)iter.previousIndex(), (String)"Iteration previous index");
        iterValue = iter.previous();
        Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        Assertions.assertTrue((boolean)iter.hasNext(), (String)"Iterator should have next item");
        Assertions.assertFalse((boolean)iter.hasPrevious(), (String)"Iterator should have no previous item");
        Assertions.assertEquals((int)0, (int)iter.nextIndex(), (String)"Iteration next index");
        Assertions.assertEquals((int)-1, (int)iter.previousIndex(), (String)"Iteration previous index");
        iterValue = iter.next();
        Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Iterator should have no next item");
        Assertions.assertTrue((boolean)iter.hasPrevious(), (String)"Iterator should have previous item");
        Assertions.assertEquals((int)1, (int)iter.nextIndex(), (String)"Iteration next index");
        Assertions.assertEquals((int)0, (int)iter.previousIndex(), (String)"Iteration previous index");
        try {
            iter.next();
        }
        catch (Exception e) {
            Assertions.assertEquals(e.getClass(), new NoSuchElementException().getClass(), (String)"NoSuchElementException must be thrown");
        }
        iter.previous();
        try {
            iter.previous();
        }
        catch (Exception e) {
            Assertions.assertEquals(e.getClass(), new NoSuchElementException().getClass(), (String)"NoSuchElementException must be thrown");
        }
    }

    @Test
    public void testReset() {
        SingletonListIterator<E> it = this.makeObject();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)testValue, (Object)it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        it.reset();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)testValue, (Object)it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        it.reset();
        it.reset();
        Assertions.assertTrue((boolean)it.hasNext());
    }
}

