/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.LazyIteratorChain;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class LazyIteratorChainTest
extends AbstractIteratorTest<String> {
    protected String[] testArray = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
    protected List<String> list1;
    protected List<String> list2;
    protected List<String> list3;

    public LazyIteratorChainTest() {
        super(LazyIteratorChainTest.class.getSimpleName());
    }

    @Override
    public LazyIteratorChain<String> makeEmptyIterator() {
        return new LazyIteratorChain<String>(){

            protected Iterator<String> nextIterator(int count) {
                return null;
            }
        };
    }

    @Override
    public LazyIteratorChain<String> makeObject() {
        return new LazyIteratorChain<String>(){

            protected Iterator<String> nextIterator(int count) {
                switch (count) {
                    case 1: {
                        return LazyIteratorChainTest.this.list1.iterator();
                    }
                    case 2: {
                        return LazyIteratorChainTest.this.list2.iterator();
                    }
                    case 3: {
                        return LazyIteratorChainTest.this.list3.iterator();
                    }
                }
                return null;
            }
        };
    }

    @BeforeEach
    public void setUp() {
        this.list1 = new ArrayList<String>();
        this.list1.add("One");
        this.list1.add("Two");
        this.list1.add("Three");
        this.list2 = new ArrayList<String>();
        this.list2.add("Four");
        this.list3 = new ArrayList<String>();
        this.list3.add("Five");
        this.list3.add("Six");
    }

    @Test
    public void testEmptyChain() {
        LazyIteratorChain<String> chain = this.makeEmptyIterator();
        Assertions.assertFalse((boolean)chain.hasNext());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NoSuchElementException.class, () -> chain.next()), () -> Assertions.assertThrows(IllegalStateException.class, () -> chain.remove())});
    }

    @Test
    public void testFirstIteratorIsEmptyBug() {
        final ArrayList empty = new ArrayList();
        final ArrayList<String> notEmpty = new ArrayList<String>();
        notEmpty.add("A");
        notEmpty.add("B");
        notEmpty.add("C");
        LazyIteratorChain<String> chain = new LazyIteratorChain<String>(){

            protected Iterator<String> nextIterator(int count) {
                switch (count) {
                    case 1: {
                        return empty.iterator();
                    }
                    case 2: {
                        return notEmpty.iterator();
                    }
                }
                return null;
            }
        };
        Assertions.assertTrue((boolean)chain.hasNext(), (String)"should have next");
        Assertions.assertEquals((Object)"A", (Object)chain.next());
        Assertions.assertTrue((boolean)chain.hasNext(), (String)"should have next");
        Assertions.assertEquals((Object)"B", (Object)chain.next());
        Assertions.assertTrue((boolean)chain.hasNext(), (String)"should have next");
        Assertions.assertEquals((Object)"C", (Object)chain.next());
        Assertions.assertFalse((boolean)chain.hasNext(), (String)"should not have next");
    }

    @Test
    public void testIterator() {
        LazyIteratorChain<String> iter = this.makeObject();
        for (String testValue : this.testArray) {
            Object iterValue = iter.next();
            Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        }
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Iterator should now be empty");
        try {
            iter.next();
        }
        catch (Exception e) {
            Assertions.assertEquals(e.getClass(), new NoSuchElementException().getClass(), (String)"NoSuchElementException must be thrown");
        }
    }

    @Override
    @Test
    public void testRemove() {
        LazyIteratorChain<String> iter = this.makeObject();
        Assertions.assertThrows(IllegalStateException.class, () -> iter.remove(), (String)"Calling remove before the first call to next() should throw an exception");
        for (String testValue : this.testArray) {
            String iterValue = (String)iter.next();
            Assertions.assertEquals((Object)testValue, (Object)iterValue, (String)"Iteration value is correct");
            if (iterValue.equals("Four")) continue;
            iter.remove();
        }
        Assertions.assertTrue((boolean)this.list1.isEmpty(), (String)"List is empty");
        Assertions.assertEquals((int)1, (int)this.list2.size(), (String)"List is empty");
        Assertions.assertTrue((boolean)this.list3.isEmpty(), (String)"List is empty");
    }

    @Test
    public void testRemoveFromFilteredIterator() {
        Predicate myPredicate = i -> i.compareTo(4) < 0;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        list1.add(1);
        list1.add(2);
        list2.add(3);
        list2.add(4);
        Iterator it1 = IteratorUtils.filteredIterator(list1.iterator(), (Predicate)myPredicate);
        Iterator it2 = IteratorUtils.filteredIterator(list2.iterator(), (Predicate)myPredicate);
        Iterator it = IteratorUtils.chainedIterator((Iterator)it1, (Iterator)it2);
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        Assertions.assertEquals((int)0, (int)list1.size());
        Assertions.assertEquals((int)1, (int)list2.size());
    }
}

