/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.AbstractIndexExtractorTest;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class IndexExtractorFromBitmapExtractorTest
extends AbstractIndexExtractorTest {
    @Override
    protected IndexExtractor createEmptyExtractor() {
        TestingBitMapExtractor testingBitMapExtractor = new TestingBitMapExtractor(new long[0]);
        return IndexExtractor.fromBitMapExtractor((BitMapExtractor)testingBitMapExtractor);
    }

    @Override
    protected IndexExtractor createExtractor() {
        TestingBitMapExtractor testingBitMapExtractor = new TestingBitMapExtractor(new long[]{1L, 2L, 3L});
        return IndexExtractor.fromBitMapExtractor((BitMapExtractor)testingBitMapExtractor);
    }

    @Override
    protected int getAsIndexArrayBehaviour() {
        return 3;
    }

    @Override
    protected int[] getExpectedIndices() {
        return new int[]{0, 65, 128, 129};
    }

    @Test
    public final void testFromBitMapExtractor() {
        IndexExtractor underTest = this.createExtractor();
        ArrayList lst = new ArrayList();
        underTest.processIndices(lst::add);
        Assert.assertEquals((long)4L, (long)lst.size());
        Assert.assertEquals((Object)0, lst.get(0));
        Assert.assertEquals((Object)65, lst.get(1));
        Assert.assertEquals((Object)128, lst.get(2));
        Assert.assertEquals((Object)129, lst.get(3));
        TestingBitMapExtractor bitMapExtractor = new TestingBitMapExtractor(new long[]{-1L});
        underTest = IndexExtractor.fromBitMapExtractor((BitMapExtractor)bitMapExtractor);
        lst = new ArrayList();
        underTest.processIndices(lst::add);
        Assert.assertEquals((long)64L, (long)lst.size());
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((Object)i, lst.get(i));
        }
    }

    private static final class TestingBitMapExtractor
    implements BitMapExtractor {
        long[] values;

        TestingBitMapExtractor(long[] values) {
            this.values = values;
        }

        public boolean processBitMaps(LongPredicate consumer) {
            for (long l : this.values) {
                if (consumer.test(l)) continue;
                return false;
            }
            return true;
        }
    }
}

