/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Arrays;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.bag.AbstractSortedBagTest;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.bag.UnmodifiableSortedBag;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableSortedBagTest<E>
extends AbstractSortedBagTest<E> {
    public UnmodifiableSortedBagTest() {
        super(UnmodifiableSortedBagTest.class.getSimpleName());
    }

    @Override
    public SortedBag<E> getCollection() {
        return super.getCollection();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public SortedBag<E> makeFullCollection() {
        TreeBag bag = new TreeBag();
        bag.addAll(Arrays.asList(this.getFullElements()));
        return UnmodifiableSortedBag.unmodifiableSortedBag((SortedBag)bag);
    }

    @Override
    public SortedBag<E> makeObject() {
        return UnmodifiableSortedBag.unmodifiableSortedBag((SortedBag)new TreeBag());
    }

    @Test
    public void testDecorateFactory() {
        SortedBag<E> queue = this.makeFullCollection();
        Assertions.assertSame(queue, (Object)UnmodifiableSortedBag.unmodifiableSortedBag(queue));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableSortedBag.unmodifiableSortedBag(null));
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }
}

