/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Comparator;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.bag.AbstractSortedBagTest;
import org.apache.commons.collections4.bag.PredicatedSortedBag;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.functors.TruePredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicatedSortedBagTest<T>
extends AbstractSortedBagTest<T> {
    private final SortedBag<T> nullBag = null;
    protected Predicate<T> truePredicate = TruePredicate.truePredicate();

    public PredicatedSortedBagTest() {
        super(PredicatedSortedBagTest.class.getSimpleName());
    }

    protected SortedBag<T> decorateBag(SortedBag<T> bag, Predicate<T> predicate) {
        return PredicatedSortedBag.predicatedSortedBag(bag, predicate);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public SortedBag<T> makeObject() {
        return this.decorateBag((SortedBag<T>)new TreeBag(), this.truePredicate);
    }

    protected SortedBag<T> makeTestBag() {
        return this.decorateBag((SortedBag<T>)new TreeBag(), this.stringPredicate());
    }

    protected Predicate<T> stringPredicate() {
        return String.class::isInstance;
    }

    @Test
    public void testDecorate() {
        SortedBag<T> bag = this.decorateBag((SortedBag<T>)new TreeBag(), this.stringPredicate());
        ((PredicatedSortedBag)bag).decorated();
        Assertions.assertThrows(NullPointerException.class, () -> this.decorateBag((SortedBag<T>)new TreeBag(), null));
        Assertions.assertThrows(NullPointerException.class, () -> this.decorateBag(this.nullBag, this.stringPredicate()));
    }

    @Test
    public void testSortOrder() {
        SortedBag<T> bag = this.decorateBag((SortedBag<T>)new TreeBag(), this.stringPredicate());
        String one = "one";
        String two = "two";
        String three = "three";
        bag.add((Object)"one");
        bag.add((Object)"two");
        bag.add((Object)"three");
        Assertions.assertEquals((Object)bag.first(), (Object)"one", (String)"first element");
        Assertions.assertEquals((Object)bag.last(), (Object)"two", (String)"last element");
        Comparator c = bag.comparator();
        Assertions.assertNull((Object)c, (String)"natural order, so comparator should be null");
    }
}

