/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.Get;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.Put;
import org.apache.commons.collections4.SplitMapUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.functors.NOPTransformer;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.collections4.splitmap.TransformedSplitMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SplitMapUtilsTest {
    private Map<String, Integer> backingMap;
    private TransformedSplitMap<String, String, String, Integer> transformedMap;
    private final Transformer<String, Integer> stringToInt = Integer::valueOf;

    private void attemptGetOperation(Runnable r) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> r.run(), (String)"Put exposed as writable Map must not allow Get operations");
    }

    private void attemptPutOperation(Runnable r) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> r.run(), (String)"Get exposed as writable Map must not allow Put operations");
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.backingMap = new HashMap<String, Integer>();
        this.transformedMap = TransformedSplitMap.transformingMap(this.backingMap, (Transformer)NOPTransformer.nopTransformer(), this.stringToInt);
        for (int i = 0; i < 10; ++i) {
            this.transformedMap.put((Object)String.valueOf(i), (Object)String.valueOf(i));
        }
    }

    @Test
    public void testAlreadyReadableMap() {
        HashedMap hashedMap = new HashedMap();
        Assertions.assertSame((Object)hashedMap, (Object)SplitMapUtils.readableMap((Get)hashedMap));
    }

    @Test
    public void testAlreadyWritableMap() {
        HashedMap hashedMap = new HashedMap();
        Assertions.assertSame((Object)hashedMap, (Object)SplitMapUtils.writableMap((Put)hashedMap));
    }

    @Test
    public void testReadableMap() {
        IterableMap map = SplitMapUtils.readableMap(this.transformedMap);
        for (int i = 0; i < 10; ++i) {
            Assertions.assertFalse((boolean)map.containsValue((Object)String.valueOf(i)));
            Assertions.assertEquals((int)i, (int)((Integer)map.get((Object)String.valueOf(i))));
        }
        MapIterator it = map.mapIterator();
        while (it.hasNext()) {
            String k = (String)it.next();
            Assertions.assertEquals((Object)k, (Object)it.getKey());
            Assertions.assertEquals((Integer)Integer.valueOf(k), (Integer)((Integer)it.getValue()));
        }
        Assertions.assertTrue((boolean)(map instanceof Unmodifiable));
        int sz = map.size();
        this.attemptPutOperation(() -> map.clear());
        Assertions.assertEquals((int)sz, (int)map.size());
        this.attemptPutOperation(() -> map.put((Object)"foo", (Object)100));
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("foo", 100);
        m.put("bar", 200);
        m.put("baz", 300);
        this.attemptPutOperation(() -> map.putAll((Map)m));
        IterableMap other = SplitMapUtils.readableMap(this.transformedMap);
        Assertions.assertEquals((Object)other, (Object)map);
        Assertions.assertEquals((int)other.hashCode(), (int)map.hashCode());
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)map.remove((Object)String.valueOf(i))));
            Assertions.assertEquals((int)(--sz), (int)map.size());
        }
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertSame((Object)map, (Object)SplitMapUtils.readableMap((Get)map));
    }

    @Test
    public void testWritableMap() {
        Map map = SplitMapUtils.writableMap(this.transformedMap);
        this.attemptGetOperation(() -> map.get(null));
        this.attemptGetOperation(map::entrySet);
        this.attemptGetOperation(map::keySet);
        this.attemptGetOperation(map::values);
        this.attemptGetOperation(map::size);
        this.attemptGetOperation(map::isEmpty);
        this.attemptGetOperation(() -> map.containsKey(null));
        this.attemptGetOperation(() -> map.containsValue(null));
        this.attemptGetOperation(() -> map.remove(null));
        Map other = SplitMapUtils.writableMap(this.transformedMap);
        Assertions.assertEquals((Object)other, (Object)map);
        Assertions.assertEquals((int)other.hashCode(), (int)map.hashCode());
        int sz = this.backingMap.size();
        Assertions.assertFalse((boolean)this.backingMap.containsKey("foo"));
        map.put("new", "66");
        Assertions.assertEquals((int)(++sz), (int)this.backingMap.size());
        HashMap<String, String> more = new HashMap<String, String>();
        more.put("foo", "77");
        more.put("bar", "88");
        more.put("baz", "99");
        map.putAll(more);
        Assertions.assertEquals((int)(sz + more.size()), (int)this.backingMap.size());
        map.clear();
        Assertions.assertTrue((boolean)this.backingMap.isEmpty());
        Assertions.assertSame((Object)map, (Object)SplitMapUtils.writableMap((Put)((Put)map)));
    }
}

