/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.TestUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.functors.AbstractPredicateTest;
import org.apache.commons.collections4.functors.AllPredicate;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.functors.ExceptionPredicate;
import org.apache.commons.collections4.functors.FalsePredicate;
import org.apache.commons.collections4.functors.NotNullPredicate;
import org.apache.commons.collections4.functors.NullPredicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicateUtilsTest
extends AbstractPredicateTest {
    @Override
    protected Predicate<?> generatePredicate() {
        return TruePredicate.truePredicate();
    }

    @Test
    public void testAllPredicate() {
        this.assertPredicateTrue(AllPredicate.allPredicate((Predicate[])new Predicate[0]), null);
        Assertions.assertTrue((boolean)AllPredicate.allPredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), TruePredicate.truePredicate(), TruePredicate.truePredicate()}).test(null));
        Assertions.assertFalse((boolean)AllPredicate.allPredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).test(null));
        Assertions.assertFalse((boolean)AllPredicate.allPredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).test(null));
        Assertions.assertFalse((boolean)AllPredicate.allPredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        ArrayList<Predicate> coll = new ArrayList<Predicate>();
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertTrue((boolean)AllPredicate.allPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertFalse((boolean)AllPredicate.allPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertFalse((boolean)AllPredicate.allPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        Assertions.assertFalse((boolean)AllPredicate.allPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        this.assertPredicateFalse(AllPredicate.allPredicate(coll), null);
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        this.assertPredicateTrue(AllPredicate.allPredicate(coll), null);
        coll.clear();
        this.assertPredicateTrue(AllPredicate.allPredicate(coll), null);
    }

    @Test
    public void testAllPredicateEx1() {
        Assertions.assertThrows(NullPointerException.class, () -> AllPredicate.allPredicate((Predicate[])null));
    }

    @Test
    public void testAllPredicateEx2() {
        Assertions.assertThrows(NullPointerException.class, () -> AllPredicate.allPredicate((Predicate[])new Predicate[]{null}));
    }

    @Test
    public void testAllPredicateEx3() {
        Assertions.assertThrows(NullPointerException.class, () -> AllPredicate.allPredicate((Predicate[])new Predicate[]{null, null}));
    }

    @Test
    public void testAllPredicateEx4() {
        Assertions.assertThrows(NullPointerException.class, () -> AllPredicate.allPredicate((Collection)null));
    }

    @Test
    public void testAllPredicateEx5() {
        AllPredicate.allPredicate(Collections.emptyList());
    }

    @Test
    public void testAllPredicateEx6() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        Assertions.assertThrows(NullPointerException.class, () -> AllPredicate.allPredicate((Collection)coll));
    }

    @Test
    public void testAndPredicate() {
        Assertions.assertTrue((boolean)PredicateUtils.andPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.andPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.andPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.andPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
    }

    @Test
    public void testAndPredicateEx() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.andPredicate(null, null));
    }

    @Test
    public void testAnyPredicate() {
        this.assertPredicateFalse(PredicateUtils.anyPredicate((Predicate[])new Predicate[0]), null);
        Assertions.assertTrue((boolean)PredicateUtils.anyPredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), TruePredicate.truePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.anyPredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.anyPredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.anyPredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        ArrayList<Predicate> coll = new ArrayList<Predicate>();
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertTrue((boolean)PredicateUtils.anyPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertTrue((boolean)PredicateUtils.anyPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertTrue((boolean)PredicateUtils.anyPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        Assertions.assertFalse((boolean)PredicateUtils.anyPredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        this.assertPredicateFalse(PredicateUtils.anyPredicate(coll), null);
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        this.assertPredicateTrue(PredicateUtils.anyPredicate(coll), null);
        coll.clear();
        this.assertPredicateFalse(PredicateUtils.anyPredicate(coll), null);
    }

    @Test
    public void testAnyPredicateEx1() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.anyPredicate((Predicate[])null));
    }

    @Test
    public void testAnyPredicateEx2() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.anyPredicate((Predicate[])new Predicate[]{null}));
    }

    @Test
    public void testAnyPredicateEx3() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.anyPredicate((Predicate[])new Predicate[]{null, null}));
    }

    @Test
    public void testAnyPredicateEx4() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.anyPredicate((Collection)null));
    }

    @Test
    public void testAnyPredicateEx5() {
        PredicateUtils.anyPredicate(Collections.emptyList());
    }

    @Test
    public void testAnyPredicateEx6() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.anyPredicate((Collection)coll));
    }

    @Test
    public void testAsPredicateTransformer() {
        Assertions.assertFalse((boolean)PredicateUtils.asPredicate((Transformer)TransformerUtils.nopTransformer()).evaluate((Object)false));
        Assertions.assertTrue((boolean)PredicateUtils.asPredicate((Transformer)TransformerUtils.nopTransformer()).evaluate((Object)true));
    }

    @Test
    public void testAsPredicateTransformerEx1() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.asPredicate(null));
    }

    @Test
    public void testAsPredicateTransformerEx2() {
        Assertions.assertThrows(FunctorException.class, () -> PredicateUtils.asPredicate((Transformer)TransformerUtils.nopTransformer()).evaluate(null));
    }

    @Test
    public void testEitherPredicate() {
        Assertions.assertFalse((boolean)PredicateUtils.eitherPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.eitherPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.eitherPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.eitherPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
    }

    @Test
    public void testEitherPredicateEx() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.eitherPredicate(null, null));
    }

    @Test
    public void testExceptionPredicate() {
        Assertions.assertNotNull((Object)PredicateUtils.exceptionPredicate());
        Assertions.assertSame((Object)PredicateUtils.exceptionPredicate(), (Object)PredicateUtils.exceptionPredicate());
        Assertions.assertThrows(FunctorException.class, () -> PredicateUtils.exceptionPredicate().evaluate(null));
        Assertions.assertThrows(FunctorException.class, () -> PredicateUtils.exceptionPredicate().evaluate((Object)this.cString));
    }

    @Test
    public void testFalsePredicate() {
        Assertions.assertNotNull((Object)FalsePredicate.falsePredicate());
        Assertions.assertSame((Object)FalsePredicate.falsePredicate(), (Object)FalsePredicate.falsePredicate());
        Assertions.assertFalse((boolean)FalsePredicate.falsePredicate().evaluate(null));
        Assertions.assertFalse((boolean)FalsePredicate.falsePredicate().evaluate(this.cObject));
        Assertions.assertFalse((boolean)FalsePredicate.falsePredicate().evaluate((Object)this.cString));
        Assertions.assertFalse((boolean)FalsePredicate.falsePredicate().evaluate((Object)this.cInteger));
    }

    @Test
    public void testIdentityPredicate() {
        Assertions.assertSame((Object)NullPredicate.nullPredicate(), (Object)PredicateUtils.identityPredicate(null));
        Assertions.assertNotNull((Object)PredicateUtils.identityPredicate((Object)6));
        Assertions.assertFalse((boolean)PredicateUtils.identityPredicate((Object)6).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.identityPredicate((Object)6).evaluate(this.cObject));
        Assertions.assertFalse((boolean)PredicateUtils.identityPredicate((Object)6).evaluate((Object)this.cString));
        Assertions.assertTrue((boolean)PredicateUtils.identityPredicate((Object)6).evaluate((Object)this.cInteger));
        Assertions.assertTrue((boolean)PredicateUtils.identityPredicate((Object)this.cInteger).evaluate((Object)this.cInteger));
    }

    @Test
    public void testInstanceOfPredicate() {
        Assertions.assertNotNull((Object)PredicateUtils.instanceofPredicate(String.class));
        Assertions.assertFalse((boolean)PredicateUtils.instanceofPredicate(String.class).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.instanceofPredicate(String.class).evaluate(this.cObject));
        Assertions.assertTrue((boolean)PredicateUtils.instanceofPredicate(String.class).evaluate((Object)this.cString));
        Assertions.assertFalse((boolean)PredicateUtils.instanceofPredicate(String.class).evaluate((Object)this.cInteger));
    }

    @Test
    public void testInvokerPredicate() {
        ArrayList<Object> list = new ArrayList<Object>();
        Assertions.assertTrue((boolean)PredicateUtils.invokerPredicate((String)"isEmpty").evaluate(list));
        list.add(new Object());
        Assertions.assertFalse((boolean)PredicateUtils.invokerPredicate((String)"isEmpty").evaluate(list));
    }

    @Test
    public void testInvokerPredicate2() {
        ArrayList<String> list = new ArrayList<String>();
        Assertions.assertFalse((boolean)PredicateUtils.invokerPredicate((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{this.cString}).evaluate(list));
        list.add(this.cString);
        Assertions.assertTrue((boolean)PredicateUtils.invokerPredicate((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{this.cString}).evaluate(list));
    }

    @Test
    public void testInvokerPredicate2Ex1() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.invokerPredicate(null, null, null));
    }

    @Test
    public void testInvokerPredicate2Ex2() {
        Assertions.assertThrows(FunctorException.class, () -> PredicateUtils.invokerPredicate((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{this.cString}).evaluate(null));
    }

    @Test
    public void testInvokerPredicate2Ex3() {
        Assertions.assertThrows(FunctorException.class, () -> PredicateUtils.invokerPredicate((String)"noSuchMethod", (Class[])new Class[]{Object.class}, (Object[])new Object[]{this.cString}).evaluate(new Object()));
    }

    @Test
    public void testInvokerPredicateEx1() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.invokerPredicate(null));
    }

    @Test
    public void testInvokerPredicateEx2() {
        Assertions.assertThrows(FunctorException.class, () -> PredicateUtils.invokerPredicate((String)"isEmpty").evaluate(null));
    }

    @Test
    public void testInvokerPredicateEx3() {
        Assertions.assertThrows(FunctorException.class, () -> PredicateUtils.invokerPredicate((String)"noSuchMethod").evaluate(new Object()));
    }

    @Test
    public void testIsNotNullPredicate() {
        Assertions.assertNotNull((Object)PredicateUtils.notNullPredicate());
        Assertions.assertSame((Object)PredicateUtils.notNullPredicate(), (Object)PredicateUtils.notNullPredicate());
        Assertions.assertFalse((boolean)PredicateUtils.notNullPredicate().evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.notNullPredicate().evaluate(this.cObject));
        Assertions.assertTrue((boolean)PredicateUtils.notNullPredicate().evaluate((Object)this.cString));
        Assertions.assertTrue((boolean)PredicateUtils.notNullPredicate().evaluate((Object)this.cInteger));
    }

    @Test
    public void testNeitherPredicate() {
        Assertions.assertFalse((boolean)PredicateUtils.neitherPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.neitherPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.neitherPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.neitherPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
    }

    @Test
    public void testNeitherPredicateEx() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.neitherPredicate(null, null));
    }

    @Test
    public void testNonePredicate() {
        this.assertPredicateTrue(PredicateUtils.nonePredicate((Predicate[])new Predicate[0]), null);
        Assertions.assertFalse((boolean)PredicateUtils.nonePredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), TruePredicate.truePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.nonePredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.nonePredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.nonePredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        ArrayList<Predicate> coll = new ArrayList<Predicate>();
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertFalse((boolean)PredicateUtils.nonePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertFalse((boolean)PredicateUtils.nonePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertFalse((boolean)PredicateUtils.nonePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        Assertions.assertTrue((boolean)PredicateUtils.nonePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        this.assertPredicateTrue(PredicateUtils.nonePredicate(coll), null);
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        this.assertPredicateFalse(PredicateUtils.nonePredicate(coll), null);
        coll.clear();
        this.assertPredicateTrue(PredicateUtils.nonePredicate(coll), null);
    }

    @Test
    public void testNonePredicateEx1() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.nonePredicate((Predicate[])null));
    }

    @Test
    public void testNonePredicateEx2() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.nonePredicate((Predicate[])new Predicate[]{null}));
    }

    @Test
    public void testNonePredicateEx3() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.nonePredicate((Predicate[])new Predicate[]{null, null}));
    }

    @Test
    public void testNonePredicateEx4() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.nonePredicate((Collection)null));
    }

    @Test
    public void testNonePredicateEx5() {
        PredicateUtils.nonePredicate(Collections.emptyList());
    }

    @Test
    public void testNonePredicateEx6() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.nonePredicate((Collection)coll));
    }

    @Test
    public void testNotPredicate() {
        Assertions.assertNotNull((Object)PredicateUtils.notPredicate((Predicate)TruePredicate.truePredicate()));
        Assertions.assertFalse((boolean)PredicateUtils.notPredicate((Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.notPredicate((Predicate)TruePredicate.truePredicate()).evaluate(this.cObject));
        Assertions.assertFalse((boolean)PredicateUtils.notPredicate((Predicate)TruePredicate.truePredicate()).evaluate((Object)this.cString));
        Assertions.assertFalse((boolean)PredicateUtils.notPredicate((Predicate)TruePredicate.truePredicate()).evaluate((Object)this.cInteger));
    }

    @Test
    public void testNotPredicateEx() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.notPredicate(null));
    }

    @Test
    public void testNullIsExceptionPredicate() {
        Assertions.assertTrue((boolean)PredicateUtils.nullIsExceptionPredicate((Predicate)TruePredicate.truePredicate()).evaluate(new Object()));
        Assertions.assertThrows(FunctorException.class, () -> PredicateUtils.nullIsExceptionPredicate((Predicate)TruePredicate.truePredicate()).evaluate(null));
    }

    @Test
    public void testNullIsExceptionPredicateEx1() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.nullIsExceptionPredicate(null));
    }

    @Test
    public void testNullIsFalsePredicate() {
        Assertions.assertFalse((boolean)PredicateUtils.nullIsFalsePredicate((Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.nullIsFalsePredicate((Predicate)TruePredicate.truePredicate()).evaluate(new Object()));
        Assertions.assertFalse((boolean)PredicateUtils.nullIsFalsePredicate((Predicate)FalsePredicate.falsePredicate()).evaluate(new Object()));
    }

    @Test
    public void testNullIsFalsePredicateEx1() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.nullIsFalsePredicate(null));
    }

    @Test
    public void testNullIsTruePredicate() {
        Assertions.assertTrue((boolean)PredicateUtils.nullIsTruePredicate((Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.nullIsTruePredicate((Predicate)TruePredicate.truePredicate()).evaluate(new Object()));
        Assertions.assertFalse((boolean)PredicateUtils.nullIsTruePredicate((Predicate)FalsePredicate.falsePredicate()).evaluate(new Object()));
    }

    @Test
    public void testNullIsTruePredicateEx1() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.nullIsTruePredicate(null));
    }

    @Test
    public void testOnePredicate() {
        this.assertPredicateFalse(PredicateUtils.onePredicate((Predicate[])new Predicate[0]), null);
        Assertions.assertFalse((boolean)PredicateUtils.onePredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), TruePredicate.truePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.onePredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.onePredicate((Predicate[])new Predicate[]{TruePredicate.truePredicate(), FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.onePredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), TruePredicate.truePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.onePredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), TruePredicate.truePredicate()}).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.onePredicate((Predicate[])new Predicate[]{FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate(), FalsePredicate.falsePredicate()}).evaluate(null));
        ArrayList<Predicate> coll = new ArrayList<Predicate>();
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertFalse((boolean)PredicateUtils.onePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertFalse((boolean)PredicateUtils.onePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(TruePredicate.truePredicate());
        Assertions.assertTrue((boolean)PredicateUtils.onePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        coll.add(FalsePredicate.falsePredicate());
        Assertions.assertFalse((boolean)PredicateUtils.onePredicate(coll).evaluate(null));
        coll.clear();
        coll.add(FalsePredicate.falsePredicate());
        this.assertPredicateFalse(PredicateUtils.onePredicate(coll), null);
        coll.clear();
        coll.add(TruePredicate.truePredicate());
        this.assertPredicateTrue(PredicateUtils.onePredicate(coll), null);
        coll.clear();
        this.assertPredicateFalse(PredicateUtils.onePredicate(coll), null);
    }

    @Test
    public void testOnePredicateEx1() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.onePredicate((Predicate[])null));
    }

    @Test
    public void testOnePredicateEx2() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.onePredicate((Predicate[])new Predicate[]{null}));
    }

    @Test
    public void testOnePredicateEx3() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.onePredicate((Predicate[])new Predicate[]{null, null}));
    }

    @Test
    public void testOnePredicateEx4() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.onePredicate((Collection)null));
    }

    @Test
    public void testOnePredicateEx5() {
        PredicateUtils.onePredicate((Collection)Collections.EMPTY_LIST);
    }

    @Test
    public void testOnePredicateEx6() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.onePredicate(Arrays.asList(null, null)));
    }

    @Test
    public void testOrPredicate() {
        Assertions.assertTrue((boolean)PredicateUtils.orPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.orPredicate((Predicate)TruePredicate.truePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.orPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)TruePredicate.truePredicate()).evaluate(null));
        Assertions.assertFalse((boolean)PredicateUtils.orPredicate((Predicate)FalsePredicate.falsePredicate(), (Predicate)FalsePredicate.falsePredicate()).evaluate(null));
    }

    @Test
    public void testOrPredicateEx() {
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.orPredicate(null, null));
    }

    @Test
    public void testSingletonPatternInSerialization() {
        Object[] singletons;
        for (Object original : singletons = new Object[]{ExceptionPredicate.INSTANCE, FalsePredicate.INSTANCE, NotNullPredicate.INSTANCE, NullPredicate.INSTANCE, TruePredicate.INSTANCE}) {
            TestUtils.assertSameAfterSerialization("Singleton pattern broken for " + original.getClass(), original);
        }
    }

    @Test
    public void testTransformedPredicate() {
        Assertions.assertTrue((boolean)PredicateUtils.transformedPredicate((Transformer)TransformerUtils.nopTransformer(), (Predicate)TruePredicate.truePredicate()).evaluate(new Object()));
        HashMap<Boolean, String> map = new HashMap<Boolean, String>();
        map.put(Boolean.TRUE, "Hello");
        Transformer t = TransformerUtils.mapTransformer(map);
        Predicate p = EqualPredicate.equalPredicate((Object)"Hello");
        Assertions.assertFalse((boolean)PredicateUtils.transformedPredicate((Transformer)t, (Predicate)p).evaluate(null));
        Assertions.assertTrue((boolean)PredicateUtils.transformedPredicate((Transformer)t, (Predicate)p).evaluate((Object)Boolean.TRUE));
        Assertions.assertThrows(NullPointerException.class, () -> PredicateUtils.transformedPredicate(null, null));
    }

    @Test
    public void testTruePredicate() {
        Assertions.assertNotNull((Object)TruePredicate.truePredicate());
        Assertions.assertSame((Object)TruePredicate.truePredicate(), (Object)TruePredicate.truePredicate());
        Assertions.assertTrue((boolean)TruePredicate.truePredicate().evaluate(null));
        Assertions.assertTrue((boolean)TruePredicate.truePredicate().evaluate(this.cObject));
        Assertions.assertTrue((boolean)TruePredicate.truePredicate().evaluate((Object)this.cString));
        Assertions.assertTrue((boolean)TruePredicate.truePredicate().evaluate((Object)this.cInteger));
    }

    @Test
    public void testUniquePredicate() {
        Predicate p = PredicateUtils.uniquePredicate();
        Assertions.assertTrue((boolean)p.evaluate(new Object()));
        Assertions.assertTrue((boolean)p.evaluate(new Object()));
        Assertions.assertTrue((boolean)p.evaluate(new Object()));
        Assertions.assertTrue((boolean)p.evaluate((Object)this.cString));
        Assertions.assertFalse((boolean)p.evaluate((Object)this.cString));
        Assertions.assertFalse((boolean)p.evaluate((Object)this.cString));
    }
}

