/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.set.AbstractNavigableSetTest;
import org.apache.commons.collections4.set.PredicatedNavigableSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicatedNavigableSetTest<E>
extends AbstractNavigableSetTest<E> {
    protected Predicate<E> truePredicate = TruePredicate.truePredicate();
    protected Predicate<E> testPredicate = o -> o instanceof String && ((String)o).startsWith("A");

    public PredicatedNavigableSetTest() {
        super(PredicatedNavigableSetTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }

    @Override
    public NavigableSet<E> makeFullCollection() {
        TreeSet set = new TreeSet(Arrays.asList(this.getFullElements()));
        return PredicatedNavigableSet.predicatedNavigableSet(set, this.truePredicate);
    }

    @Override
    public NavigableSet<E> makeObject() {
        return PredicatedNavigableSet.predicatedNavigableSet(new TreeSet(), this.truePredicate);
    }

    protected PredicatedNavigableSet<E> makeTestSet() {
        return PredicatedNavigableSet.predicatedNavigableSet(new TreeSet(), this.testPredicate);
    }

    @Test
    public void testComparator() {
        PredicatedNavigableSet<E> set = this.makeTestSet();
        Comparator c = set.comparator();
        Assertions.assertNull(c, (String)"natural order, so comparator should be null");
    }

    @Test
    public void testGetSet() {
        PredicatedNavigableSet<E> set = this.makeTestSet();
        Assertions.assertNotNull((Object)set.decorated(), (String)"returned set should not be null");
    }

    @Test
    public void testIllegalAdd() {
        PredicatedNavigableSet set = this.makeTestSet();
        String testString = "B";
        Assertions.assertThrows(IllegalArgumentException.class, () -> set.add("B"), (String)"Should fail string predicate.");
        Assertions.assertFalse((boolean)set.contains("B"), (String)"Collection shouldn't contain illegal element");
    }

    @Test
    public void testIllegalAddAll() {
        PredicatedNavigableSet set = this.makeTestSet();
        TreeSet<String> elements = new TreeSet<String>();
        elements.add("Aone");
        elements.add("Atwo");
        elements.add("Bthree");
        elements.add("Afour");
        Assertions.assertThrows(IllegalArgumentException.class, () -> set.addAll(elements), (String)"Should fail string predicate.");
        Assertions.assertFalse((boolean)set.contains("Aone"), (String)"Set shouldn't contain illegal element");
        Assertions.assertFalse((boolean)set.contains("Atwo"), (String)"Set shouldn't contain illegal element");
        Assertions.assertFalse((boolean)set.contains("Bthree"), (String)"Set shouldn't contain illegal element");
        Assertions.assertFalse((boolean)set.contains("Afour"), (String)"Set shouldn't contain illegal element");
    }
}

