/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.OrderedIterator;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.ListOrderedSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ListOrderedSetTest<E>
extends AbstractSetTest<E> {
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final Integer THREE = 3;

    public ListOrderedSetTest() {
        super(ListOrderedSetTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public ListOrderedSet<E> makeObject() {
        return ListOrderedSet.listOrderedSet(new HashSet());
    }

    protected ListOrderedSet<E> setupSet() {
        ListOrderedSet<E> set = this.makeObject();
        for (int i = 0; i < 10; ++i) {
            set.add((Object)Integer.toString(i));
        }
        return set;
    }

    @Test
    public void testDecorator() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> ListOrderedSet.listOrderedSet((List)null)), () -> Assertions.assertThrows(NullPointerException.class, () -> ListOrderedSet.listOrderedSet((Set)null)), () -> Assertions.assertThrows(NullPointerException.class, () -> ListOrderedSet.listOrderedSet(null, null)), () -> Assertions.assertThrows(NullPointerException.class, () -> ListOrderedSet.listOrderedSet(new HashSet(), null)), () -> Assertions.assertThrows(NullPointerException.class, () -> ListOrderedSet.listOrderedSet(null, new ArrayList()))});
    }

    @Test
    public void testDuplicates() {
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(1);
        ListOrderedSet orderedSet = ListOrderedSet.listOrderedSet(list);
        Assertions.assertEquals((int)3, (int)orderedSet.size());
        Assertions.assertEquals((int)3, (int)IteratorUtils.toArray((Iterator)orderedSet.iterator()).length);
        Assertions.assertEquals((Object)1, (Object)orderedSet.get(0));
        Assertions.assertEquals((Object)2, (Object)orderedSet.get(1));
        Assertions.assertEquals((Object)3, (Object)orderedSet.get(2));
    }

    @Test
    public void testListAddIndexed() {
        ListOrderedSet<E> set = this.makeObject();
        set.add((Object)ZERO);
        set.add((Object)TWO);
        set.add(1, (Object)ONE);
        Assertions.assertEquals((int)3, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)ONE, (Object)set.get(1));
        Assertions.assertSame((Object)TWO, (Object)set.get(2));
        set.add(0, (Object)ONE);
        Assertions.assertEquals((int)3, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)ONE, (Object)set.get(1));
        Assertions.assertSame((Object)TWO, (Object)set.get(2));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(ZERO);
        list.add(TWO);
        set.addAll(0, list);
        Assertions.assertEquals((int)3, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)ONE, (Object)set.get(1));
        Assertions.assertSame((Object)TWO, (Object)set.get(2));
        list.add(0, THREE);
        set.remove((Object)TWO);
        set.addAll(1, list);
        Assertions.assertEquals((int)4, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)THREE, (Object)set.get(1));
        Assertions.assertSame((Object)TWO, (Object)set.get(2));
        Assertions.assertSame((Object)ONE, (Object)set.get(3));
    }

    @Test
    public void testListAddRemove() {
        ListOrderedSet<E> set = this.makeObject();
        List view = set.asList();
        set.add((Object)ZERO);
        set.add((Object)ONE);
        set.add((Object)TWO);
        Assertions.assertEquals((int)3, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)ONE, (Object)set.get(1));
        Assertions.assertSame((Object)TWO, (Object)set.get(2));
        Assertions.assertEquals((int)3, (int)view.size());
        Assertions.assertSame((Object)ZERO, view.get(0));
        Assertions.assertSame((Object)ONE, view.get(1));
        Assertions.assertSame((Object)TWO, view.get(2));
        Assertions.assertEquals((int)0, (int)set.indexOf((Object)ZERO));
        Assertions.assertEquals((int)1, (int)set.indexOf((Object)ONE));
        Assertions.assertEquals((int)2, (int)set.indexOf((Object)TWO));
        set.remove(1);
        Assertions.assertEquals((int)2, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)TWO, (Object)set.get(1));
        Assertions.assertEquals((int)2, (int)view.size());
        Assertions.assertSame((Object)ZERO, view.get(0));
        Assertions.assertSame((Object)TWO, view.get(1));
    }

    @Test
    public void testListAddReplacing() {
        ListOrderedSet<E> set = this.makeObject();
        A a = new A();
        B b = new B();
        set.add((Object)a);
        Assertions.assertEquals((int)1, (int)set.size());
        set.add((Object)b);
        Assertions.assertEquals((int)1, (int)set.size());
        Assertions.assertSame((Object)a, set.decorated().iterator().next());
        Assertions.assertSame((Object)a, (Object)set.iterator().next());
        Assertions.assertSame((Object)a, (Object)set.get(0));
        Assertions.assertSame((Object)a, set.asList().get(0));
    }

    @Test
    public void testOrdering() {
        int i;
        ListOrderedSet<E> set = this.setupSet();
        OrderedIterator it = set.iterator();
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong");
        }
        for (i = 0; i < 10; i += 2) {
            Assertions.assertTrue((boolean)set.remove((Object)Integer.toString(i)), (String)"Must be able to remove int");
        }
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong after remove ");
        }
        for (i = 0; i < 10; ++i) {
            set.add((Object)Integer.toString(i));
        }
        Assertions.assertEquals((int)10, (int)set.size(), (String)"Size of set is wrong!");
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong");
        }
        for (i = 0; i < 10; i += 2) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong");
        }
    }

    @Test
    public void testRetainAll() {
        ArrayList list = new ArrayList(10);
        HashSet set = new HashSet(10);
        ListOrderedSet orderedSet = ListOrderedSet.listOrderedSet(set, list);
        for (int i = 0; i < 10; ++i) {
            orderedSet.add((Object)(10 - i - 1));
        }
        ArrayList<Integer> retained = new ArrayList<Integer>(5);
        for (int i = 0; i < 5; ++i) {
            retained.add(i * 2);
        }
        Assertions.assertTrue((boolean)orderedSet.retainAll(retained));
        Assertions.assertEquals((int)5, (int)orderedSet.size());
        Assertions.assertEquals((Object)8, (Object)orderedSet.get(0));
        Assertions.assertEquals((Object)6, (Object)orderedSet.get(1));
        Assertions.assertEquals((Object)4, (Object)orderedSet.get(2));
        Assertions.assertEquals((Object)2, (Object)orderedSet.get(3));
        Assertions.assertEquals((Object)0, (Object)orderedSet.get(4));
    }

    static class A {
        A() {
        }

        public boolean equals(Object obj) {
            return obj instanceof A || obj instanceof B;
        }

        public int hashCode() {
            return 1;
        }
    }

    static class B {
        B() {
        }

        public boolean equals(Object obj) {
            return obj instanceof A || obj instanceof B;
        }

        public int hashCode() {
            return 1;
        }
    }
}

