/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.CompositeSet;
import org.apache.commons.collections4.set.EmptySetMutator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompositeSetTest<E>
extends AbstractSetTest<E> {
    public CompositeSetTest() {
        super(CompositeSetTest.class.getSimpleName());
    }

    public Set<E> buildOne() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        return set;
    }

    public Set<E> buildTwo() {
        HashSet<String> set = new HashSet<String>();
        set.add("3");
        set.add("4");
        return set;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public CompositeSet<E> makeObject() {
        HashSet contained = new HashSet();
        CompositeSet set = new CompositeSet(contained);
        set.setMutator(new EmptySetMutator(contained));
        return set;
    }

    @Test
    public void testAddComposited() {
        Set<E> one = this.buildOne();
        Set<E> two = this.buildTwo();
        CompositeSet set = new CompositeSet();
        set.addComposited(one, two);
        set.addComposited((Set)null);
        set.addComposited((Set[])null);
        set.addComposited(null, null);
        set.addComposited(new Set[]{null, null, null});
        CompositeSet set2 = new CompositeSet(this.buildOne());
        set2.addComposited(this.buildTwo());
        Assertions.assertEquals((Object)set, (Object)set2);
        HashSet<String> set3 = new HashSet<String>();
        set3.add("1");
        set3.add("2");
        set3.add("3");
        HashSet<String> set4 = new HashSet<String>();
        set4.add("4");
        CompositeSet set5 = new CompositeSet(set3);
        set5.addComposited(set4);
        Assertions.assertEquals((Object)set, (Object)set5);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.addComposited((Set)set3), (String)"Expecting UnsupportedOperationException.");
    }

    @Test
    public void testAddCompositedCollision() {
        HashSet<String> set1 = new HashSet<String>();
        set1.add("1");
        set1.add("2");
        set1.add("3");
        HashSet<String> set2 = new HashSet<String>();
        set2.add("4");
        CompositeSet set3 = new CompositeSet(set1);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set3.addComposited((Set)set1, this.buildOne()), (String)"Expecting UnsupportedOperationException.");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set3.addComposited(new Set[]{set1, this.buildOne(), this.buildTwo()}), (String)"Expecting UnsupportedOperationException.");
    }

    @Test
    public void testContains() {
        CompositeSet set = new CompositeSet(new Set[]{this.buildOne(), this.buildTwo()});
        Assertions.assertTrue((boolean)set.contains((Object)"1"));
    }

    @Test
    public void testContainsAll() {
        CompositeSet set = new CompositeSet(new Set[]{this.buildOne(), this.buildTwo()});
        Assertions.assertFalse((boolean)set.containsAll(null));
    }

    @Test
    public void testFailedCollisionResolution() {
        Set<E> one = this.buildOne();
        Set<E> two = this.buildTwo();
        CompositeSet set = new CompositeSet(new Set[]{one, two});
        set.setMutator(new CompositeSet.SetMutator<E>(){
            private static final long serialVersionUID = 1L;

            public boolean add(CompositeSet<E> composite, List<Set<E>> collections, E obj) {
                throw new UnsupportedOperationException();
            }

            public boolean addAll(CompositeSet<E> composite, List<Set<E>> collections, Collection<? extends E> coll) {
                throw new UnsupportedOperationException();
            }

            public void resolveCollision(CompositeSet<E> comp, Set<E> existing, Set<E> added, Collection<E> intersects) {
            }
        });
        HashSet<String> three = new HashSet<String>();
        three.add("1");
        Assertions.assertThrows(IllegalArgumentException.class, () -> set.addComposited((Set)three), (String)"IllegalArgumentException should have been thrown");
    }

    @Test
    public void testRemoveAll() {
        CompositeSet set = new CompositeSet(new Set[]{this.buildOne(), this.buildTwo()});
        Assertions.assertFalse((boolean)set.removeAll(null));
    }

    @Test
    public void testRemoveComposited() {
        Set<E> one = this.buildOne();
        Set<E> two = this.buildTwo();
        CompositeSet set = new CompositeSet(new Set[]{one, two});
        set.remove((Object)"1");
        Assertions.assertFalse((boolean)one.contains("1"));
        set.remove((Object)"3");
        Assertions.assertFalse((boolean)one.contains("3"));
    }

    @Test
    public void testRemoveUnderlying() {
        Set<E> one = this.buildOne();
        Set<E> two = this.buildTwo();
        CompositeSet set = new CompositeSet(new Set[]{one, two});
        one.remove("1");
        Assertions.assertFalse((boolean)set.contains((Object)"1"));
        two.remove("3");
        Assertions.assertFalse((boolean)set.contains((Object)"3"));
    }
}

