/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.AbstractObjectTest;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.map.AbstractMapTest;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.collections4.multiset.AbstractMultiSetTest;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public abstract class AbstractMultiValuedMapTest<K, V>
extends AbstractObjectTest {
    protected MultiValuedMap<K, V> map;
    protected MultiValuedMap<K, V> confirmed;

    public AbstractMultiValuedMapTest(String testName) {
        super(testName);
    }

    protected void addSampleMappings(MultiValuedMap<? super K, ? super V> map) {
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
    }

    public BulkTest bulkTestAsMap() {
        return new TestMultiValuedMapAsMap();
    }

    public BulkTest bulkTestMultiValuedMapEntries() {
        return new TestMultiValuedMapEntries();
    }

    public BulkTest bulkTestMultiValuedMapKeys() {
        return new TestMultiValuedMapKeys();
    }

    public BulkTest bulkTestMultiValuedMapKeySet() {
        return new TestMultiValuedMapKeySet();
    }

    public BulkTest bulkTestMultiValuedMapValues() {
        return new TestMultiValuedMapValues();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }

    public MultiValuedMap<K, V> getConfirmed() {
        return this.confirmed;
    }

    protected int getIterationBehaviour() {
        return 0;
    }

    public MultiValuedMap<K, V> getMap() {
        return this.map;
    }

    public int getSampleCountPerKey() {
        return 8;
    }

    public K[] getSampleKeys() {
        Object[] result = new Object[this.getSampleTotalValueCount()];
        int cpk = this.getSampleCountPerKey();
        int k = 0;
        int i = 0;
        while (i < result.length) {
            Object key = this.makeKey(k);
            for (int j = 0; j < cpk; ++j) {
                result[i + j] = key;
            }
            i += cpk;
            ++k;
        }
        return result;
    }

    public int getSampleKeySize() {
        return 256;
    }

    public int getSampleTotalValueCount() {
        return this.getSampleCountPerKey() * this.getSampleKeySize();
    }

    public V[] getSampleValues() {
        Object[] result = new Object[this.getSampleTotalValueCount()];
        int cpk = this.getSampleCountPerKey();
        int k = 0;
        int i = 0;
        while (i < result.length) {
            for (int j = 0; j < cpk; ++j) {
                result[i + j] = this.makeValue(k, j);
            }
            i += cpk;
            ++k;
        }
        return result;
    }

    public boolean isAddSupported() {
        return true;
    }

    public boolean isAllowNullKey() {
        return true;
    }

    public boolean isHashSetValue() {
        return false;
    }

    public boolean isRemoveSupported() {
        return true;
    }

    @Override
    public boolean isTestSerialization() {
        return true;
    }

    public MultiValuedMap<K, V> makeConfirmedMap() {
        return new ArrayListValuedHashMap();
    }

    protected MultiValuedMap<K, V> makeFullMap() {
        MultiValuedMap<K, V> map = this.makeObject();
        this.addSampleMappings(map);
        return map;
    }

    <E> E makeKey(int key) {
        return (E)("k" + key);
    }

    public abstract MultiValuedMap<K, V> makeObject();

    <E> E makeValue(int key, int value) {
        return (E)("v" + key + '_' + value);
    }

    public void resetEmpty() {
        this.map = this.makeObject();
        this.confirmed = this.makeConfirmedMap();
    }

    public void resetFull() {
        this.map = this.makeFullMap();
        this.confirmed = this.makeConfirmedMap();
        K[] k = this.getSampleKeys();
        V[] v = this.getSampleValues();
        for (int i = 0; i < k.length; ++i) {
            this.confirmed.put(k[i], v[i]);
        }
    }

    public void setConfirmed(MultiValuedMap<K, V> map) {
        this.confirmed = map;
    }

    @Test
    public void testAddMappingThroughGet() {
        Assumptions.assumeTrue((boolean)this.isAddSupported());
        this.resetEmpty();
        MultiValuedMap<K, V> map = this.getMap();
        Collection col1 = map.get((Object)"k0");
        Collection col2 = map.get((Object)"k0");
        Assertions.assertTrue((boolean)col1.isEmpty());
        Assertions.assertTrue((boolean)col2.isEmpty());
        Assertions.assertEquals((int)0, (int)map.size());
        col1.add("v1_1");
        col2.add("v0_1");
        Assertions.assertTrue((boolean)map.containsKey((Object)"k0"));
        Assertions.assertTrue((boolean)map.containsMapping((Object)"k0", (Object)"v1_1"));
        Assertions.assertTrue((boolean)map.containsMapping((Object)"k0", (Object)"v0_1"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"v1_1"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"v0_1"));
        Assertions.assertTrue((boolean)col1.contains("v0_1"));
        Assertions.assertTrue((boolean)col2.contains("v1_1"));
    }

    @Test
    public void testAsMapGet_Empty() {
        this.resetEmpty();
        Map mapCol = this.getMap().asMap();
        Assertions.assertNull(mapCol.get("k0"));
        Assertions.assertEquals((int)0, (int)mapCol.size());
    }

    @Test
    public void testAsMapGet_Full() {
        this.resetFull();
        Map mapCol = this.getMap().asMap();
        int maxK = this.getSampleKeySize();
        int maxV = this.getSampleCountPerKey();
        for (int k = 0; k < maxK; ++k) {
            Collection col = (Collection)mapCol.get(this.makeKey(k));
            for (int v = 0; v < maxV; ++v) {
                Assertions.assertTrue((boolean)col.contains(this.makeValue(k, v)));
            }
        }
    }

    @Test
    public void testAsMapRemove() {
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        this.resetFull();
        Map mapCol = this.getMap().asMap();
        int maxK = this.getSampleKeySize();
        int expectedSize = this.getMap().size();
        for (int k = 0; k < maxK; ++k) {
            Object key = this.makeKey(k);
            mapCol.remove(key);
            Assertions.assertFalse((boolean)this.getMap().containsKey(key));
            Assertions.assertEquals((int)(expectedSize -= this.getSampleCountPerKey()), (int)this.getMap().size());
        }
        Assertions.assertFalse((boolean)this.getMap().containsKey((Object)"k0"));
        Assertions.assertEquals((int)0, (int)this.getMap().size());
    }

    @Test
    public void testContainsValue() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        int maxK = this.getSampleKeySize();
        int maxV = this.getSampleCountPerKey();
        for (int k = 0; k < maxK; ++k) {
            for (int v = 0; v < maxV; ++v) {
                Assertions.assertTrue((boolean)map.containsValue(this.makeValue(k, v)));
            }
        }
        Assertions.assertFalse((boolean)map.containsValue((Object)"quatro"));
    }

    @Test
    public void testContainsValue_Key() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        int maxK = this.getSampleKeySize();
        int maxV = this.getSampleCountPerKey();
        for (int k = 0; k < maxK; ++k) {
            for (int v = 0; v < maxV; ++v) {
                Assertions.assertTrue((boolean)map.containsMapping(this.makeKey(k), this.makeValue(k, v)));
            }
        }
        Assertions.assertFalse((boolean)map.containsMapping((Object)"k1", (Object)"2"));
        if (!this.isAddSupported()) {
            return;
        }
        map.put((Object)"A", (Object)"AA");
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"AA"));
        Assertions.assertFalse((boolean)map.containsMapping((Object)"A", (Object)"AB"));
    }

    @Test
    public void testEmptyMapCompatibility() throws Exception {
        MultiValuedMap<K, V> map = this.makeObject();
        MultiValuedMap map2 = (MultiValuedMap)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(map));
        Assertions.assertEquals((int)0, (int)map2.size(), (String)"Map is empty");
    }

    @Test
    public void testEntriesCollectionIterator() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        ArrayList values = new ArrayList(map.values());
        for (Map.Entry entry : map.entries()) {
            Assertions.assertTrue((boolean)map.containsMapping(entry.getKey(), entry.getValue()));
            Assertions.assertTrue((boolean)values.contains(entry.getValue()));
            if (!this.isRemoveSupported()) continue;
            Assertions.assertTrue((boolean)values.remove(entry.getValue()));
        }
        if (this.isRemoveSupported()) {
            Assertions.assertTrue((boolean)values.isEmpty());
        }
    }

    @Test
    @Disabled(value="There is no code to create this test fixture?")
    public void testFullMapCompatibility() throws Exception {
        MultiValuedMap<K, V> map = this.makeFullMap();
        MultiValuedMap map2 = (MultiValuedMap)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(map));
        Assertions.assertEquals((int)map.size(), (int)map2.size(), (String)"Map is the right size");
        for (Object key : map.keySet()) {
            Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)map.get(key), (Collection)map2.get(key)), (String)"Map had inequal elements");
            if (!this.isRemoveSupported()) continue;
            map2.remove(key);
        }
        if (this.isRemoveSupported()) {
            Assertions.assertEquals((int)0, (int)map2.size(), (String)"Map had extra values");
        }
    }

    @Test
    public void testGet() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        int maxK = this.getSampleKeySize();
        int maxV = this.getSampleCountPerKey();
        for (int k = 0; k < maxK; ++k) {
            for (int v = 0; v < maxV; ++v) {
                Assertions.assertTrue((boolean)map.get(this.makeKey(k)).contains(this.makeValue(k, v)));
            }
        }
    }

    @Test
    public void testKeyContainsValue() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        int maxK = this.getSampleKeySize();
        int maxV = this.getSampleCountPerKey();
        for (int k = 0; k < maxK; ++k) {
            for (int v = 0; v < maxV; ++v) {
                Assertions.assertTrue((boolean)map.containsMapping(this.makeKey(k), this.makeValue(k, v)));
            }
        }
        Assertions.assertFalse((boolean)map.containsMapping((Object)"k", (Object)"v"));
    }

    @Test
    public void testKeysBagContainsAll() {
        int k;
        MultiValuedMap<K, V> map = this.makeFullMap();
        MultiSet keyMultiSet = map.keys();
        ArrayList<String> col = new ArrayList<String>();
        int maxK = this.getSampleKeySize();
        for (k = 0; k < maxK; ++k) {
            col.add((String)this.makeKey(k));
        }
        for (k = 0; k < maxK; ++k) {
            col.add((String)this.makeKey(k));
        }
        Assertions.assertTrue((boolean)keyMultiSet.containsAll(col));
    }

    @Test
    public void testKeysBagIterator() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        ArrayList col = new ArrayList(map.keys());
        HashBag bag = new HashBag(col);
        int maxK = this.getSampleKeySize();
        for (int k = 0; k < maxK; ++k) {
            Assertions.assertEquals((int)this.getSampleCountPerKey(), (int)bag.getCount(this.makeKey(k)));
        }
        Assertions.assertEquals((int)this.getSampleTotalValueCount(), (int)bag.size());
    }

    @Test
    public void testKeySetSize() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        Assertions.assertEquals((int)this.getSampleKeySize(), (int)map.keySet().size());
    }

    @Test
    public void testKeysMultiSet() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        MultiSet keyMultiSet = map.keys();
        int maxK = this.getSampleKeySize();
        for (int k = 0; k < maxK; ++k) {
            Assertions.assertEquals((int)this.getSampleCountPerKey(), (int)keyMultiSet.getCount(this.makeKey(k)));
        }
        Assertions.assertEquals((int)0, (int)keyMultiSet.getCount((Object)"conut"));
        Assertions.assertEquals((int)this.getSampleTotalValueCount(), (int)keyMultiSet.size());
    }

    @Test
    public void testMapEquals() {
        Assumptions.assumeTrue((boolean)this.isAddSupported());
        MultiValuedMap<K, V> one = this.makeObject();
        Integer value = 1;
        one.put((Object)"One", (Object)value);
        one.removeMapping((Object)"One", (Object)value);
        MultiValuedMap<K, V> two = this.makeObject();
        Assertions.assertEquals(two, one);
    }

    @Test
    public void testMapIterator() {
        this.resetEmpty();
        MapIterator mapIt = this.getMap().mapIterator();
        Assertions.assertFalse((boolean)mapIt.hasNext());
        this.resetFull();
        mapIt = this.getMap().mapIterator();
        while (mapIt.hasNext()) {
            Object key = mapIt.next();
            Object value = mapIt.getValue();
            Assertions.assertTrue((boolean)this.getMap().containsMapping(key, value));
        }
    }

    @Test
    public void testMapIteratorRemove() {
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        this.resetFull();
        MapIterator mapIt = this.getMap().mapIterator();
        while (mapIt.hasNext()) {
            mapIt.next();
            mapIt.remove();
        }
        Assertions.assertTrue((boolean)this.getMap().isEmpty());
    }

    @Test
    public void testMapIteratorUnsupportedSet() {
        this.resetFull();
        MapIterator mapIt = this.getMap().mapIterator();
        mapIt.next();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> mapIt.setValue((Object)"some value"));
    }

    @Test
    public void testMultipleValues() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        int maxK = this.getSampleKeySize();
        int maxV = this.getSampleCountPerKey();
        for (int k = 0; k < maxK; ++k) {
            Collection col = map.get(this.makeKey(k));
            for (int v = 0; v < maxV; ++v) {
                Assertions.assertTrue((boolean)col.contains(this.makeValue(k, v)));
            }
        }
    }

    @Test
    public void testMultiValuedMapIterator() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        MapIterator it = map.mapIterator();
        Assertions.assertThrows(IllegalStateException.class, () -> it.getKey());
        Assertions.assertThrows(IllegalStateException.class, () -> it.getValue());
        if (this.isAddSupported()) {
            Assertions.assertThrows(IllegalStateException.class, () -> it.setValue((Object)"V"));
        }
        if (!this.isHashSetValue() && this.isAddSupported()) {
            Assertions.assertTrue((boolean)it.hasNext());
            MultiValuedMap<K, V> dejaVu = this.makeObject();
            while (it.hasNext()) {
                Object next = it.next();
                Assertions.assertNotNull((Object)next);
                Object itKey = it.getKey();
                Assertions.assertEquals((Object)next, (Object)itKey);
                Object itValue = it.getValue();
                dejaVu.put(itKey, itValue);
                Assertions.assertThrows(UnsupportedOperationException.class, () -> it.setValue((Object)"threetrois"));
            }
            Assertions.assertEquals(map, dejaVu);
            Assertions.assertEquals(dejaVu, map);
            Assertions.assertThrows(UnsupportedOperationException.class, () -> it.setValue((Object)"threetrois"));
        }
    }

    @Test
    public void testNoMappingReturnsEmptyCol() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        Assertions.assertTrue((boolean)map.get((Object)"whatever").isEmpty());
    }

    @Test
    public void testPutAll_KeyIterable() {
        Assumptions.assumeTrue((boolean)this.isAddSupported());
        MultiValuedMap map = this.makeObject();
        List<String> coll = Arrays.asList("X", "Y", "Z");
        Assertions.assertTrue((boolean)map.putAll((Object)"A", coll));
        Assertions.assertEquals((int)3, (int)map.get((Object)"A").size());
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"X"));
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"Y"));
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"Z"));
        Assertions.assertThrows(NullPointerException.class, () -> map.putAll((Object)"A", null), (String)"expecting NullPointerException");
        Assertions.assertEquals((int)3, (int)map.get((Object)"A").size());
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"X"));
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"Y"));
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"Z"));
        Assertions.assertFalse((boolean)map.putAll((Object)"A", new ArrayList()));
        Assertions.assertEquals((int)3, (int)map.get((Object)"A").size());
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"X"));
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"Y"));
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"Z"));
        coll = Arrays.asList("M");
        Assertions.assertTrue((boolean)map.putAll((Object)"A", coll));
        Assertions.assertEquals((int)4, (int)map.get((Object)"A").size());
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"X"));
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"Y"));
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"Z"));
        Assertions.assertTrue((boolean)map.containsMapping((Object)"A", (Object)"M"));
    }

    @Test
    public void testPutAll_Map1() {
        Assumptions.assumeTrue((boolean)this.isAddSupported());
        MultiValuedMap<K, V> original = this.makeObject();
        original.put((Object)"key", (Object)"object1");
        original.put((Object)"key", (Object)"object2");
        MultiValuedMap test = this.makeObject();
        test.put((Object)"keyA", (Object)"objectA");
        test.put((Object)"key", (Object)"object0");
        test.putAll(original);
        MultiValuedMap originalNull = null;
        Assertions.assertThrows(NullPointerException.class, () -> test.putAll(originalNull), (String)"expecting NullPointerException");
        Assertions.assertEquals((int)2, (int)test.keySet().size());
        Assertions.assertEquals((int)4, (int)test.size());
        Assertions.assertEquals((int)1, (int)test.get((Object)"keyA").size());
        Assertions.assertEquals((int)3, (int)test.get((Object)"key").size());
        Assertions.assertTrue((boolean)test.containsValue((Object)"objectA"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object0"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object1"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object2"));
    }

    @Test
    public void testPutAll_Map2() {
        Assumptions.assumeTrue((boolean)this.isAddSupported());
        HashMap<String, String> original = new HashMap<String, String>();
        original.put("keyX", "object1");
        original.put("keyY", "object2");
        MultiValuedMap test = this.makeObject();
        test.put((Object)"keyA", (Object)"objectA");
        test.put((Object)"keyX", (Object)"object0");
        test.putAll(original);
        Map originalNull = null;
        Assertions.assertThrows(NullPointerException.class, () -> test.putAll(originalNull), (String)"expecting NullPointerException");
        Assertions.assertEquals((int)3, (int)test.keySet().size());
        Assertions.assertEquals((int)4, (int)test.size());
        Assertions.assertEquals((int)1, (int)test.get((Object)"keyA").size());
        Assertions.assertEquals((int)2, (int)test.get((Object)"keyX").size());
        Assertions.assertEquals((int)1, (int)test.get((Object)"keyY").size());
        Assertions.assertTrue((boolean)test.containsValue((Object)"objectA"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object0"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object1"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object2"));
    }

    @Test
    public void testRemove_KeyItem() {
        Assumptions.assumeTrue((boolean)this.isAddSupported());
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        MultiValuedMap<K, V> map = this.makeObject();
        map.put((Object)"A", (Object)"AA");
        map.put((Object)"A", (Object)"AB");
        map.put((Object)"A", (Object)"AC");
        Assertions.assertFalse((boolean)map.removeMapping((Object)"C", (Object)"CA"));
        Assertions.assertFalse((boolean)map.removeMapping((Object)"A", (Object)"AD"));
        Assertions.assertTrue((boolean)map.removeMapping((Object)"A", (Object)"AC"));
        Assertions.assertTrue((boolean)map.removeMapping((Object)"A", (Object)"AB"));
        Assertions.assertTrue((boolean)map.removeMapping((Object)"A", (Object)"AA"));
    }

    @Test
    public void testRemoveAllViaEntriesIterator() {
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        MultiValuedMap<K, V> map = this.makeFullMap();
        Iterator i = map.entries().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        Assertions.assertTrue((boolean)map.get((Object)"k0").isEmpty());
        Assertions.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void testRemoveAllViaValuesIterator() {
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        MultiValuedMap<K, V> map = this.makeFullMap();
        Iterator i = map.values().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        Assertions.assertTrue((boolean)map.get((Object)"k0").isEmpty());
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testRemoveMappingThroughGet() {
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        this.resetFull();
        MultiValuedMap<K, V> map = this.getMap();
        int cpk = this.getSampleCountPerKey();
        int expectedCount = this.getSampleTotalValueCount();
        Assertions.assertEquals((int)expectedCount, (int)map.size());
        for (int k = 0; k < this.getSampleKeySize(); ++k) {
            int i;
            Object key = this.makeKey(k);
            Collection col = map.get(key);
            Assertions.assertEquals((int)cpk, (int)col.size());
            for (i = 0; i < cpk; ++i) {
                Object value = this.makeValue(k, i);
                Assertions.assertTrue((boolean)col.remove(value), () -> value.toString());
            }
            for (i = 0; i < cpk; ++i) {
                Assertions.assertFalse((boolean)col.remove(this.makeValue(k, i)));
            }
            Assertions.assertFalse((boolean)map.containsKey(key));
            for (i = 0; i < cpk; ++i) {
                Assertions.assertFalse((boolean)map.containsMapping(key, (Object)i));
            }
            for (i = 0; i < cpk; ++i) {
                Assertions.assertFalse((boolean)map.containsValue(this.makeValue(k, i)));
            }
            Assertions.assertEquals((int)(expectedCount -= cpk), (int)map.size());
            col = map.remove(key);
            Assertions.assertNotNull((Object)col);
            Assertions.assertEquals((int)0, (int)col.size());
        }
    }

    @Test
    public void testRemoveMappingThroughGetIterator() {
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        this.resetFull();
        MultiValuedMap<K, V> map = this.getMap();
        int expectedSize = map.size();
        int maxK = this.getSampleKeySize();
        for (int k = 0; k < maxK; ++k) {
            String key = (String)this.makeKey(k);
            int cpk = this.getSampleCountPerKey();
            Iterator it = map.get((Object)key).iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            Assertions.assertFalse((boolean)map.containsKey((Object)key));
            for (int j = 0; j < cpk; ++j) {
                Assertions.assertFalse((boolean)map.containsMapping((Object)key, this.makeValue(k + 1, j)));
                Object value = this.makeValue(k, j);
                Assertions.assertFalse((boolean)map.containsMapping((Object)key, value));
                Assertions.assertFalse((boolean)map.containsValue(value));
            }
            Assertions.assertEquals((int)(expectedSize -= cpk), (int)map.size());
            Collection coll = map.remove((Object)"k0");
            Assertions.assertNotNull((Object)coll);
            Assertions.assertEquals((int)0, (int)coll.size());
        }
    }

    @Test
    public void testRemoveViaValuesRemove() {
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        MultiValuedMap<K, V> map = this.makeFullMap();
        Collection values = map.values();
        int maxK = this.getSampleKeySize();
        int maxV = this.getSampleCountPerKey();
        int expectedSize = map.size();
        for (int k = 0; k < maxK; ++k) {
            for (int v = 0; v < maxV; ++v) {
                values.remove(this.makeValue(k, v));
            }
            Assertions.assertFalse((boolean)map.containsKey(this.makeKey(k)));
            Assertions.assertEquals((int)(expectedSize -= maxV), (int)map.size());
        }
        Assertions.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)this.getSampleTotalValueCount(), (int)this.makeFullMap().size());
    }

    @Test
    public void testSize_Key() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        int maxK = this.getSampleKeySize();
        for (int k = 0; k < maxK; ++k) {
            Assertions.assertEquals((int)this.getSampleCountPerKey(), (int)map.get(this.makeKey(k)).size());
        }
        if (!this.isAddSupported()) {
            return;
        }
        map.put((Object)"A", (Object)"AA");
        Assertions.assertEquals((int)1, (int)map.get((Object)"A").size());
        map.put((Object)"B", (Object)"BA");
        Assertions.assertEquals((int)1, (int)map.get((Object)"A").size());
        Assertions.assertEquals((int)1, (int)map.get((Object)"B").size());
        map.put((Object)"B", (Object)"BB");
        Assertions.assertEquals((int)1, (int)map.get((Object)"A").size());
        Assertions.assertEquals((int)2, (int)map.get((Object)"B").size());
        map.put((Object)"B", (Object)"BC");
        Assertions.assertEquals((int)1, (int)map.get((Object)"A").size());
        Assertions.assertEquals((int)3, (int)map.get((Object)"B").size());
        if (!this.isRemoveSupported()) {
            return;
        }
        map.remove((Object)"A");
        Assertions.assertEquals((int)3, (int)map.get((Object)"B").size());
        map.removeMapping((Object)"B", (Object)"BC");
        Assertions.assertEquals((int)2, (int)map.get((Object)"B").size());
    }

    @Test
    public void testSizeWithPutRemove() {
        Assumptions.assumeTrue((boolean)this.isAddSupported());
        Assumptions.assumeTrue((boolean)this.isRemoveSupported());
        MultiValuedMap<K, V> map = this.makeObject();
        Assertions.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)"AA");
        Assertions.assertEquals((int)1, (int)map.size());
        map.put((Object)"B", (Object)"BA");
        Assertions.assertEquals((int)2, (int)map.size());
        map.put((Object)"B", (Object)"BB");
        Assertions.assertEquals((int)3, (int)map.size());
        map.put((Object)"B", (Object)"BC");
        Assertions.assertEquals((int)4, (int)map.size());
        map.remove((Object)"A");
        Assertions.assertEquals((int)3, (int)map.size());
        map.removeMapping((Object)"B", (Object)"BC");
        Assertions.assertEquals((int)2, (int)map.size());
    }

    @Test
    public void testToString() {
        Assumptions.assumeTrue((boolean)this.isAddSupported());
        MultiValuedMap map = this.makeObject();
        map.put((Object)"A", (Object)"X");
        map.put((Object)"A", (Object)"Y");
        map.put((Object)"A", (Object)"Z");
        map.put((Object)"B", (Object)"U");
        map.put((Object)"B", (Object)"V");
        map.put((Object)"B", (Object)"W");
        Assertions.assertTrue(("{A=[X, Y, Z], B=[U, V, W]}".equals(map.toString()) || "{B=[U, V, W], A=[X, Y, Z]}".equals(map.toString()) ? 1 : 0) != 0);
        MultiValuedMap originalNull = null;
        Assertions.assertThrows(NullPointerException.class, () -> map.putAll(originalNull), (String)"expecting NullPointerException");
        Assertions.assertTrue(("{A=[X, Y, Z], B=[U, V, W]}".equals(map.toString()) || "{B=[U, V, W], A=[X, Y, Z]}".equals(map.toString()) ? 1 : 0) != 0);
        map.remove((Object)"A");
        map.remove((Object)"B");
        Assertions.assertEquals((Object)"{}", (Object)map.toString());
    }

    @Test
    public void testValues() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        HashSet expected = new HashSet();
        int maxK = this.getSampleKeySize();
        int maxV = this.getSampleCountPerKey();
        for (int k = 0; k < maxK; ++k) {
            for (int v = 0; v < maxV; ++v) {
                expected.add(this.makeValue(k, v));
            }
        }
        Collection c = map.values();
        Assertions.assertEquals((int)this.getSampleTotalValueCount(), (int)c.size());
        Assertions.assertEquals(expected, new HashSet(c));
    }

    public class TestMultiValuedMapAsMap
    extends AbstractMapTest<K, Collection<V>> {
        public TestMultiValuedMapAsMap() {
            super("");
        }

        @Override
        public boolean areEqualElementsDistinguishable() {
            return true;
        }

        @Override
        protected int getIterationBehaviour() {
            return AbstractMultiValuedMapTest.this.getIterationBehaviour();
        }

        public Collection<V>[] getNewSampleValues() {
            boolean isSetValuedMap = AbstractMultiValuedMapTest.this.makeObject() instanceof SetValuedMap;
            int maxV = AbstractMultiValuedMapTest.this.getSampleTotalValueCount();
            int maxK = AbstractMultiValuedMapTest.this.getSampleKeySize();
            Object[] sampleValues = new Object[maxV];
            for (int v = 0; v < maxV; ++v) {
                sampleValues[v] = AbstractMultiValuedMapTest.this.makeValue(maxK + 9, v);
            }
            int cpk = AbstractMultiValuedMapTest.this.getSampleCountPerKey();
            Collection[] colArr = new Collection[maxK];
            for (int i = 0; i < maxK; ++i) {
                ArrayList<Object> coll = new ArrayList<Object>(cpk);
                for (int j = 0; j < cpk; ++j) {
                    coll.add(sampleValues[i * cpk + j]);
                }
                colArr[i] = isSetValuedMap ? new HashSet(coll) : coll;
            }
            return colArr;
        }

        @Override
        public K[] getSampleKeys() {
            K[] samplekeys = AbstractMultiValuedMapTest.this.getSampleKeys();
            int maxK = AbstractMultiValuedMapTest.this.getSampleKeySize();
            int cpk = AbstractMultiValuedMapTest.this.getSampleCountPerKey();
            Object[] finalKeys = new Object[maxK];
            for (int i = 0; i < maxK; ++i) {
                finalKeys[i] = samplekeys[i * cpk];
            }
            return finalKeys;
        }

        public Collection<V>[] getSampleValues() {
            boolean isSetValuedMap = AbstractMultiValuedMapTest.this.makeObject() instanceof SetValuedMap;
            V[] sampleValues = AbstractMultiValuedMapTest.this.getSampleValues();
            int maxK = AbstractMultiValuedMapTest.this.getSampleKeySize();
            int cpk = AbstractMultiValuedMapTest.this.getSampleCountPerKey();
            Collection[] colArr = new Collection[maxK];
            for (int i = 0; i < maxK; ++i) {
                ArrayList coll = new ArrayList(cpk);
                for (int j = 0; j < cpk; ++j) {
                    coll.add(sampleValues[i * cpk + j]);
                }
                colArr[i] = isSetValuedMap ? new HashSet(coll) : coll;
            }
            return colArr;
        }

        @Override
        public boolean isAllowNullKey() {
            return AbstractMultiValuedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isPutAddSupported() {
            return false;
        }

        @Override
        public boolean isPutChangeSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMultiValuedMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public Map<K, Collection<V>> makeFullMap() {
            return AbstractMultiValuedMapTest.this.makeFullMap().asMap();
        }

        @Override
        public Map<K, Collection<V>> makeObject() {
            return AbstractMultiValuedMapTest.this.makeObject().asMap();
        }
    }

    public class TestMultiValuedMapEntries
    extends AbstractCollectionTest<Map.Entry<K, V>> {
        public TestMultiValuedMapEntries() {
            super("");
        }

        public Map.Entry<K, V>[] getFullElements() {
            return AbstractMultiValuedMapTest.this.makeFullMap().entries().toArray(new Map.Entry[0]);
        }

        @Override
        protected int getIterationBehaviour() {
            return AbstractMultiValuedMapTest.this.getIterationBehaviour();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMultiValuedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMultiValuedMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public Collection<Map.Entry<K, V>> makeConfirmedCollection() {
            return null;
        }

        @Override
        public Collection<Map.Entry<K, V>> makeConfirmedFullCollection() {
            return null;
        }

        @Override
        public Collection<Map.Entry<K, V>> makeFullCollection() {
            return AbstractMultiValuedMapTest.this.makeFullMap().entries();
        }

        @Override
        public Collection<Map.Entry<K, V>> makeObject() {
            return AbstractMultiValuedMapTest.this.makeObject().entries();
        }

        @Override
        public void resetEmpty() {
            AbstractMultiValuedMapTest.this.resetEmpty();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().entries());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().entries());
        }

        @Override
        public void resetFull() {
            AbstractMultiValuedMapTest.this.resetFull();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().entries());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().entries());
        }
    }

    public class TestMultiValuedMapKeys
    extends AbstractMultiSetTest<K> {
        public TestMultiValuedMapKeys() {
            super("");
        }

        @Override
        public K[] getFullElements() {
            return AbstractMultiValuedMapTest.this.getSampleKeys();
        }

        @Override
        protected int getIterationBehaviour() {
            return AbstractMultiValuedMapTest.this.getIterationBehaviour();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMultiValuedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isRemoveSupported() {
            return false;
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public MultiSet<K> makeFullCollection() {
            return AbstractMultiValuedMapTest.this.makeFullMap().keys();
        }

        @Override
        public MultiSet<K> makeObject() {
            return AbstractMultiValuedMapTest.this.makeObject().keys();
        }

        @Override
        public void resetEmpty() {
            AbstractMultiValuedMapTest.this.resetEmpty();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().keys());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().keys());
        }

        @Override
        public void resetFull() {
            AbstractMultiValuedMapTest.this.resetFull();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().keys());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().keys());
        }
    }

    public class TestMultiValuedMapKeySet
    extends AbstractSetTest<K> {
        public TestMultiValuedMapKeySet() {
            super("");
        }

        @Override
        public K[] getFullElements() {
            return AbstractMultiValuedMapTest.this.makeFullMap().keySet().toArray();
        }

        @Override
        protected int getIterationBehaviour() {
            return AbstractMultiValuedMapTest.this.getIterationBehaviour();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMultiValuedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMultiValuedMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public Set<K> makeFullCollection() {
            return AbstractMultiValuedMapTest.this.makeFullMap().keySet();
        }

        @Override
        public Set<K> makeObject() {
            return AbstractMultiValuedMapTest.this.makeObject().keySet();
        }
    }

    public class TestMultiValuedMapValues
    extends AbstractCollectionTest<V> {
        public TestMultiValuedMapValues() {
            super("");
        }

        @Override
        public V[] getFullElements() {
            return AbstractMultiValuedMapTest.this.getSampleValues();
        }

        @Override
        protected int getIterationBehaviour() {
            return AbstractMultiValuedMapTest.this.getIterationBehaviour();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMultiValuedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMultiValuedMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public Collection<V> makeConfirmedCollection() {
            return null;
        }

        @Override
        public Collection<V> makeConfirmedFullCollection() {
            return null;
        }

        @Override
        public Collection<V> makeFullCollection() {
            return AbstractMultiValuedMapTest.this.makeFullMap().values();
        }

        @Override
        public Collection<V> makeObject() {
            return AbstractMultiValuedMapTest.this.makeObject().values();
        }

        @Override
        public void resetEmpty() {
            AbstractMultiValuedMapTest.this.resetEmpty();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().values());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().values());
        }

        @Override
        public void resetFull() {
            AbstractMultiValuedMapTest.this.resetFull();
            this.setCollection(AbstractMultiValuedMapTest.this.getMap().values());
            this.setConfirmed(AbstractMultiValuedMapTest.this.getConfirmed().values());
        }
    }
}

