/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CaseInsensitiveMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public CaseInsensitiveMapTest() {
        super(CaseInsensitiveMapTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public CaseInsensitiveMap<K, V> makeObject() {
        return new CaseInsensitiveMap();
    }

    @Test
    public void testCaseInsensitive() {
        CaseInsensitiveMap<String, String> map = this.makeObject();
        map.put("One", "One");
        map.put("Two", "Two");
        Assertions.assertEquals((Object)"One", map.get("one"));
        Assertions.assertEquals((Object)"One", map.get("oNe"));
        map.put("two", "Three");
        Assertions.assertEquals((Object)"Three", map.get("Two"));
    }

    @Test
    public void testClone() {
        CaseInsensitiveMap map = new CaseInsensitiveMap(10);
        map.put((Object)"1", (Object)"1");
        CaseInsensitiveMap cloned = map.clone();
        Assertions.assertEquals((int)map.size(), (int)cloned.size());
        Assertions.assertSame((Object)map.get((Object)"1"), (Object)cloned.get((Object)"1"));
    }

    @Test
    public void testInitialCapacityZero() {
        CaseInsensitiveMap map = new CaseInsensitiveMap(0);
        Assertions.assertEquals((int)1, (int)map.data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocaleIndependence() {
        Locale orig = Locale.getDefault();
        Locale[] locales = new Locale[]{Locale.ENGLISH, new Locale("tr", "", ""), Locale.getDefault()};
        String[][] data = new String[][]{{"i", "I"}, {"\u03c2", "\u03c3"}, {"\u03a3", "\u03c2"}, {"\u03a3", "\u03c3"}};
        try {
            for (Locale locale : locales) {
                Locale.setDefault(locale);
                for (int j = 0; j < data.length; ++j) {
                    Assertions.assertTrue((boolean)data[j][0].equalsIgnoreCase(data[j][1]), (String)("Test data corrupt: " + j));
                    CaseInsensitiveMap map = new CaseInsensitiveMap();
                    map.put((Object)data[j][0], (Object)"value");
                    Assertions.assertEquals((Object)"value", (Object)map.get((Object)data[j][1]), (String)(Locale.getDefault() + ": " + j));
                }
            }
        }
        finally {
            Locale.setDefault(orig);
        }
    }

    @Test
    public void testNullHandling() {
        CaseInsensitiveMap<String, String> map = this.makeObject();
        map.put("One", "One");
        map.put("Two", "Two");
        map.put(null, "Three");
        Assertions.assertEquals((Object)"Three", map.get(null));
        map.put(null, "Four");
        Assertions.assertEquals((Object)"Four", map.get(null));
        Set keys = map.keySet();
        Assertions.assertTrue((boolean)keys.contains("one"));
        Assertions.assertTrue((boolean)keys.contains("two"));
        Assertions.assertTrue((boolean)keys.contains(null));
        Assertions.assertEquals((int)3, (int)keys.size());
    }

    @Test
    public void testPutAll() {
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put("One", "One");
        map.put("Two", "Two");
        map.put("one", "Three");
        map.put(null, "Four");
        map.put(20, "Five");
        CaseInsensitiveMap caseInsensitiveMap = new CaseInsensitiveMap(map);
        Assertions.assertEquals((int)4, (int)caseInsensitiveMap.size());
        Set keys = caseInsensitiveMap.keySet();
        Assertions.assertTrue((boolean)keys.contains("one"));
        Assertions.assertTrue((boolean)keys.contains("two"));
        Assertions.assertTrue((boolean)keys.contains(null));
        Assertions.assertTrue((boolean)keys.contains(Integer.toString(20)));
        Assertions.assertEquals((int)4, (int)keys.size());
        Assertions.assertTrue((!caseInsensitiveMap.containsValue("One") || !caseInsensitiveMap.containsValue("Three") ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"Four", caseInsensitiveMap.get(null));
    }
}

