/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.map.AbstractMapTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractSortedMapTest<K, V>
extends AbstractMapTest<K, V> {
    public AbstractSortedMapTest(String testName) {
        super(testName);
    }

    public BulkTest bulkTestHeadMap() {
        return new TestHeadMap(this);
    }

    public BulkTest bulkTestSubMap() {
        return new TestSubMap(this);
    }

    public BulkTest bulkTestTailMap() {
        return new TestTailMap(this);
    }

    @Override
    public SortedMap<K, V> getConfirmed() {
        return (SortedMap)super.getConfirmed();
    }

    @Override
    public SortedMap<K, V> getMap() {
        return (SortedMap)super.getMap();
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public SortedMap<K, V> makeConfirmedMap() {
        return new TreeMap();
    }

    @Override
    public SortedMap<K, V> makeFullMap() {
        return (SortedMap)super.makeFullMap();
    }

    @Override
    public abstract SortedMap<K, V> makeObject();

    @Test
    public void testComparator() {
    }

    @Test
    public void testFirstKey() {
        Map sm = this.makeFullMap();
        Assertions.assertSame(sm.keySet().iterator().next(), sm.firstKey());
    }

    @Test
    public void testLastKey() {
        Map sm = this.makeFullMap();
        Object obj = null;
        for (Object k : sm.keySet()) {
            obj = k;
        }
        Assertions.assertSame(obj, sm.lastKey());
    }

    public static class TestHeadMap<K, V>
    extends TestViewMap<K, V> {
        static final int SUBSIZE = 6;
        final K toKey;

        public TestHeadMap(AbstractMapTest<K, V> main) {
            super("SortedMap.HeadMap", main);
            Map<K, V> sm = main.makeFullMap();
            for (Map.Entry<K, V> entry : sm.entrySet()) {
                this.subSortedKeys.add(entry.getKey());
                this.subSortedValues.add(entry.getValue());
            }
            this.toKey = this.subSortedKeys.get(6);
            this.subSortedKeys.subList(6, this.subSortedKeys.size()).clear();
            this.subSortedValues.subList(6, this.subSortedValues.size()).clear();
            this.subSortedNewValues.addAll(Arrays.asList(main.getNewSampleValues()).subList(0, 6));
        }

        @Override
        public String getCompatibilityVersion() {
            return this.main.getCompatibilityVersion() + ".HeadMapView";
        }

        @Override
        public SortedMap<K, V> makeFullMap() {
            return ((SortedMap)this.main.makeFullMap()).headMap(this.toKey);
        }

        @Override
        public SortedMap<K, V> makeObject() {
            return ((SortedMap)this.main.makeObject()).headMap(this.toKey);
        }

        @Test
        public void testHeadMapOutOfRange() {
            if (!this.isPutAddSupported()) {
                return;
            }
            this.resetEmpty();
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.getMap().put(this.toKey, this.subSortedValues.get(0)));
            this.verify();
        }
    }

    public static class TestSubMap<K, V>
    extends TestViewMap<K, V> {
        static final int SUBSIZE = 3;
        final K fromKey;
        final K toKey;

        public TestSubMap(AbstractMapTest<K, V> main) {
            super("SortedMap.SubMap", main);
            Map<K, V> sm = main.makeFullMap();
            for (Map.Entry<K, V> entry : sm.entrySet()) {
                this.subSortedKeys.add(entry.getKey());
                this.subSortedValues.add(entry.getValue());
            }
            this.fromKey = this.subSortedKeys.get(3);
            this.toKey = this.subSortedKeys.get(this.subSortedKeys.size() - 3);
            this.subSortedKeys.subList(0, 3).clear();
            this.subSortedKeys.subList(this.subSortedKeys.size() - 3, this.subSortedKeys.size()).clear();
            this.subSortedValues.subList(0, 3).clear();
            this.subSortedValues.subList(this.subSortedValues.size() - 3, this.subSortedValues.size()).clear();
            this.subSortedNewValues.addAll(Arrays.asList(main.getNewSampleValues()).subList(3, this.main.getNewSampleValues().length - 3));
        }

        @Override
        public String getCompatibilityVersion() {
            return this.main.getCompatibilityVersion() + ".SubMapView";
        }

        @Override
        public SortedMap<K, V> makeFullMap() {
            return ((SortedMap)this.main.makeFullMap()).subMap(this.fromKey, this.toKey);
        }

        @Override
        public SortedMap<K, V> makeObject() {
            return ((SortedMap)this.main.makeObject()).subMap(this.fromKey, this.toKey);
        }

        @Test
        public void testSubMapOutOfRange() {
            if (!this.isPutAddSupported()) {
                return;
            }
            this.resetEmpty();
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.getMap().put(this.toKey, this.subSortedValues.get(0)));
            this.verify();
        }
    }

    public static class TestTailMap<K, V>
    extends TestViewMap<K, V> {
        static final int SUBSIZE = 6;
        final K fromKey;
        final K invalidKey;

        public TestTailMap(AbstractMapTest<K, V> main) {
            super("SortedMap.TailMap", main);
            Map<K, V> sm = main.makeFullMap();
            for (Map.Entry<K, V> entry : sm.entrySet()) {
                this.subSortedKeys.add(entry.getKey());
                this.subSortedValues.add(entry.getValue());
            }
            this.fromKey = this.subSortedKeys.get(this.subSortedKeys.size() - 6);
            this.invalidKey = this.subSortedKeys.get(this.subSortedKeys.size() - 6 - 1);
            this.subSortedKeys.subList(0, this.subSortedKeys.size() - 6).clear();
            this.subSortedValues.subList(0, this.subSortedValues.size() - 6).clear();
            this.subSortedNewValues.addAll(Arrays.asList(main.getNewSampleValues()).subList(0, 6));
        }

        @Override
        public String getCompatibilityVersion() {
            return this.main.getCompatibilityVersion() + ".TailMapView";
        }

        @Override
        public SortedMap<K, V> makeFullMap() {
            return ((SortedMap)this.main.makeFullMap()).tailMap(this.fromKey);
        }

        @Override
        public SortedMap<K, V> makeObject() {
            return ((SortedMap)this.main.makeObject()).tailMap(this.fromKey);
        }

        @Test
        public void testTailMapOutOfRange() {
            if (!this.isPutAddSupported()) {
                return;
            }
            this.resetEmpty();
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.getMap().put(this.invalidKey, this.subSortedValues.get(0)));
            this.verify();
        }
    }

    public static abstract class TestViewMap<K, V>
    extends AbstractSortedMapTest<K, V> {
        protected final AbstractMapTest<K, V> main;
        protected final List<K> subSortedKeys = new ArrayList<K>();
        protected final List<V> subSortedValues = new ArrayList<V>();
        protected final List<V> subSortedNewValues = new ArrayList<V>();

        public TestViewMap(String name, AbstractMapTest<K, V> main) {
            super(name);
            this.main = main;
        }

        @Override
        public BulkTest bulkTestHeadMap() {
            return null;
        }

        @Override
        public BulkTest bulkTestSubMap() {
            return null;
        }

        @Override
        public BulkTest bulkTestTailMap() {
            return null;
        }

        @Override
        public V[] getNewSampleValues() {
            return this.subSortedNewValues.toArray();
        }

        @Override
        public K[] getSampleKeys() {
            return this.subSortedKeys.toArray();
        }

        @Override
        public V[] getSampleValues() {
            return this.subSortedValues.toArray();
        }

        @Override
        public boolean isAllowNullKey() {
            return this.main.isAllowNullKey();
        }

        @Override
        public boolean isAllowNullValue() {
            return this.main.isAllowNullValue();
        }

        @Override
        public boolean isPutAddSupported() {
            return this.main.isPutAddSupported();
        }

        @Override
        public boolean isPutChangeSupported() {
            return this.main.isPutChangeSupported();
        }

        @Override
        public boolean isRemoveSupported() {
            return this.main.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public void resetEmpty() {
            this.main.resetEmpty();
            super.resetEmpty();
        }

        @Override
        public void resetFull() {
            this.main.resetFull();
            super.resetFull();
        }

        @Override
        public void verify() {
            super.verify();
            this.main.verify();
        }
    }
}

