/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.collections4.list.AbstractLinkedListTest;
import org.apache.commons.collections4.list.NodeCachingLinkedList;
import org.junit.jupiter.api.Test;

public class NodeCachingLinkedListTest<E>
extends AbstractLinkedListTest<E> {
    public static void compareSpeed() {
        int x;
        NodeCachingLinkedList ncll = new NodeCachingLinkedList();
        LinkedList<Object> ll = new LinkedList<Object>();
        Object o1 = new Object();
        Object o2 = new Object();
        int loopCount = 4000000;
        System.out.println("Testing relative execution time of commonly-used methods...");
        long startTime = System.currentTimeMillis();
        for (x = 4000000; x > 0; --x) {
            ll.addFirst(o1);
            ll.addLast(o2);
            ll.removeFirst();
            ll.removeLast();
            ll.add(o1);
            ll.remove(0);
            ll.addFirst(o1);
            ll.addLast(o2);
            ll.removeFirst();
            ll.removeLast();
            ll.add(o1);
            ll.remove(0);
            ll.addFirst(o1);
            ll.addLast(o2);
            ll.removeFirst();
            ll.removeLast();
            ll.add(o1);
            ll.remove(0);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Time with LinkedList: " + (endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        for (x = 4000000; x > 0; --x) {
            ncll.addFirst(o1);
            ncll.addLast(o2);
            ncll.removeFirst();
            ncll.removeLast();
            ncll.add(o1);
            ncll.remove(0);
            ncll.addFirst(o1);
            ncll.addLast(o2);
            ncll.removeFirst();
            ncll.removeLast();
            ncll.add(o1);
            ncll.remove(0);
            ncll.addFirst(o1);
            ncll.addLast(o2);
            ncll.removeFirst();
            ncll.removeLast();
            ncll.add(o1);
            ncll.remove(0);
        }
        endTime = System.currentTimeMillis();
        System.out.println("Time with NodeCachingLinkedList: " + (endTime - startTime) + " ms");
    }

    public NodeCachingLinkedListTest() {
        super(NodeCachingLinkedListTest.class.getSimpleName());
    }

    @Override
    public NodeCachingLinkedList<E> getCollection() {
        return (NodeCachingLinkedList)super.getCollection();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public NodeCachingLinkedList<E> makeObject() {
        return new NodeCachingLinkedList();
    }

    @Test
    public void testShrinkCache() {
        if (!this.isRemoveSupported() || !this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        NodeCachingLinkedList<E> list = this.getCollection();
        list.addAll(Arrays.asList((Object[])new String[]{"1", "2", "3", "4"}));
        list.removeAllNodes();
        list.setMaximumCacheSize(2);
        list.addAll(Arrays.asList((Object[])new String[]{"1", "2", "3", "4"}));
        this.checkNodes();
        list.removeNode(list.getNode(0, false));
        list.removeNode(list.getNode(0, false));
        list.removeNode(list.getNode(0, false));
        this.checkNodes();
        list.addAll(Arrays.asList((Object[])new String[]{"1", "2", "3", "4"}));
        this.checkNodes();
    }
}

