/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.Arrays;
import org.apache.commons.collections4.list.AbstractLinkedList;
import org.apache.commons.collections4.list.AbstractListTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractLinkedListTest<E>
extends AbstractListTest<E> {
    public AbstractLinkedListTest(String testName) {
        super(testName);
    }

    protected void checkNodes() {
        AbstractLinkedList<E> list = this.getCollection();
        for (int i = 0; i < list.size; ++i) {
            Assertions.assertEquals((Object)list.getNode((int)i, (boolean)false).next, (Object)list.getNode(i + 1, true));
            if (i >= list.size - 1) continue;
            Assertions.assertEquals((Object)list.getNode((int)(i + 1), (boolean)false).previous, (Object)list.getNode(i, false));
        }
    }

    @Override
    public AbstractLinkedList<E> getCollection() {
        return (AbstractLinkedList)super.getCollection();
    }

    @Test
    public void testAddNodeAfter() {
        this.resetEmpty();
        AbstractLinkedList<E> list = this.getCollection();
        if (!this.isAddSupported()) {
            try {
                list.addFirst(null);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        list.addFirst((Object)"value1");
        list.addNodeAfter(list.getNode(0, false), (Object)"value2");
        Assertions.assertEquals((Object)"value1", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value2", (Object)list.getLast());
        list.removeFirst();
        this.checkNodes();
        list.addNodeAfter(list.getNode(0, false), (Object)"value3");
        this.checkNodes();
        Assertions.assertEquals((Object)"value2", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value3", (Object)list.getLast());
        list.addNodeAfter(list.getNode(0, false), (Object)"value4");
        this.checkNodes();
        Assertions.assertEquals((Object)"value2", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value3", (Object)list.getLast());
        Assertions.assertEquals((Object)"value4", (Object)list.get(1));
        list.addNodeAfter(list.getNode(2, false), (Object)"value5");
        this.checkNodes();
        Assertions.assertEquals((Object)"value2", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value4", (Object)list.get(1));
        Assertions.assertEquals((Object)"value3", (Object)list.get(2));
        Assertions.assertEquals((Object)"value5", (Object)list.getLast());
    }

    @Test
    public void testGetNode() {
        this.resetEmpty();
        AbstractLinkedList list = this.getCollection();
        Assertions.assertEquals((Object)list.getNode((int)0, (boolean)true).previous, (Object)list.getNode((int)0, (boolean)true).next);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> list.getNode(0, false), (String)"Expecting IndexOutOfBoundsException.");
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        this.checkNodes();
        list.addFirst((Object)"value0");
        this.checkNodes();
        list.removeNode(list.getNode(1, false));
        this.checkNodes();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> list.getNode(2, false), (String)"Expecting IndexOutOfBoundsException.");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> list.getNode(-1, false), (String)"Expecting IndexOutOfBoundsException.");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> list.getNode(3, true), (String)"Expecting IndexOutOfBoundsException.");
    }

    @Test
    public void testRemoveFirst() {
        this.resetEmpty();
        AbstractLinkedList<E> list = this.getCollection();
        if (!this.isRemoveSupported()) {
            try {
                list.removeFirst();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        Assertions.assertEquals((Object)"value1", (Object)list.removeFirst());
        this.checkNodes();
        list.addLast((Object)"value3");
        this.checkNodes();
        Assertions.assertEquals((Object)"value2", (Object)list.removeFirst());
        Assertions.assertEquals((Object)"value3", (Object)list.removeFirst());
        this.checkNodes();
        list.addLast((Object)"value4");
        this.checkNodes();
        Assertions.assertEquals((Object)"value4", (Object)list.removeFirst());
        this.checkNodes();
    }

    @Test
    public void testRemoveLast() {
        this.resetEmpty();
        AbstractLinkedList<E> list = this.getCollection();
        if (!this.isRemoveSupported()) {
            try {
                list.removeLast();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        Assertions.assertEquals((Object)"value2", (Object)list.removeLast());
        list.addFirst((Object)"value3");
        this.checkNodes();
        Assertions.assertEquals((Object)"value1", (Object)list.removeLast());
        Assertions.assertEquals((Object)"value3", (Object)list.removeLast());
        list.addFirst((Object)"value4");
        this.checkNodes();
        Assertions.assertEquals((Object)"value4", (Object)list.removeFirst());
    }

    @Test
    public void testRemoveNode() {
        this.resetEmpty();
        if (!this.isAddSupported() || !this.isRemoveSupported()) {
            return;
        }
        AbstractLinkedList<E> list = this.getCollection();
        list.addAll(Arrays.asList((Object[])new String[]{"value1", "value2"}));
        list.removeNode(list.getNode(0, false));
        this.checkNodes();
        Assertions.assertEquals((Object)"value2", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value2", (Object)list.getLast());
        list.addFirst((Object)"value1");
        list.addFirst((Object)"value0");
        this.checkNodes();
        list.removeNode(list.getNode(1, false));
        Assertions.assertEquals((Object)"value0", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value2", (Object)list.getLast());
        this.checkNodes();
        list.removeNode(list.getNode(1, false));
        Assertions.assertEquals((Object)"value0", (Object)list.getFirst());
        Assertions.assertEquals((Object)"value0", (Object)list.getLast());
        this.checkNodes();
    }
}

