/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.collections4.bloomfilter.AbstractBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.DefaultBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.LayerManager;
import org.apache.commons.collections4.bloomfilter.LayeredBloomFilter;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;
import org.apache.commons.collections4.bloomfilter.SparseBloomFilter;
import org.apache.commons.collections4.bloomfilter.TestingHashers;
import org.apache.commons.collections4.bloomfilter.WrappedBloomFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LayeredBloomFilterTest
extends AbstractBloomFilterTest<LayeredBloomFilter<?>> {
    private static final List<String> dbgInstrument = new ArrayList<String>();
    private final Predicate<BloomFilter> dbg = bf -> {
        TimestampedBloomFilter tbf = (TimestampedBloomFilter)((Object)bf);
        long ts = System.currentTimeMillis();
        dbgInstrument.add(String.format("T:%s (Elapsed:%s)- EstN:%s (Card:%s)\n", tbf.timestamp, ts - tbf.timestamp, tbf.estimateN(), tbf.cardinality()));
        return true;
    };

    static LayeredBloomFilter<TimestampedBloomFilter> createTimedLayeredFilter(Shape shape, long duration, TimeUnit dUnit, long quanta, TimeUnit qUnit) {
        LayerManager.Builder builder = LayerManager.builder();
        Consumer cleanup = LayerManager.Cleanup.removeEmptyTarget().andThen(new CleanByTime(duration, dUnit));
        LayerManager layerManager = builder.setSupplier(() -> new TimestampedBloomFilter((BloomFilter)new SimpleBloomFilter(shape))).setCleanup(cleanup).setExtendCheck(new AdvanceOnTimeQuanta(quanta, qUnit).or(LayerManager.ExtendCheck.advanceOnSaturation((double)shape.estimateMaxN()))).build();
        return new LayeredBloomFilter(shape, layerManager);
    }

    public static LayeredBloomFilter<BloomFilter> fixed(Shape shape, int maxDepth) {
        return LayeredBloomFilterTest.fixed(shape, maxDepth, () -> new SimpleBloomFilter(shape));
    }

    public static <T extends BloomFilter> LayeredBloomFilter<T> fixed(Shape shape, int maxDepth, Supplier<T> supplier) {
        LayerManager.Builder builder = LayerManager.builder();
        builder.setExtendCheck(LayerManager.ExtendCheck.advanceOnPopulated()).setCleanup(LayerManager.Cleanup.onMaxSize((int)maxDepth)).setSupplier(supplier);
        return new LayeredBloomFilter(shape, builder.build());
    }

    @Override
    protected LayeredBloomFilter<BloomFilter> createEmptyFilter(Shape shape) {
        return LayeredBloomFilterTest.fixed(shape, 10);
    }

    protected BloomFilter makeFilter(Hasher h) {
        SparseBloomFilter bf = new SparseBloomFilter(this.getTestShape());
        bf.merge(h);
        return bf;
    }

    protected BloomFilter makeFilter(IndexExtractor p) {
        SparseBloomFilter bf = new SparseBloomFilter(this.getTestShape());
        bf.merge(p);
        return bf;
    }

    protected BloomFilter makeFilter(int ... values) {
        return this.makeFilter(IndexExtractor.fromIndexArray((int[])values));
    }

    private LayeredBloomFilter<BloomFilter> setupFindTest() {
        LayeredBloomFilter<BloomFilter> filter = LayeredBloomFilterTest.fixed(this.getTestShape(), 10);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        filter.merge((Hasher)new IncrementingHasher(11L, 2L));
        filter.merge((BloomFilter)TestingHashers.populateFromHashersFrom1AndFrom11(new SimpleBloomFilter(this.getTestShape())));
        return filter;
    }

    @Override
    @Test
    public void testCardinalityAndIsEmpty() {
        LayerManager layerManager = LayerManager.builder().setExtendCheck(LayerManager.ExtendCheck.neverAdvance()).setSupplier(() -> new SimpleBloomFilter(this.getTestShape())).build();
        this.testCardinalityAndIsEmpty((BloomFilter)new LayeredBloomFilter(this.getTestShape(), layerManager));
    }

    @Test
    public void testCleanup() {
        int[] sequence = new int[]{1};
        LayerManager layerManager = LayerManager.builder().setSupplier(() -> {
            int n = sequence[0];
            sequence[0] = n + 1;
            return new NumberedBloomFilter(this.getTestShape(), 3, n);
        }).setExtendCheck(LayerManager.ExtendCheck.neverAdvance()).setCleanup(ll -> ll.removeIf(f -> ((NumberedBloomFilter)f).value-- == 0)).build();
        LayeredBloomFilter underTest = new LayeredBloomFilter(this.getTestShape(), layerManager);
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        underTest.merge(TestingHashers.randomHasher());
        underTest.cleanup();
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        underTest.next();
        Assertions.assertEquals((int)2, (int)underTest.getDepth());
        underTest.merge(TestingHashers.randomHasher());
        underTest.cleanup();
        NumberedBloomFilter f = (NumberedBloomFilter)underTest.get(0);
        Assertions.assertEquals((int)1, (int)f.sequence);
        Assertions.assertEquals((int)2, (int)underTest.getDepth());
        underTest.cleanup();
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        f = (NumberedBloomFilter)underTest.get(0);
        Assertions.assertEquals((int)2, (int)f.sequence);
        underTest.cleanup();
        underTest.cleanup();
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        f = (NumberedBloomFilter)underTest.get(0);
        Assertions.assertEquals((int)3, (int)f.sequence);
    }

    @Test
    public final void testEstimateUnionCrossTypes() {
        Object bf = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        DefaultBloomFilterTest.SparseDefaultBloomFilter bf2 = new DefaultBloomFilterTest.SparseDefaultBloomFilter(this.getTestShape());
        bf2.merge(TestingHashers.FROM11);
        Assertions.assertEquals((int)2, (int)bf.estimateUnion((BloomFilter)bf2));
        Assertions.assertEquals((int)2, (int)bf2.estimateUnion((BloomFilter)bf));
    }

    @Test
    public void testExpiration() throws InterruptedException {
        int i;
        ArrayList lst = new ArrayList();
        Shape shape = Shape.fromNM((int)4, (int)64);
        LayeredBloomFilter<TimestampedBloomFilter> underTest = LayeredBloomFilterTest.createTimedLayeredFilter(shape, 600L, TimeUnit.MILLISECONDS, 150L, TimeUnit.MILLISECONDS);
        for (i = 0; i < 10; ++i) {
            underTest.merge(TestingHashers.randomHasher());
        }
        underTest.processBloomFilters(this.dbg.and(x -> lst.add(((TimestampedBloomFilter)x).timestamp)));
        Assertions.assertTrue((underTest.getDepth() > 1 ? 1 : 0) != 0);
        Thread.sleep(300L);
        for (i = 0; i < 10; ++i) {
            underTest.merge(TestingHashers.randomHasher());
        }
        dbgInstrument.add("=== AFTER 300 milliseconds ====\n");
        underTest.processBloomFilters(this.dbg);
        Thread.sleep(150L);
        for (i = 0; i < 10; ++i) {
            underTest.merge(TestingHashers.randomHasher());
        }
        dbgInstrument.add("=== AFTER 450 milliseconds ====\n");
        underTest.processBloomFilters(this.dbg);
        Thread.sleep(200L);
        underTest.merge(TestingHashers.randomHasher());
        dbgInstrument.add("=== AFTER 600 milliseconds ====\n");
        Assertions.assertTrue((boolean)underTest.processBloomFilters(this.dbg.and(x -> !lst.contains(((TimestampedBloomFilter)x).timestamp))), (String)("Found filter that should have been deleted: " + dbgInstrument.get(dbgInstrument.size() - 1)));
    }

    @Test
    public void testFindBitMapExtractor() {
        LayeredBloomFilter<BloomFilter> filter = this.setupFindTest();
        IndexExtractor indexExtractor = TestingHashers.FROM1.indices(this.getTestShape());
        BitMapExtractor bitMapExtractor = BitMapExtractor.fromIndexExtractor((IndexExtractor)indexExtractor, (int)this.getTestShape().getNumberOfBits());
        int[] expected = new int[]{0, 3};
        int[] result = filter.find(bitMapExtractor);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
        expected = new int[]{1, 3};
        indexExtractor = TestingHashers.FROM11.indices(this.getTestShape());
        bitMapExtractor = BitMapExtractor.fromIndexExtractor((IndexExtractor)indexExtractor, (int)this.getTestShape().getNumberOfBits());
        result = filter.find(bitMapExtractor);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
    }

    @Test
    public void testFindBloomFilter() {
        LayeredBloomFilter<BloomFilter> filter = this.setupFindTest();
        int[] expected = new int[]{0, 3};
        int[] result = filter.find(TestingHashers.FROM1);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
        expected = new int[]{1, 3};
        result = filter.find(TestingHashers.FROM11);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
    }

    @Test
    public void testFindIndexExtractor() {
        IndexExtractor indexExtractor = TestingHashers.FROM1.indices(this.getTestShape());
        LayeredBloomFilter<BloomFilter> filter = this.setupFindTest();
        int[] expected = new int[]{0, 3};
        int[] result = filter.find(indexExtractor);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
        expected = new int[]{1, 3};
        indexExtractor = TestingHashers.FROM11.indices(this.getTestShape());
        result = filter.find(indexExtractor);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
    }

    @Test
    public final void testGetLayer() {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.getTestShape());
        bf.merge(TestingHashers.FROM11);
        LayeredBloomFilter<BloomFilter> filter = LayeredBloomFilterTest.fixed(this.getTestShape(), 10);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        filter.merge((Hasher)new IncrementingHasher(11L, 2L));
        filter.merge((BloomFilter)TestingHashers.populateFromHashersFrom1AndFrom11(new SimpleBloomFilter(this.getTestShape())));
        Assertions.assertArrayEquals((long[])bf.asBitMapArray(), (long[])filter.get(1).asBitMapArray());
    }

    @Test
    public void testMultipleFilters() {
        LayeredBloomFilter<BloomFilter> filter = LayeredBloomFilterTest.fixed(this.getTestShape(), 10);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        Assertions.assertEquals((int)2, (int)filter.getDepth());
        Assertions.assertTrue((boolean)filter.contains(this.makeFilter(TestingHashers.FROM1)));
        Assertions.assertTrue((boolean)filter.contains(this.makeFilter(TestingHashers.FROM11)));
        BloomFilter t1 = this.makeFilter(6, 7, 17, 18, 19);
        Assertions.assertFalse((boolean)filter.contains(t1));
        Assertions.assertFalse((boolean)filter.copy().contains(t1));
        Assertions.assertTrue((boolean)filter.flatten().contains(t1));
    }

    @Test
    public final void testNext() {
        LayerManager layerManager = LayerManager.builder().setSupplier(() -> new SimpleBloomFilter(this.getTestShape())).build();
        LayeredBloomFilter filter = new LayeredBloomFilter(this.getTestShape(), layerManager);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        Assertions.assertEquals((int)1, (int)filter.getDepth());
        filter.next();
        filter.merge((Hasher)new IncrementingHasher(11L, 2L));
        Assertions.assertEquals((int)2, (int)filter.getDepth());
        Assertions.assertTrue((boolean)filter.get(0).contains(TestingHashers.FROM1));
        Assertions.assertTrue((boolean)filter.get(0).contains(TestingHashers.FROM11));
        Assertions.assertFalse((boolean)filter.get(0).contains((Hasher)new IncrementingHasher(11L, 2L)));
        Assertions.assertFalse((boolean)filter.get(1).contains(TestingHashers.FROM1));
        Assertions.assertFalse((boolean)filter.get(1).contains(TestingHashers.FROM11));
        Assertions.assertTrue((boolean)filter.get(1).contains((Hasher)new IncrementingHasher(11L, 2L)));
    }

    static class CleanByTime<T extends TimestampedBloomFilter>
    implements Consumer<List<T>> {
        long elapsedTime;

        CleanByTime(long duration, TimeUnit unit) {
            this.elapsedTime = unit.toMillis(duration);
        }

        @Override
        public void accept(List<T> t) {
            long min = System.currentTimeMillis() - this.elapsedTime;
            Iterator<T> iter = t.iterator();
            while (iter.hasNext()) {
                TimestampedBloomFilter bf = (TimestampedBloomFilter)((Object)iter.next());
                if (bf.getTimestamp() >= min) {
                    return;
                }
                dbgInstrument.add(String.format("Removing old entry: T:%s (Aged: %s) \n", bf.getTimestamp(), min - bf.getTimestamp()));
                iter.remove();
            }
        }
    }

    static class AdvanceOnTimeQuanta
    implements Predicate<LayerManager<TimestampedBloomFilter>> {
        long quanta;

        AdvanceOnTimeQuanta(long quanta, TimeUnit unit) {
            this.quanta = unit.toMillis(quanta);
        }

        @Override
        public boolean test(LayerManager<TimestampedBloomFilter> lm) {
            return ((TimestampedBloomFilter)lm.last()).timestamp + this.quanta < System.currentTimeMillis();
        }
    }

    static class NumberedBloomFilter
    extends WrappedBloomFilter {
        int value;
        int sequence;

        NumberedBloomFilter(Shape shape, int value, int sequence) {
            super((BloomFilter)new SimpleBloomFilter(shape));
            this.value = value;
            this.sequence = sequence;
        }

        public BloomFilter copy() {
            return new NumberedBloomFilter(this.getShape(), this.value, this.sequence);
        }
    }

    public static class TimestampedBloomFilter
    extends WrappedBloomFilter {
        final long timestamp;

        TimestampedBloomFilter(BloomFilter bf) {
            super(bf);
            this.timestamp = System.currentTimeMillis();
        }

        TimestampedBloomFilter(BloomFilter bf, long timestamp) {
            super(bf);
            this.timestamp = timestamp;
        }

        public TimestampedBloomFilter copy() {
            return new TimestampedBloomFilter(this.getWrapped().copy(), this.timestamp);
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

