/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.apache.commons.collections4.bloomfilter.AbstractIndexExtractorTest;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.BitMaps;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class DefaultIndexExtractorTest
extends AbstractIndexExtractorTest {
    private final int[] values = new int[]{10, 1, 10, 1};

    public static int[] generateIntArray(int size, int bound) {
        return ThreadLocalRandom.current().ints(size, 0, bound).toArray();
    }

    public static int[] unique(int[] ary) {
        return Arrays.stream(ary).distinct().sorted().toArray();
    }

    public static BitSet uniqueSet(int[] ary) {
        BitSet bs = new BitSet();
        Arrays.stream(ary).forEach(bs::set);
        return bs;
    }

    @Override
    protected IndexExtractor createEmptyExtractor() {
        return predicate -> {
            Objects.requireNonNull(predicate);
            return true;
        };
    }

    @Override
    protected IndexExtractor createExtractor() {
        return predicate -> {
            Objects.requireNonNull(predicate);
            for (int i : this.values) {
                if (predicate.test(i)) continue;
                return false;
            }
            return true;
        };
    }

    @Override
    protected int getAsIndexArrayBehaviour() {
        return 0;
    }

    @Override
    protected int[] getExpectedIndices() {
        return this.values;
    }

    @Override
    protected int getForEachIndexBehaviour() {
        return 0;
    }

    @ParameterizedTest
    @ValueSource(ints={32, 33})
    public void testEntries(int size) {
        int[] values = IntStream.range(0, size).toArray();
        IndexExtractor indexExtractor = predicate -> {
            Objects.requireNonNull(predicate);
            for (int i : values) {
                if (predicate.test(i)) continue;
                return false;
            }
            return true;
        };
        int[] other = indexExtractor.asIndexArray();
        Assertions.assertArrayEquals((int[])values, (int[])other);
    }

    @Test
    public void testFromBitMapExtractor() {
        for (int i = 0; i < 5; ++i) {
            int[] expected = DefaultIndexExtractorTest.generateIntArray(7, 256);
            long[] bits = new long[BitMaps.numberOfBitMaps((int)256)];
            for (int bitIndex : expected) {
                BitMaps.set((long[])bits, (int)bitIndex);
            }
            IndexExtractor ip = IndexExtractor.fromBitMapExtractor((BitMapExtractor)BitMapExtractor.fromBitMapArray((long[])bits));
            Assertions.assertArrayEquals((int[])DefaultIndexExtractorTest.unique(expected), (int[])ip.asIndexArray());
        }
    }

    @Test
    public void testFromIndexArray() {
        for (int i = 0; i < 5; ++i) {
            int[] expected = DefaultIndexExtractorTest.generateIntArray(10, 256);
            IndexExtractor ip = IndexExtractor.fromIndexArray((int[])expected);
            Assertions.assertArrayEquals((int[])expected, (int[])ip.asIndexArray());
        }
    }
}

