/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.function.BiPredicate;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.BloomFilterExtractor;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractBloomFilterExtractorTest {
    private final Shape shape = Shape.fromKM((int)17, (int)72);
    BloomFilter one = new SimpleBloomFilter(this.shape);
    BloomFilter two = new SimpleBloomFilter(this.shape);
    int[] nullCount = new int[]{0, 0};
    int[] equalityCount = new int[]{0};
    BiPredicate<BloomFilter, BloomFilter> counter = (x, y) -> {
        if (x == null) {
            this.nullCount[0] = this.nullCount[0] + 1;
        }
        if (y == null) {
            this.nullCount[1] = this.nullCount[1] + 1;
        }
        if (x != null && y != null && x.cardinality() == y.cardinality()) {
            this.equalityCount[0] = this.equalityCount[0] + 1;
        }
        return true;
    };

    private BloomFilterExtractor createUnderTest() {
        return this.createUnderTest(this.one, this.two);
    }

    protected abstract BloomFilterExtractor createUnderTest(BloomFilter ... var1);

    protected Shape getTestShape() {
        return this.shape;
    }

    @BeforeEach
    public void setup() {
        this.one.clear();
        this.one.merge(IndexExtractor.fromIndexArray((int[])new int[]{1}));
        this.two.clear();
        this.two.merge(IndexExtractor.fromIndexArray((int[])new int[]{2, 3}));
        this.nullCount[0] = 0;
        this.nullCount[1] = 0;
        this.equalityCount[0] = 0;
    }

    @Test
    public void testAsBloomFilterArray() {
        BloomFilter[] result = this.createUnderTest().asBloomFilterArray();
        Assertions.assertEquals((int)2, (int)result.length);
        Assertions.assertEquals((int)1, (int)result[0].cardinality());
        Assertions.assertEquals((int)2, (int)result[1].cardinality());
    }

    @Test
    public void testFlatten() {
        BloomFilter underTest = this.createUnderTest().flatten();
        SimpleBloomFilter expected = new SimpleBloomFilter(this.shape);
        expected.merge(IndexExtractor.fromIndexArray((int[])new int[]{1, 2, 3}));
        Assertions.assertArrayEquals((long[])expected.asBitMapArray(), (long[])underTest.asBitMapArray());
    }

    @Test
    public void testForEachPairArrayTooLong() {
        Assertions.assertTrue((boolean)this.createUnderTest().processBloomFilterPair(BloomFilterExtractor.fromBloomFilterArray((BloomFilter[])new BloomFilter[]{this.one, this.two, this.one}), this.counter));
        Assertions.assertEquals((int)1, (int)this.nullCount[0]);
        Assertions.assertEquals((int)0, (int)this.nullCount[1]);
        Assertions.assertEquals((int)2, (int)this.equalityCount[0]);
    }

    @Test
    public void testForEachPairArrayTooShort() {
        Assertions.assertTrue((boolean)this.createUnderTest().processBloomFilterPair(BloomFilterExtractor.fromBloomFilterArray((BloomFilter[])new BloomFilter[]{this.one}), this.counter));
        Assertions.assertEquals((int)0, (int)this.nullCount[0]);
        Assertions.assertEquals((int)1, (int)this.nullCount[1]);
        Assertions.assertEquals((int)1, (int)this.equalityCount[0]);
    }

    @Test
    public void testForEachPairCompleteMatch() {
        Assertions.assertTrue((boolean)this.createUnderTest().processBloomFilterPair(this.createUnderTest(), this.counter));
        Assertions.assertArrayEquals((int[])new int[]{0, 0}, (int[])this.nullCount);
        Assertions.assertEquals((int)2, (int)this.equalityCount[0]);
    }

    @Test
    public void testForEachPairReturnFalseEarly() {
        Assert.assertFalse((boolean)this.createUnderTest().processBloomFilterPair(BloomFilterExtractor.fromBloomFilterArray((BloomFilter[])new BloomFilter[]{this.one, this.two, this.one}), (x, y) -> false));
    }

    @Test
    public void testForEachPairReturnFalseLate() {
        Assert.assertFalse((boolean)this.createUnderTest().processBloomFilterPair(BloomFilterExtractor.fromBloomFilterArray((BloomFilter[])new BloomFilter[]{this.one, this.two, this.one}), this.counter.and((x, y) -> x != null && y != null)));
        Assertions.assertEquals((int)1, (int)this.nullCount[0]);
        Assertions.assertEquals((int)0, (int)this.nullCount[1]);
        Assertions.assertEquals((int)2, (int)this.equalityCount[0]);
    }

    @Test
    public void testForEachPairReturnFalseLateShortArray() {
        Assert.assertFalse((boolean)this.createUnderTest().processBloomFilterPair(BloomFilterExtractor.fromBloomFilterArray((BloomFilter[])new BloomFilter[]{this.one}), this.counter.and((x, y) -> x != null && y != null)));
        Assertions.assertEquals((int)0, (int)this.nullCount[0]);
        Assertions.assertEquals((int)1, (int)this.nullCount[1]);
        Assertions.assertEquals((int)1, (int)this.equalityCount[0]);
    }
}

