/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.set.AbstractSortedSetTest;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractNavigableSetTest<E>
extends AbstractSortedSetTest<E> {
    public AbstractNavigableSetTest(String name) {
        super(name);
    }

    public BulkTest bulkTestNavigableSetHeadSet() {
        int length = this.getFullElements().length;
        int loBound = length / 3;
        int hiBound = loBound * 2;
        return new TestNavigableSetSubSet(hiBound, true, true);
    }

    public BulkTest bulkTestNavigableSetSubSet() {
        int length = this.getFullElements().length;
        int loBound = length / 3;
        int hiBound = loBound * 2;
        return new TestNavigableSetSubSet(loBound, hiBound, false);
    }

    public BulkTest bulkTestNavigableSetTailSet() {
        int length = this.getFullElements().length;
        int loBound = length / 3;
        return new TestNavigableSetSubSet(loBound, false, false);
    }

    @Override
    public NavigableSet<E> getCollection() {
        return (NavigableSet)super.getCollection();
    }

    @Override
    public NavigableSet<E> getConfirmed() {
        return (NavigableSet)super.getConfirmed();
    }

    @Override
    public E[] getFullNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 1;
        }
        return elements;
    }

    @Override
    public E[] getOtherNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 2;
        }
        return elements;
    }

    @Override
    public NavigableSet<E> makeConfirmedCollection() {
        return new TreeSet();
    }

    @Override
    public NavigableSet<E> makeFullCollection() {
        return (NavigableSet)super.makeFullCollection();
    }

    @Override
    public abstract NavigableSet<E> makeObject();

    @Override
    public void verify() {
        super.verify();
        Iterator collIter = this.getCollection().descendingIterator();
        Iterator confIter = this.getConfirmed().descendingIterator();
        while (collIter.hasNext()) {
            Object element = collIter.next();
            Object confElement = confIter.next();
            Assertions.assertEquals(confElement, element, (String)"Element appears to be out of order.");
            Assertions.assertEquals(this.getConfirmed().higher(element), this.getCollection().higher(element), (String)"Incorrect element returned by higher().");
            Assertions.assertEquals(this.getConfirmed().lower(element), this.getCollection().lower(element), (String)"Incorrect element returned by lower().");
            Assertions.assertEquals(this.getConfirmed().floor(element), this.getCollection().floor(element), (String)"Incorrect element returned by floor().");
            Assertions.assertEquals(this.getConfirmed().ceiling(element), this.getCollection().ceiling(element), (String)"Incorrect element returned by ceiling().");
        }
    }

    public class TestNavigableSetSubSet
    extends AbstractNavigableSetTest<E> {
        static final int TYPE_SUBSET = 0;
        static final int TYPE_TAILSET = 1;
        static final int TYPE_HEADSET = 2;
        private final int type;
        private int lowBound;
        private int highBound;
        private final E[] fullElements;
        private final E[] otherElements;
        private final boolean inclusive;

        public TestNavigableSetSubSet(int bound, boolean head, boolean inclusive) {
            super("TestNavigableSetSubSet");
            if (head) {
                this.type = 2;
                this.inclusive = inclusive;
                this.highBound = bound;
                int realBound = inclusive ? bound + 1 : bound;
                this.fullElements = new Object[realBound];
                System.arraycopy(AbstractNavigableSetTest.this.getFullElements(), 0, this.fullElements, 0, realBound);
                this.otherElements = new Object[bound - 1];
                System.arraycopy(AbstractNavigableSetTest.this.getOtherElements(), 0, this.otherElements, 0, bound - 1);
            } else {
                this.type = 1;
                this.inclusive = inclusive;
                this.lowBound = bound;
                E[] allElements = AbstractNavigableSetTest.this.getFullElements();
                int realBound = inclusive ? bound : bound + 1;
                this.fullElements = new Object[allElements.length - realBound];
                System.arraycopy(allElements, realBound, this.fullElements, 0, allElements.length - realBound);
                this.otherElements = new Object[allElements.length - bound - 1];
                System.arraycopy(AbstractNavigableSetTest.this.getOtherElements(), bound, this.otherElements, 0, allElements.length - bound - 1);
            }
        }

        public TestNavigableSetSubSet(int loBound, int hiBound, boolean inclusive) {
            super("TestNavigableSetSubSet");
            this.type = 0;
            this.lowBound = loBound;
            this.highBound = hiBound;
            this.inclusive = inclusive;
            int fullLoBound = inclusive ? loBound : loBound + 1;
            int length = hiBound - loBound + 1 - (inclusive ? 0 : 2);
            this.fullElements = new Object[length];
            System.arraycopy(AbstractNavigableSetTest.this.getFullElements(), fullLoBound, this.fullElements, 0, length);
            int otherLength = hiBound - loBound;
            this.otherElements = new Object[otherLength - 1];
            System.arraycopy(AbstractNavigableSetTest.this.getOtherElements(), loBound, this.otherElements, 0, otherLength - 1);
        }

        @Override
        public BulkTest bulkTestNavigableSetHeadSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestNavigableSetSubSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestNavigableSetTailSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestSortedSetHeadSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestSortedSetSubSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestSortedSetTailSet() {
            return null;
        }

        @Override
        public E[] getFullElements() {
            return this.fullElements;
        }

        @Override
        public E[] getOtherElements() {
            return this.otherElements;
        }

        private NavigableSet<E> getSubSet(NavigableSet<E> set) {
            E[] elements = AbstractNavigableSetTest.this.getFullElements();
            switch (this.type) {
                case 0: {
                    return set.subSet(elements[this.lowBound], this.inclusive, elements[this.highBound], this.inclusive);
                }
                case 2: {
                    return set.headSet(elements[this.highBound], this.inclusive);
                }
                case 1: {
                    return set.tailSet(elements[this.lowBound], this.inclusive);
                }
            }
            return null;
        }

        @Override
        public boolean isAddSupported() {
            return AbstractNavigableSetTest.this.isAddSupported();
        }

        @Override
        public boolean isFailFastSupported() {
            return AbstractNavigableSetTest.this.isFailFastSupported();
        }

        @Override
        public boolean isNullSupported() {
            return AbstractNavigableSetTest.this.isNullSupported();
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractNavigableSetTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public NavigableSet<E> makeFullCollection() {
            return this.getSubSet((NavigableSet)AbstractNavigableSetTest.this.makeFullCollection());
        }

        @Override
        public NavigableSet<E> makeObject() {
            return this.getSubSet((NavigableSet)AbstractNavigableSetTest.this.makeObject());
        }
    }
}

