/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.queue;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.queue.AbstractQueueTest;
import org.apache.commons.collections4.queue.TransformedQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformedQueueTest<E>
extends AbstractQueueTest<E> {
    public TransformedQueueTest() {
        super(TransformedQueueTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public Queue<E> makeConfirmedCollection() {
        return new LinkedList();
    }

    @Override
    public Queue<E> makeConfirmedFullCollection() {
        return new LinkedList(Arrays.asList(this.getFullElements()));
    }

    @Override
    public Queue<E> makeFullCollection() {
        LinkedList list = new LinkedList(Arrays.asList(this.getFullElements()));
        return TransformedQueue.transformingQueue(list, TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Override
    public Queue<E> makeObject() {
        return TransformedQueue.transformingQueue(new LinkedList(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Test
    public void testTransformedQueue() {
        TransformedQueue queue = TransformedQueue.transformingQueue(new LinkedList(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)0, (int)queue.size());
        Object[] elements = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (int i = 0; i < elements.length; ++i) {
            queue.add(elements[i]);
            Assertions.assertEquals((int)(i + 1), (int)queue.size());
            Assertions.assertTrue((boolean)queue.contains(Integer.valueOf((String)elements[i])));
            Assertions.assertFalse((boolean)queue.contains(elements[i]));
        }
        Assertions.assertFalse((boolean)queue.remove(elements[0]));
        Assertions.assertTrue((boolean)queue.remove(Integer.valueOf((String)elements[0])));
    }

    @Test
    public void testTransformedQueue_decorateTransform() {
        LinkedList originalQueue = new LinkedList();
        Object[] elements = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        Collections.addAll(originalQueue, elements);
        TransformedQueue queue = TransformedQueue.transformedQueue(originalQueue, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)elements.length, (int)queue.size());
        for (Object el : elements) {
            Assertions.assertTrue((boolean)queue.contains(Integer.valueOf((String)el)));
            Assertions.assertFalse((boolean)queue.contains(el));
        }
        Assertions.assertFalse((boolean)queue.remove(elements[0]));
        Assertions.assertTrue((boolean)queue.remove(Integer.valueOf((String)elements[0])));
    }
}

