/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMapTest;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.collections4.multimap.UnmodifiableMultiValuedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableMultiValuedMapTest<K, V>
extends AbstractMultiValuedMapTest<K, V> {
    public UnmodifiableMultiValuedMapTest() {
        super(UnmodifiableMultiValuedMapTest.class.getSimpleName());
    }

    private void assertMapContainsAllValues(MultiValuedMap<K, V> map) {
        int maxK = this.getSampleKeySize();
        int cpk = this.getSampleCountPerKey();
        for (int k = 0; k < maxK; ++k) {
            Object key = this.makeKey(k);
            Collection collection = map.get(key);
            Assertions.assertEquals((int)cpk, (int)collection.size());
            String toString = collection.toString();
            ArrayList expected = new ArrayList(cpk);
            for (int j = 0; j < cpk; ++j) {
                expected.add(this.makeValue(k, j));
            }
            Assertions.assertEquals((int)expected.size(), (int)collection.size());
            Assertions.assertEquals(expected, new ArrayList(collection));
            Assertions.assertEquals((Object)((Object)expected).toString(), (Object)toString);
        }
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    protected MultiValuedMap<K, V> makeFullMap() {
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        this.addSampleMappings(map);
        return UnmodifiableMultiValuedMap.unmodifiableMultiValuedMap((MultiValuedMap)map);
    }

    @Override
    public MultiValuedMap<K, V> makeObject() {
        return UnmodifiableMultiValuedMap.unmodifiableMultiValuedMap((MultiValuedMap)new ArrayListValuedHashMap());
    }

    @Test
    public void testAddException() {
        MultiValuedMap map = this.makeObject();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put((Object)"one", (Object)"uno"));
    }

    @Test
    public void testClearException() {
        MultiValuedMap map = this.makeFullMap();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.clear(), (String)"expected, not support clear() method UnmodifiableMultiValuedMap does not support change");
        this.assertMapContainsAllValues(map);
    }

    @Test
    public void testDecorateFactory() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        Assertions.assertSame(map, (Object)UnmodifiableMultiValuedMap.unmodifiableMultiValuedMap(map));
    }

    @Test
    public void testDecoratorFactoryNullMap() {
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableMultiValuedMap.unmodifiableMultiValuedMap(null), (String)"map must not be null");
    }

    @Test
    public void testPutAllException() {
        MultiValuedMap map = this.makeObject();
        ArrayListValuedHashMap original = new ArrayListValuedHashMap();
        HashMap<String, String> originalMap = new HashMap<String, String>();
        List<String> coll = Arrays.asList("X", "Y", "Z");
        original.put((Object)"key", (Object)"object1");
        original.put((Object)"key", (Object)"object2");
        originalMap.put("keyX", "object1");
        originalMap.put("keyY", "object2");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> UnmodifiableMultiValuedMapTest.lambda$testPutAllException$3(map, (MultiValuedMap)original), (String)"expected, not support putAll() method UnmodifiableMultiValuedMap does not support change");
        Assertions.assertEquals((Object)"{}", (Object)map.toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.putAll(originalMap));
        Assertions.assertEquals((Object)"{}", (Object)map.toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.putAll((Object)"A", (Iterable)coll));
        Assertions.assertEquals((Object)"{}", (Object)map.toString());
    }

    @Test
    public void testRemoveException() {
        MultiValuedMap map = this.makeFullMap();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.remove((Object)"one"), (String)"not support remove() method UnmodifiableMultiValuedMap does not support change");
        this.assertMapContainsAllValues(map);
    }

    @Test
    public void testRemoveMappingException() {
        MultiValuedMap map = this.makeFullMap();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> map.removeMapping((Object)"one", (Object)"uno"), (String)"expected, not support removeMapping() method UnmodifiableMultiValuedMap does not support change");
        this.assertMapContainsAllValues(map);
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullMap() instanceof Unmodifiable));
    }

    @Test
    public void testUnmodifiableAsMap() {
        this.resetFull();
        Map mapCol = this.getMap().asMap();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> mapCol.put("four", Arrays.asList("four")));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> mapCol.remove("four"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> mapCol.clear());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> mapCol.clear());
    }

    @Test
    public void testUnmodifiableEntries() {
        this.resetFull();
        Collection entries = this.getMap().entries();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> entries.clear());
        Iterator it = entries.iterator();
        Map.Entry entry = (Map.Entry)it.next();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> it.remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> entry.setValue("three"));
    }

    @Test
    public void testUnmodifiableKeys() {
        this.resetFull();
        MultiSet keys = this.getMap().keys();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> keys.add((Object)"four"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> keys.remove((Object)"four"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> keys.clear());
        Iterator it = keys.iterator();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> it.remove());
    }

    @Test
    public void testUnmodifiableKeySet() {
        this.resetFull();
        Set keySet = this.getMap().keySet();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> keySet.add("four"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> keySet.remove("four"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> keySet.clear());
        Iterator it = keySet.iterator();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> it.remove());
    }

    @Test
    public void testUnmodifiableMapIterator() {
        this.resetFull();
        MapIterator mapIt = this.getMap().mapIterator();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> mapIt.remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> mapIt.setValue((Object)"three"));
    }

    @Test
    public void testUnmodifiableValues() {
        this.resetFull();
        Collection values = this.getMap().values();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> values.add("four"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> values.remove("four"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> values.clear());
        Iterator it = values.iterator();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> it.remove());
    }

    private static /* synthetic */ void lambda$testPutAllException$3(MultiValuedMap map, MultiValuedMap original) throws Throwable {
        map.putAll(original);
    }
}

