/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.AbstractObjectTest;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.map.MultiValueMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
public class MultiValueMapTest<K, V>
extends AbstractObjectTest {
    public MultiValueMapTest() {
        super(MultiValueMapTest.class.getSimpleName());
    }

    private MultiValueMap<K, V> createTestMap() {
        return this.createTestMap(ArrayList.class);
    }

    private <C extends Collection<V>> MultiValueMap<K, V> createTestMap(Class<C> collectionClass) {
        MultiValueMap map = MultiValueMap.multiValueMap(new HashMap(), collectionClass);
        map.put((Object)"one", (Object)"uno");
        map.put((Object)"one", (Object)"un");
        map.put((Object)"two", (Object)"dos");
        map.put((Object)"two", (Object)"deux");
        map.put((Object)"three", (Object)"tres");
        map.put((Object)"three", (Object)"trois");
        return map;
    }

    private Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream iis = new ObjectInputStream(bais);
        return iis.readObject();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    private Map makeEmptyMap() {
        return new MultiValueMap();
    }

    @Override
    public Object makeObject() {
        Map m = this.makeEmptyMap();
        m.put("a", "1");
        m.put("a", "1b");
        m.put("b", "2");
        m.put("c", "3");
        m.put("c", "3b");
        m.put("d", "4");
        return m;
    }

    private byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        return baos.toByteArray();
    }

    @Test
    public void testContainsValue() {
        MultiValueMap<K, V> map = this.createTestMap(HashSet.class);
        Assertions.assertTrue((boolean)map.containsValue((Object)"uno"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"un"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"dos"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"deux"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"tres"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"trois"));
        Assertions.assertFalse((boolean)map.containsValue((Object)"quatro"));
    }

    @Test
    public void testContainsValue_Key() {
        MultiValueMap map = new MultiValueMap();
        Assertions.assertFalse((boolean)map.containsValue((Object)"A", (Object)"AA"));
        Assertions.assertFalse((boolean)map.containsValue((Object)"B", (Object)"BB"));
        map.put((Object)"A", (Object)"AA");
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"AA"));
        Assertions.assertFalse((boolean)map.containsValue((Object)"A", (Object)"AB"));
    }

    @Test
    public void testEmptyMapCompatibility() throws Exception {
        Map map = this.makeEmptyMap();
        Map map2 = (Map)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(map));
        Assertions.assertEquals((int)0, (int)map2.size(), (String)"Map is empty");
    }

    @Test
    public void testFullMapCompatibility() throws Exception {
        Map map = (Map)this.makeObject();
        Map map2 = (Map)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(map));
        Assertions.assertEquals((int)map.size(), (int)map2.size(), (String)"Map is the right size");
        for (Object key : map.keySet()) {
            Assertions.assertEquals(map.get(key), map2.get(key), (String)"Map had unequal elements");
            map2.remove(key);
        }
        Assertions.assertEquals((int)0, (int)map2.size(), (String)"Map had extra values");
    }

    @Test
    public void testGetCollection() {
        MultiValueMap map = new MultiValueMap();
        map.put((Object)"A", (Object)"AA");
        Assertions.assertSame((Object)map.get((Object)"A"), (Object)map.getCollection((Object)"A"));
    }

    @Test
    public void testIterator() {
        MultiValueMap<K, V> map = this.createTestMap();
        ArrayList values = new ArrayList(map.values());
        for (Map.Entry entry : map) {
            Assertions.assertTrue((boolean)map.containsValue(entry.getKey(), entry.getValue()));
            Assertions.assertTrue((boolean)values.contains(entry.getValue()));
            Assertions.assertTrue((boolean)values.remove(entry.getValue()));
        }
        Assertions.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void testIterator_Key() {
        MultiValueMap map = new MultiValueMap();
        Assertions.assertFalse((boolean)map.iterator((Object)"A").hasNext());
        map.put((Object)"A", (Object)"AA");
        Iterator it = map.iterator((Object)"A");
        Assertions.assertTrue((boolean)it.hasNext());
        it.next();
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testKeyContainsValue() {
        MultiValueMap<K, V> map = this.createTestMap(HashSet.class);
        Assertions.assertTrue((boolean)map.containsValue((Object)"one", (Object)"uno"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"one", (Object)"un"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"two", (Object)"dos"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"two", (Object)"deux"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"three", (Object)"tres"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"three", (Object)"trois"));
        Assertions.assertFalse((boolean)map.containsValue((Object)"four", (Object)"quatro"));
    }

    @Test
    public void testKeyedIterator() {
        MultiValueMap<K, V> map = this.createTestMap();
        ArrayList actual = new ArrayList(IteratorUtils.toList((Iterator)map.iterator((Object)"one")));
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList("uno", "un"));
        Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testMapEquals() {
        MultiValueMap one = new MultiValueMap();
        Integer value = 1;
        one.put((Object)"One", (Object)value);
        one.removeMapping((Object)"One", (Object)value);
        MultiValueMap two = new MultiValueMap();
        Assertions.assertEquals((Object)two, (Object)one);
    }

    @Test
    public void testMultipleValues() {
        MultiValueMap<K, V> map = this.createTestMap(HashSet.class);
        HashSet<String> expected = new HashSet<String>();
        expected.add("uno");
        expected.add("un");
        Assertions.assertEquals(expected, (Object)map.get((Object)"one"));
    }

    @Test
    public void testNoMappingReturnsNull() {
        MultiValueMap<K, V> map = this.createTestMap();
        Assertions.assertNull((Object)map.get((Object)"whatever"));
    }

    @Test
    public void testPutAll_KeyCollection() {
        MultiValueMap map = new MultiValueMap();
        List<String> coll = Arrays.asList("X", "Y", "Z");
        Assertions.assertTrue((boolean)map.putAll((Object)"A", coll));
        Assertions.assertEquals((int)3, (int)map.size((Object)"A"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"X"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"Y"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"Z"));
        Assertions.assertFalse((boolean)map.putAll((Object)"A", null));
        Assertions.assertEquals((int)3, (int)map.size((Object)"A"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"X"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"Y"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"Z"));
        Assertions.assertFalse((boolean)map.putAll((Object)"A", new ArrayList()));
        Assertions.assertEquals((int)3, (int)map.size((Object)"A"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"X"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"Y"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"Z"));
        coll = Arrays.asList("M");
        Assertions.assertTrue((boolean)map.putAll((Object)"A", coll));
        Assertions.assertEquals((int)4, (int)map.size((Object)"A"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"X"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"Y"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"Z"));
        Assertions.assertTrue((boolean)map.containsValue((Object)"A", (Object)"M"));
    }

    @Test
    public void testPutAll_Map1() {
        MultiValueMap original = new MultiValueMap();
        original.put((Object)"key", (Object)"object1");
        original.put((Object)"key", (Object)"object2");
        MultiValueMap test = new MultiValueMap();
        test.put((Object)"keyA", (Object)"objectA");
        test.put((Object)"key", (Object)"object0");
        test.putAll((Map)original);
        Assertions.assertEquals((int)2, (int)test.size());
        Assertions.assertEquals((int)4, (int)test.totalSize());
        Assertions.assertEquals((int)1, (int)test.getCollection((Object)"keyA").size());
        Assertions.assertEquals((int)3, (int)test.getCollection((Object)"key").size());
        Assertions.assertTrue((boolean)test.containsValue((Object)"objectA"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object0"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object1"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object2"));
    }

    @Test
    public void testPutAll_Map2() {
        HashMap<String, String> original = new HashMap<String, String>();
        original.put("keyX", "object1");
        original.put("keyY", "object2");
        MultiValueMap test = new MultiValueMap();
        test.put((Object)"keyA", (Object)"objectA");
        test.put((Object)"keyX", (Object)"object0");
        test.putAll(original);
        Assertions.assertEquals((int)3, (int)test.size());
        Assertions.assertEquals((int)4, (int)test.totalSize());
        Assertions.assertEquals((int)1, (int)test.getCollection((Object)"keyA").size());
        Assertions.assertEquals((int)2, (int)test.getCollection((Object)"keyX").size());
        Assertions.assertEquals((int)1, (int)test.getCollection((Object)"keyY").size());
        Assertions.assertTrue((boolean)test.containsValue((Object)"objectA"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object0"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object1"));
        Assertions.assertTrue((boolean)test.containsValue((Object)"object2"));
    }

    @Test
    public void testPutWithList() {
        MultiValueMap test = MultiValueMap.multiValueMap(new HashMap(), ArrayList.class);
        Assertions.assertEquals((Object)"a", (Object)test.put((Object)"A", (Object)"a"));
        Assertions.assertEquals((Object)"b", (Object)test.put((Object)"A", (Object)"b"));
        Assertions.assertEquals((int)1, (int)test.size());
        Assertions.assertEquals((int)2, (int)test.size((Object)"A"));
        Assertions.assertEquals((int)2, (int)test.totalSize());
    }

    @Test
    public void testPutWithSet() {
        MultiValueMap test = MultiValueMap.multiValueMap(new HashMap(), HashSet.class);
        Assertions.assertEquals((Object)"a", (Object)test.put((Object)"A", (Object)"a"));
        Assertions.assertEquals((Object)"b", (Object)test.put((Object)"A", (Object)"b"));
        Assertions.assertNull((Object)test.put((Object)"A", (Object)"a"));
        Assertions.assertEquals((int)1, (int)test.size());
        Assertions.assertEquals((int)2, (int)test.size((Object)"A"));
        Assertions.assertEquals((int)2, (int)test.totalSize());
    }

    @Test
    public void testRemove_KeyItem() {
        MultiValueMap map = new MultiValueMap();
        map.put((Object)"A", (Object)"AA");
        map.put((Object)"A", (Object)"AB");
        map.put((Object)"A", (Object)"AC");
        Assertions.assertFalse((boolean)map.removeMapping((Object)"C", (Object)"CA"));
        Assertions.assertFalse((boolean)map.removeMapping((Object)"A", (Object)"AD"));
        Assertions.assertTrue((boolean)map.removeMapping((Object)"A", (Object)"AC"));
        Assertions.assertTrue((boolean)map.removeMapping((Object)"A", (Object)"AB"));
        Assertions.assertTrue((boolean)map.removeMapping((Object)"A", (Object)"AA"));
        Assertions.assertEquals((Object)new MultiValueMap(), (Object)map);
    }

    @Test
    public void testRemoveAllViaEntryIterator() {
        MultiValueMap<K, V> map = this.createTestMap();
        Iterator i = map.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        Assertions.assertNull((Object)map.get((Object)"one"));
        Assertions.assertEquals((int)0, (int)map.totalSize());
    }

    @Test
    public void testRemoveAllViaIterator() {
        MultiValueMap<K, V> map = this.createTestMap();
        Iterator i = map.values().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        Assertions.assertNull((Object)map.get((Object)"one"));
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testRemoveAllViaKeyedIterator() {
        MultiValueMap<K, V> map = this.createTestMap();
        Iterator i = map.iterator((Object)"one");
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        Assertions.assertNull((Object)map.get((Object)"one"));
        Assertions.assertEquals((int)4, (int)map.totalSize());
    }

    @Test
    public void testSize() {
        MultiValueMap map = new MultiValueMap();
        Assertions.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)"AA");
        Assertions.assertEquals((int)1, (int)map.size());
        map.put((Object)"B", (Object)"BA");
        Assertions.assertEquals((int)2, (int)map.size());
        map.put((Object)"B", (Object)"BB");
        Assertions.assertEquals((int)2, (int)map.size());
        map.put((Object)"B", (Object)"BC");
        Assertions.assertEquals((int)2, (int)map.size());
        map.remove((Object)"A");
        Assertions.assertEquals((int)1, (int)map.size());
        map.removeMapping((Object)"B", (Object)"BC");
        Assertions.assertEquals((int)1, (int)map.size());
    }

    @Test
    public void testSize_Key() {
        MultiValueMap map = new MultiValueMap();
        Assertions.assertEquals((int)0, (int)map.size((Object)"A"));
        Assertions.assertEquals((int)0, (int)map.size((Object)"B"));
        map.put((Object)"A", (Object)"AA");
        Assertions.assertEquals((int)1, (int)map.size((Object)"A"));
        Assertions.assertEquals((int)0, (int)map.size((Object)"B"));
        map.put((Object)"B", (Object)"BA");
        Assertions.assertEquals((int)1, (int)map.size((Object)"A"));
        Assertions.assertEquals((int)1, (int)map.size((Object)"B"));
        map.put((Object)"B", (Object)"BB");
        Assertions.assertEquals((int)1, (int)map.size((Object)"A"));
        Assertions.assertEquals((int)2, (int)map.size((Object)"B"));
        map.put((Object)"B", (Object)"BC");
        Assertions.assertEquals((int)1, (int)map.size((Object)"A"));
        Assertions.assertEquals((int)3, (int)map.size((Object)"B"));
        map.remove((Object)"A");
        Assertions.assertEquals((int)0, (int)map.size((Object)"A"));
        Assertions.assertEquals((int)3, (int)map.size((Object)"B"));
        map.removeMapping((Object)"B", (Object)"BC");
        Assertions.assertEquals((int)0, (int)map.size((Object)"A"));
        Assertions.assertEquals((int)2, (int)map.size((Object)"B"));
    }

    @Test
    public void testTotalSize() {
        MultiValueMap map = new MultiValueMap();
        Assertions.assertEquals((int)0, (int)map.totalSize());
        map.put((Object)"A", (Object)"AA");
        Assertions.assertEquals((int)1, (int)map.totalSize());
        map.put((Object)"B", (Object)"BA");
        Assertions.assertEquals((int)2, (int)map.totalSize());
        map.put((Object)"B", (Object)"BB");
        Assertions.assertEquals((int)3, (int)map.totalSize());
        map.put((Object)"B", (Object)"BC");
        Assertions.assertEquals((int)4, (int)map.totalSize());
        map.remove((Object)"A");
        Assertions.assertEquals((int)3, (int)map.totalSize());
        map.removeMapping((Object)"B", (Object)"BC");
        Assertions.assertEquals((int)2, (int)map.totalSize());
    }

    @Test
    public void testTotalSizeA() {
        Assertions.assertEquals((int)6, (int)this.createTestMap().totalSize());
    }

    @Test
    public void testUnsafeDeSerialization() throws Exception {
        MultiValueMap map1 = MultiValueMap.multiValueMap(new HashMap(), ArrayList.class);
        byte[] bytes = this.serialize(map1);
        Object result = this.deserialize(bytes);
        Assertions.assertEquals((Object)map1, (Object)result);
        MultiValueMap map2 = MultiValueMap.multiValueMap(new HashMap(), String.class);
        byte[] finalBytes = bytes = this.serialize(map2);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.deserialize(finalBytes));
    }

    @Test
    public void testValueCollectionType() {
        MultiValueMap<K, V> map = this.createTestMap(LinkedList.class);
        Assertions.assertTrue((boolean)(map.get((Object)"one") instanceof LinkedList));
    }

    @Test
    public void testValues() {
        MultiValueMap<K, V> map = this.createTestMap(HashSet.class);
        HashSet<String> expected = new HashSet<String>();
        expected.add("uno");
        expected.add("dos");
        expected.add("tres");
        expected.add("un");
        expected.add("deux");
        expected.add("trois");
        Collection c = map.values();
        Assertions.assertEquals((int)6, (int)c.size());
        Assertions.assertEquals(expected, new HashSet(c));
    }
}

