/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.ResettableIterator;
import org.apache.commons.collections4.map.AbstractLinkedMap;
import org.apache.commons.collections4.map.AbstractOrderedMapTest;
import org.apache.commons.collections4.map.LRUMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class LRUMapTest<K, V>
extends AbstractOrderedMapTest<K, V> {
    public LRUMapTest() {
        super(LRUMapTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public LRUMap<K, V> getMap() {
        return (LRUMap)super.getMap();
    }

    @Override
    public boolean isGetStructuralModify() {
        return true;
    }

    @Override
    public LRUMap<K, V> makeFullMap() {
        return (LRUMap)super.makeFullMap();
    }

    @Override
    public LRUMap<K, V> makeObject() {
        return new LRUMap();
    }

    @Test
    public void testAccessOrder() {
        if (!this.isPutAddSupported() || !this.isPutChangeSupported()) {
            return;
        }
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        this.resetEmpty();
        this.map.put(keys[0], values[0]);
        this.map.put(keys[1], values[1]);
        Iterator kit = this.map.keySet().iterator();
        Assertions.assertSame(keys[0], kit.next());
        Assertions.assertSame(keys[1], kit.next());
        Iterator vit = this.map.values().iterator();
        Assertions.assertSame(values[0], vit.next());
        Assertions.assertSame(values[1], vit.next());
        this.map.put(keys[1], values[1]);
        kit = this.map.keySet().iterator();
        Assertions.assertSame(keys[0], kit.next());
        Assertions.assertSame(keys[1], kit.next());
        vit = this.map.values().iterator();
        Assertions.assertSame(values[0], vit.next());
        Assertions.assertSame(values[1], vit.next());
        this.map.put(keys[1], values[2]);
        kit = this.map.keySet().iterator();
        Assertions.assertSame(keys[0], kit.next());
        Assertions.assertSame(keys[1], kit.next());
        vit = this.map.values().iterator();
        Assertions.assertSame(values[0], vit.next());
        Assertions.assertSame(values[2], vit.next());
        this.map.put(keys[0], values[3]);
        kit = this.map.keySet().iterator();
        Assertions.assertSame(keys[1], kit.next());
        Assertions.assertSame(keys[0], kit.next());
        vit = this.map.values().iterator();
        Assertions.assertSame(values[2], vit.next());
        Assertions.assertSame(values[3], vit.next());
        this.map.get(keys[1]);
        kit = this.map.keySet().iterator();
        Assertions.assertSame(keys[0], kit.next());
        Assertions.assertSame(keys[1], kit.next());
        vit = this.map.values().iterator();
        Assertions.assertSame(values[3], vit.next());
        Assertions.assertSame(values[2], vit.next());
        this.map.get(keys[0]);
        kit = this.map.keySet().iterator();
        Assertions.assertSame(keys[1], kit.next());
        Assertions.assertSame(keys[0], kit.next());
        vit = this.map.values().iterator();
        Assertions.assertSame(values[2], vit.next());
        Assertions.assertSame(values[3], vit.next());
        this.map.get(keys[0]);
        kit = this.map.keySet().iterator();
        Assertions.assertSame(keys[1], kit.next());
        Assertions.assertSame(keys[0], kit.next());
        vit = this.map.values().iterator();
        Assertions.assertSame(values[2], vit.next());
        Assertions.assertSame(values[3], vit.next());
    }

    @Test
    public void testAccessOrder2() {
        if (!this.isPutAddSupported() || !this.isPutChangeSupported()) {
            return;
        }
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        this.resetEmpty();
        LRUMap lruMap = (LRUMap)this.map;
        lruMap.put(keys[0], values[0]);
        lruMap.put(keys[1], values[1]);
        Iterator kit = lruMap.keySet().iterator();
        Assertions.assertSame(keys[0], kit.next());
        Assertions.assertSame(keys[1], kit.next());
        Iterator vit = lruMap.values().iterator();
        Assertions.assertSame(values[0], vit.next());
        Assertions.assertSame(values[1], vit.next());
        lruMap.put(keys[1], values[1]);
        kit = lruMap.keySet().iterator();
        Assertions.assertSame(keys[0], kit.next());
        Assertions.assertSame(keys[1], kit.next());
        vit = lruMap.values().iterator();
        Assertions.assertSame(values[0], vit.next());
        Assertions.assertSame(values[1], vit.next());
        lruMap.get(keys[1], false);
        kit = lruMap.keySet().iterator();
        Assertions.assertSame(keys[0], kit.next());
        Assertions.assertSame(keys[1], kit.next());
        vit = lruMap.values().iterator();
        Assertions.assertSame(values[0], vit.next());
        Assertions.assertSame(values[1], vit.next());
        lruMap.get(keys[0], true);
        kit = lruMap.keySet().iterator();
        Assertions.assertSame(keys[1], kit.next());
        Assertions.assertSame(keys[0], kit.next());
        vit = lruMap.values().iterator();
        Assertions.assertSame(values[1], vit.next());
        Assertions.assertSame(values[0], vit.next());
    }

    @Test
    public void testClone() {
        LRUMap map = new LRUMap(10);
        map.put((Object)"1", (Object)"1");
        LRUMap cloned = map.clone();
        Assertions.assertEquals((int)map.size(), (int)cloned.size());
        Assertions.assertSame((Object)map.get((Object)"1"), cloned.get("1"));
    }

    @Test
    public void testCtors() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IllegalArgumentException.class, () -> new LRUMap(0), (String)"maxSize must be positive"), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> new LRUMap(-1, 12, 0.75f, false), (String)"maxSize must be positive"), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> new LRUMap(10, -1), (String)"initialSize must not be negative"), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> new LRUMap(10, 12), (String)"initialSize must not be larger than maxSize"), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> new LRUMap(10, -1, 0.75f, false), (String)"initialSize must not be negative"), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> new LRUMap(10, 12, 0.75f, false), (String)"initialSize must not be larger than maxSize")});
    }

    @Test
    public void testInternalState_Buckets() {
        if (!this.isPutAddSupported() || !this.isPutChangeSupported()) {
            return;
        }
        SingleHashCode one = new SingleHashCode("1");
        SingleHashCode two = new SingleHashCode("2");
        SingleHashCode three = new SingleHashCode("3");
        SingleHashCode four = new SingleHashCode("4");
        SingleHashCode five = new SingleHashCode("5");
        SingleHashCode six = new SingleHashCode("6");
        LRUMap map = new LRUMap(3, 1.0f);
        int hashIndex = map.hashIndex(map.hash((Object)one), 4);
        map.put((Object)one, (Object)"A");
        map.put((Object)two, (Object)"B");
        map.put((Object)three, (Object)"C");
        Assertions.assertEquals((int)4, (int)map.data.length);
        Assertions.assertEquals((int)3, (int)map.size);
        Assertions.assertNull((Object)map.header.next);
        Assertions.assertEquals((Object)one, (Object)map.header.after.key);
        Assertions.assertEquals((Object)two, (Object)map.header.after.after.key);
        Assertions.assertEquals((Object)three, (Object)map.header.after.after.after.key);
        Assertions.assertEquals((Object)three, (Object)map.data[hashIndex].key);
        Assertions.assertEquals((Object)two, (Object)map.data[hashIndex].next.key);
        Assertions.assertEquals((Object)one, (Object)map.data[hashIndex].next.next.key);
        map.put((Object)four, (Object)"D");
        Assertions.assertEquals((int)4, (int)map.data.length);
        Assertions.assertEquals((int)3, (int)map.size);
        Assertions.assertNull((Object)map.header.next);
        Assertions.assertEquals((Object)two, (Object)map.header.after.key);
        Assertions.assertEquals((Object)three, (Object)map.header.after.after.key);
        Assertions.assertEquals((Object)four, (Object)map.header.after.after.after.key);
        Assertions.assertEquals((Object)four, (Object)map.data[hashIndex].key);
        Assertions.assertEquals((Object)three, (Object)map.data[hashIndex].next.key);
        Assertions.assertEquals((Object)two, (Object)map.data[hashIndex].next.next.key);
        map.get((Object)three);
        Assertions.assertEquals((int)4, (int)map.data.length);
        Assertions.assertEquals((int)3, (int)map.size);
        Assertions.assertNull((Object)map.header.next);
        Assertions.assertEquals((Object)two, (Object)map.header.after.key);
        Assertions.assertEquals((Object)four, (Object)map.header.after.after.key);
        Assertions.assertEquals((Object)three, (Object)map.header.after.after.after.key);
        Assertions.assertEquals((Object)four, (Object)map.data[hashIndex].key);
        Assertions.assertEquals((Object)three, (Object)map.data[hashIndex].next.key);
        Assertions.assertEquals((Object)two, (Object)map.data[hashIndex].next.next.key);
        map.put((Object)five, (Object)"E");
        Assertions.assertEquals((int)4, (int)map.data.length);
        Assertions.assertEquals((int)3, (int)map.size);
        Assertions.assertNull((Object)map.header.next);
        Assertions.assertEquals((Object)four, (Object)map.header.after.key);
        Assertions.assertEquals((Object)three, (Object)map.header.after.after.key);
        Assertions.assertEquals((Object)five, (Object)map.header.after.after.after.key);
        Assertions.assertEquals((Object)five, (Object)map.data[hashIndex].key);
        Assertions.assertEquals((Object)four, (Object)map.data[hashIndex].next.key);
        Assertions.assertEquals((Object)three, (Object)map.data[hashIndex].next.next.key);
        map.get((Object)three);
        map.get((Object)five);
        Assertions.assertEquals((int)4, (int)map.data.length);
        Assertions.assertEquals((int)3, (int)map.size);
        Assertions.assertNull((Object)map.header.next);
        Assertions.assertEquals((Object)four, (Object)map.header.after.key);
        Assertions.assertEquals((Object)three, (Object)map.header.after.after.key);
        Assertions.assertEquals((Object)five, (Object)map.header.after.after.after.key);
        Assertions.assertEquals((Object)five, (Object)map.data[hashIndex].key);
        Assertions.assertEquals((Object)four, (Object)map.data[hashIndex].next.key);
        Assertions.assertEquals((Object)three, (Object)map.data[hashIndex].next.next.key);
        map.put((Object)six, (Object)"F");
        Assertions.assertEquals((int)4, (int)map.data.length);
        Assertions.assertEquals((int)3, (int)map.size);
        Assertions.assertNull((Object)map.header.next);
        Assertions.assertEquals((Object)three, (Object)map.header.after.key);
        Assertions.assertEquals((Object)five, (Object)map.header.after.after.key);
        Assertions.assertEquals((Object)six, (Object)map.header.after.after.after.key);
        Assertions.assertEquals((Object)six, (Object)map.data[hashIndex].key);
        Assertions.assertEquals((Object)five, (Object)map.data[hashIndex].next.key);
        Assertions.assertEquals((Object)three, (Object)map.data[hashIndex].next.next.key);
    }

    @Test
    public void testInternalState_getEntry_int() {
        if (!this.isPutAddSupported() || !this.isPutChangeSupported()) {
            return;
        }
        SingleHashCode one = new SingleHashCode("1");
        SingleHashCode two = new SingleHashCode("2");
        SingleHashCode three = new SingleHashCode("3");
        LRUMap map = new LRUMap(3, 1.0f);
        map.put((Object)one, (Object)"A");
        map.put((Object)two, (Object)"B");
        map.put((Object)three, (Object)"C");
        Assertions.assertEquals((Object)one, (Object)map.getEntry((int)0).key);
        Assertions.assertEquals((Object)two, (Object)map.getEntry((int)1).key);
        Assertions.assertEquals((Object)three, (Object)map.getEntry((int)2).key);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> map.getEntry(-1)), () -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> map.getEntry(3))});
    }

    @Test
    public void testLRU() {
        if (!this.isPutAddSupported() || !this.isPutChangeSupported()) {
            return;
        }
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        LRUMap map = new LRUMap(2);
        Assertions.assertEquals((int)0, (int)map.size());
        Assertions.assertFalse((boolean)map.isFull());
        Assertions.assertEquals((int)2, (int)map.maxSize());
        map.put(keys[0], values[0]);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertFalse((boolean)map.isFull());
        Assertions.assertEquals((int)2, (int)map.maxSize());
        map.put(keys[1], values[1]);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)map.isFull());
        Assertions.assertEquals((int)2, (int)map.maxSize());
        Iterator kit = map.keySet().iterator();
        Assertions.assertSame(keys[0], kit.next());
        Assertions.assertSame(keys[1], kit.next());
        Iterator vit = map.values().iterator();
        Assertions.assertSame(values[0], vit.next());
        Assertions.assertSame(values[1], vit.next());
        map.put(keys[2], values[2]);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)map.isFull());
        Assertions.assertEquals((int)2, (int)map.maxSize());
        kit = map.keySet().iterator();
        Assertions.assertSame(keys[1], kit.next());
        Assertions.assertSame(keys[2], kit.next());
        vit = map.values().iterator();
        Assertions.assertSame(values[1], vit.next());
        Assertions.assertSame(values[2], vit.next());
        map.put(keys[2], values[0]);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)map.isFull());
        Assertions.assertEquals((int)2, (int)map.maxSize());
        kit = map.keySet().iterator();
        Assertions.assertSame(keys[1], kit.next());
        Assertions.assertSame(keys[2], kit.next());
        vit = map.values().iterator();
        Assertions.assertSame(values[1], vit.next());
        Assertions.assertSame(values[0], vit.next());
        map.put(keys[1], values[3]);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)map.isFull());
        Assertions.assertEquals((int)2, (int)map.maxSize());
        kit = map.keySet().iterator();
        Assertions.assertSame(keys[2], kit.next());
        Assertions.assertSame(keys[1], kit.next());
        vit = map.values().iterator();
        Assertions.assertSame(values[0], vit.next());
        Assertions.assertSame(values[3], vit.next());
    }

    @Test
    public void testRemoveLRU() {
        MockLRUMapSubclass map = new MockLRUMapSubclass(2);
        Assertions.assertNull(map.entry);
        map.put("A", "a");
        Assertions.assertNull(map.entry);
        map.put("B", "b");
        Assertions.assertNull(map.entry);
        map.put("C", "c");
        Assertions.assertNotNull(map.entry);
        Assertions.assertEquals((Object)"A", map.key);
        Assertions.assertEquals((Object)"a", map.value);
        Assertions.assertEquals((Object)"C", (Object)map.entry.getKey());
        Assertions.assertEquals((Object)"c", (Object)map.entry.getValue());
        Assertions.assertFalse((boolean)map.containsKey("A"));
        Assertions.assertTrue((boolean)map.containsKey("B"));
        Assertions.assertTrue((boolean)map.containsKey("C"));
    }

    @Test
    public void testRemoveLRUBlocksRemove() {
        MockLRUMapSubclassBlocksRemove map = new MockLRUMapSubclassBlocksRemove(2, false);
        Assertions.assertEquals((int)0, (int)map.size());
        map.put("A", "a");
        Assertions.assertEquals((int)1, (int)map.size());
        map.put("B", "b");
        Assertions.assertEquals((int)2, (int)map.size());
        map.put("C", "c");
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((int)2, (int)map.maxSize());
        Assertions.assertTrue((boolean)map.containsKey("A"));
        Assertions.assertTrue((boolean)map.containsKey("B"));
        Assertions.assertTrue((boolean)map.containsKey("C"));
    }

    @Test
    public void testRemoveLRUBlocksRemoveScan() {
        MockLRUMapSubclassBlocksRemove map = new MockLRUMapSubclassBlocksRemove(2, true);
        Assertions.assertEquals((int)0, (int)map.size());
        map.put("A", "a");
        Assertions.assertEquals((int)1, (int)map.size());
        map.put("B", "b");
        Assertions.assertEquals((int)2, (int)map.size());
        map.put("C", "c");
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((int)2, (int)map.maxSize());
        Assertions.assertTrue((boolean)map.containsKey("A"));
        Assertions.assertTrue((boolean)map.containsKey("B"));
        Assertions.assertTrue((boolean)map.containsKey("C"));
    }

    @Test
    public void testRemoveLRUFirstBlocksRemove() {
        MockLRUMapSubclassFirstBlocksRemove map = new MockLRUMapSubclassFirstBlocksRemove(2);
        Assertions.assertEquals((int)0, (int)map.size());
        map.put("A", "a");
        Assertions.assertEquals((int)1, (int)map.size());
        map.put("B", "b");
        Assertions.assertEquals((int)2, (int)map.size());
        map.put("C", "c");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((int)2, (int)map.maxSize());
        Assertions.assertTrue((boolean)map.containsKey("A"));
        Assertions.assertFalse((boolean)map.containsKey("B"));
        Assertions.assertTrue((boolean)map.containsKey("C"));
    }

    @Test
    public void testReset() {
        this.resetEmpty();
        LRUMap<K, V> ordered = this.getMap();
        ((ResettableIterator)ordered.mapIterator()).reset();
        this.resetFull();
        ordered = this.getMap();
        ArrayList list = new ArrayList(ordered.keySet());
        ResettableIterator it = (ResettableIterator)ordered.mapIterator();
        Assertions.assertSame(list.get(0), (Object)it.next());
        Assertions.assertSame(list.get(1), (Object)it.next());
        it.reset();
        Assertions.assertSame(list.get(0), (Object)it.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronizedRemoveFromEntrySet() throws InterruptedException {
        Thread thread;
        Thread thread22;
        int n;
        LRUMap map = new LRUMap(10000);
        final HashMap exceptions = new HashMap();
        ThreadGroup tg = new ThreadGroup(this.getName()){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                exceptions.put(e, t.getName());
                super.uncaughtException(t, e);
            }
        };
        int[] counter = new int[]{0};
        Thread[] threads = new Thread[50];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(tg, "JUnit Thread " + i, (Map)map, counter){
                final /* synthetic */ Map val$map;
                final /* synthetic */ int[] val$counter;
                {
                    this.val$map = map;
                    this.val$counter = nArray;
                    super(arg0, arg1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Object object;
                    int i = 0;
                    try {
                        Map map;
                        object = this;
                        synchronized (object) {
                            this.notifyAll();
                            this.wait();
                        }
                        Thread thread = Thread.currentThread();
                        while (i < 1000 && !2.interrupted()) {
                            map = this.val$map;
                            synchronized (map) {
                                this.val$map.put(thread.getName() + "[" + ++i + "]", thread);
                            }
                        }
                        map = this.val$map;
                        synchronized (map) {
                            this.val$map.entrySet().removeIf(entry -> entry.getValue() == this);
                        }
                    }
                    catch (InterruptedException e) {
                        Assertions.fail((String)"Unexpected InterruptedException");
                    }
                    if (i <= 0) return;
                    object = this.val$counter;
                    synchronized (this.val$counter) {
                        this.val$counter[0] = this.val$counter[0] + 1;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            };
        }
        Thread[] threadArray = threads;
        int n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.start();
                thread22.wait();
                continue;
            }
        }
        threadArray = threads;
        n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.notifyAll();
                continue;
            }
        }
        Thread.sleep(1000L);
        for (Thread thread22 : threads) {
            thread22.interrupt();
        }
        threadArray = threads;
        n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.join();
                continue;
            }
        }
        Assertions.assertEquals((int)0, (int)exceptions.size(), (String)("Exceptions have been thrown: " + exceptions));
        Assertions.assertTrue((counter[0] >= threads.length ? 1 : 0) != 0, (String)("Each thread should have put at least 1 element into the map, but only " + counter[0] + " did succeed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronizedRemoveFromKeySet() throws InterruptedException {
        Thread thread;
        Thread thread22;
        int n;
        LRUMap map = new LRUMap(10000);
        final HashMap exceptions = new HashMap();
        ThreadGroup tg = new ThreadGroup(this.getName()){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                exceptions.put(e, t.getName());
                super.uncaughtException(t, e);
            }
        };
        int[] counter = new int[]{0};
        Thread[] threads = new Thread[50];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(tg, "JUnit Thread " + i, (Map)map, counter){
                final /* synthetic */ Map val$map;
                final /* synthetic */ int[] val$counter;
                {
                    this.val$map = map;
                    this.val$counter = nArray;
                    super(arg0, arg1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Object object;
                    int i = 0;
                    try {
                        Map map;
                        object = this;
                        synchronized (object) {
                            this.notifyAll();
                            this.wait();
                        }
                        Thread thread = Thread.currentThread();
                        while (i < 1000 && !4.interrupted()) {
                            map = this.val$map;
                            synchronized (map) {
                                this.val$map.put(thread.getName() + "[" + ++i + "]", thread);
                            }
                        }
                        map = this.val$map;
                        synchronized (map) {
                            Iterator iter = this.val$map.keySet().iterator();
                            while (iter.hasNext()) {
                                String name = (String)iter.next();
                                if (!name.substring(0, name.indexOf(91)).equals(this.getName())) continue;
                                iter.remove();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Assertions.fail((String)"Unexpected InterruptedException");
                    }
                    if (i <= 0) return;
                    object = this.val$counter;
                    synchronized (this.val$counter) {
                        this.val$counter[0] = this.val$counter[0] + 1;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            };
        }
        Thread[] threadArray = threads;
        int n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.start();
                thread22.wait();
                continue;
            }
        }
        threadArray = threads;
        n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.notifyAll();
                continue;
            }
        }
        Thread.sleep(1000L);
        for (Thread thread22 : threads) {
            thread22.interrupt();
        }
        threadArray = threads;
        n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.join();
                continue;
            }
        }
        Assertions.assertEquals((int)0, (int)exceptions.size(), (String)("Exceptions have been thrown: " + exceptions));
        Assertions.assertTrue((counter[0] >= threads.length ? 1 : 0) != 0, (String)("Each thread should have put at least 1 element into the map, but only " + counter[0] + " did succeed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronizedRemoveFromMapIterator() throws InterruptedException {
        Thread thread;
        Thread thread22;
        int n;
        final LRUMap map = new LRUMap(10000);
        final HashMap exceptions = new HashMap();
        ThreadGroup tg = new ThreadGroup(this.getName()){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                exceptions.put(e, t.getName());
                super.uncaughtException(t, e);
            }
        };
        final int[] counter = new int[]{0};
        Thread[] threads = new Thread[50];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(tg, "JUnit Thread " + i){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Object object;
                    int i = 0;
                    try {
                        LRUMap lRUMap;
                        object = this;
                        synchronized (object) {
                            this.notifyAll();
                            this.wait();
                        }
                        Thread thread = Thread.currentThread();
                        while (i < 1000 && !6.interrupted()) {
                            lRUMap = map;
                            synchronized (lRUMap) {
                                map.put((Object)(thread.getName() + "[" + ++i + "]"), (Object)thread);
                            }
                        }
                        lRUMap = map;
                        synchronized (lRUMap) {
                            OrderedMapIterator iter = map.mapIterator();
                            while (iter.hasNext()) {
                                iter.next();
                                if (iter.getValue() != this) continue;
                                iter.remove();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Assertions.fail((String)"Unexpected InterruptedException");
                    }
                    if (i <= 0) return;
                    object = counter;
                    synchronized (counter) {
                        counter[0] = counter[0] + 1;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            };
        }
        Thread[] threadArray = threads;
        int n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.start();
                thread22.wait();
                continue;
            }
        }
        threadArray = threads;
        n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.notifyAll();
                continue;
            }
        }
        Thread.sleep(1000L);
        for (Thread thread22 : threads) {
            thread22.interrupt();
        }
        threadArray = threads;
        n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.join();
                continue;
            }
        }
        Assertions.assertEquals((int)0, (int)exceptions.size(), (String)("Exceptions have been thrown: " + exceptions));
        Assertions.assertTrue((counter[0] >= threads.length ? 1 : 0) != 0, (String)("Each thread should have put at least 1 element into the map, but only " + counter[0] + " did succeed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronizedRemoveFromValues() throws InterruptedException {
        Thread thread;
        Thread thread22;
        int n;
        LRUMap map = new LRUMap(10000);
        final HashMap exceptions = new HashMap();
        ThreadGroup tg = new ThreadGroup(this.getName()){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                exceptions.put(e, t.getName());
                super.uncaughtException(t, e);
            }
        };
        int[] counter = new int[]{0};
        Thread[] threads = new Thread[50];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(tg, "JUnit Thread " + i, (Map)map, counter){
                final /* synthetic */ Map val$map;
                final /* synthetic */ int[] val$counter;
                {
                    this.val$map = map;
                    this.val$counter = nArray;
                    super(arg0, arg1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Object object;
                    int i = 0;
                    try {
                        Map map;
                        object = this;
                        synchronized (object) {
                            this.notifyAll();
                            this.wait();
                        }
                        Thread thread = Thread.currentThread();
                        while (i < 1000 && !8.interrupted()) {
                            map = this.val$map;
                            synchronized (map) {
                                this.val$map.put(thread.getName() + "[" + ++i + "]", thread);
                            }
                        }
                        map = this.val$map;
                        synchronized (map) {
                            this.val$map.values().removeIf(thread1 -> thread1 == this);
                        }
                    }
                    catch (InterruptedException e) {
                        Assertions.fail((String)"Unexpected InterruptedException");
                    }
                    if (i <= 0) return;
                    object = this.val$counter;
                    synchronized (this.val$counter) {
                        this.val$counter[0] = this.val$counter[0] + 1;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            };
        }
        Thread[] threadArray = threads;
        int n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.start();
                thread22.wait();
                continue;
            }
        }
        threadArray = threads;
        n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.notifyAll();
                continue;
            }
        }
        Thread.sleep(1000L);
        for (Thread thread22 : threads) {
            thread22.interrupt();
        }
        threadArray = threads;
        n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            thread = thread22 = threadArray[n];
            synchronized (thread) {
                thread22.join();
                continue;
            }
        }
        Assertions.assertEquals((int)0, (int)exceptions.size(), (String)("Exceptions have been thrown: " + exceptions));
        Assertions.assertTrue((counter[0] >= threads.length ? 1 : 0) != 0, (String)("Each thread should have put at least 1 element into the map, but only " + counter[0] + " did succeed"));
    }

    static class SingleHashCode {
        private final String code;

        SingleHashCode(String code) {
            this.code = code;
        }

        public int hashCode() {
            return 12;
        }

        public String toString() {
            return "SingleHashCode:" + this.code;
        }
    }

    static class MockLRUMapSubclass<K, V>
    extends LRUMap<K, V> {
        private static final long serialVersionUID = -2126883654452042477L;
        AbstractLinkedMap.LinkEntry<K, V> entry;
        K key;
        V value;

        MockLRUMapSubclass(int size) {
            super(size);
        }

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry<K, V> entry) {
            this.entry = entry;
            this.key = entry.getKey();
            this.value = entry.getValue();
            return true;
        }
    }

    static class MockLRUMapSubclassBlocksRemove<K, V>
    extends LRUMap<K, V> {
        private static final long serialVersionUID = 6278917461128992945L;

        MockLRUMapSubclassBlocksRemove(int size, boolean scanUntilRemove) {
            super(size, scanUntilRemove);
        }

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry<K, V> entry) {
            return false;
        }
    }

    static class MockLRUMapSubclassFirstBlocksRemove<K, V>
    extends LRUMap<K, V> {
        private static final long serialVersionUID = -6939790801702973428L;

        MockLRUMapSubclassFirstBlocksRemove(int size) {
            super(size, true);
        }

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry<K, V> entry) {
            return !"a".equals(entry.getValue());
        }
    }
}

