/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.Flat3Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Flat3MapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final Integer THREE = 3;
    private static final String TEN = "10";
    private static final String TWENTY = "20";
    private static final String THIRTY = "30";

    public Flat3MapTest() {
        super(Flat3MapTest.class.getSimpleName());
    }

    @Override
    public BulkTest bulkTestMapIterator() {
        return new TestFlatMapIterator();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public Flat3Map<K, V> makeObject() {
        return new Flat3Map();
    }

    private void putAndRemove(Map<K, V> map) {
        map.put("A", "one");
        map.put("B", "two");
        map.put("C", "three");
        Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
        Map.Entry<K, V> mapEntry1 = it.next();
        Map.Entry<K, V> mapEntry2 = it.next();
        Map.Entry<K, V> mapEntry3 = it.next();
        it.remove();
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((Object)"one", map.get("A"));
        Assertions.assertEquals((Object)"two", map.get("B"));
        Assertions.assertNull(map.get("C"));
    }

    @Test
    public void testClone2() {
        Flat3Map<K, V> map = this.makeObject();
        Assertions.assertEquals((int)0, (int)map.size());
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)map.containsKey((Object)TWO));
        Assertions.assertSame((Object)TEN, (Object)map.get((Object)ONE));
        Assertions.assertSame((Object)TWENTY, (Object)map.get((Object)TWO));
        Flat3Map cloned = map.clone();
        Assertions.assertEquals((int)2, (int)cloned.size());
        Assertions.assertTrue((boolean)cloned.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)cloned.containsKey((Object)TWO));
        Assertions.assertSame((Object)TEN, (Object)cloned.get((Object)ONE));
        Assertions.assertSame((Object)TWENTY, (Object)cloned.get((Object)TWO));
        map.put((Object)TEN, (Object)ONE);
        map.put((Object)TWENTY, (Object)TWO);
        Assertions.assertEquals((int)4, (int)map.size());
        Assertions.assertEquals((int)2, (int)cloned.size());
        Assertions.assertTrue((boolean)cloned.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)cloned.containsKey((Object)TWO));
        Assertions.assertSame((Object)TEN, (Object)cloned.get((Object)ONE));
        Assertions.assertSame((Object)TWENTY, (Object)cloned.get((Object)TWO));
    }

    @Test
    public void testClone4() {
        Flat3Map<K, V> map = this.makeObject();
        Assertions.assertEquals((int)0, (int)map.size());
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)TEN, (Object)ONE);
        map.put((Object)TWENTY, (Object)TWO);
        Flat3Map cloned = map.clone();
        Assertions.assertEquals((int)4, (int)map.size());
        Assertions.assertEquals((int)4, (int)cloned.size());
        Assertions.assertTrue((boolean)cloned.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)cloned.containsKey((Object)TWO));
        Assertions.assertTrue((boolean)cloned.containsKey((Object)TEN));
        Assertions.assertTrue((boolean)cloned.containsKey((Object)TWENTY));
        Assertions.assertSame((Object)TEN, (Object)cloned.get((Object)ONE));
        Assertions.assertSame((Object)TWENTY, (Object)cloned.get((Object)TWO));
        Assertions.assertSame((Object)ONE, (Object)cloned.get((Object)TEN));
        Assertions.assertSame((Object)TWO, (Object)cloned.get((Object)TWENTY));
        map.clear();
        Assertions.assertEquals((int)0, (int)map.size());
        Assertions.assertEquals((int)4, (int)cloned.size());
        Assertions.assertTrue((boolean)cloned.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)cloned.containsKey((Object)TWO));
        Assertions.assertTrue((boolean)cloned.containsKey((Object)TEN));
        Assertions.assertTrue((boolean)cloned.containsKey((Object)TWENTY));
        Assertions.assertSame((Object)TEN, (Object)cloned.get((Object)ONE));
        Assertions.assertSame((Object)TWENTY, (Object)cloned.get((Object)TWO));
        Assertions.assertSame((Object)ONE, (Object)cloned.get((Object)TEN));
        Assertions.assertSame((Object)TWO, (Object)cloned.get((Object)TWENTY));
    }

    @Test
    public void testCollections261() {
        Flat3Map m = new Flat3Map();
        m.put((Object)1, (Object)1);
        m.put((Object)0, (Object)0);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)m.remove((Object)1)));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)m.remove((Object)0)));
        m.put((Object)2, (Object)2);
        m.put((Object)1, (Object)1);
        m.put((Object)0, (Object)0);
        Assertions.assertEquals((Integer)2, (Integer)((Integer)m.remove((Object)2)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)m.remove((Object)1)));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)m.remove((Object)0)));
    }

    @Test
    public void testContainsKey1() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put(null, (Object)THREE);
        boolean contains = m.containsKey(null);
        Assertions.assertTrue((boolean)contains);
    }

    @Test
    public void testContainsKey2() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put(null, (Object)TWO);
        boolean contains = m.containsKey(null);
        Assertions.assertTrue((boolean)contains);
    }

    @Test
    public void testContainsKey3() {
        Flat3Map m = new Flat3Map();
        m.put(null, (Object)ONE);
        boolean contains = m.containsKey(null);
        Assertions.assertTrue((boolean)contains);
    }

    @Test
    public void testContainsValue1() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put((Object)THREE, null);
        boolean contains = m.containsValue(null);
        Assertions.assertTrue((boolean)contains);
    }

    @Test
    public void testContainsValue2() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, null);
        boolean contains = m.containsValue(null);
        Assertions.assertTrue((boolean)contains);
    }

    @Test
    public void testContainsValue3() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, null);
        boolean contains = m.containsValue(null);
        Assertions.assertTrue((boolean)contains);
    }

    @Test
    public void testEntryIteratorSetValue1() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = (Map.Entry)it.next();
        entry.setValue("NewValue");
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)map.containsKey((Object)TWO));
        Assertions.assertTrue((boolean)map.containsKey((Object)THREE));
        Assertions.assertEquals((Object)"NewValue", (Object)map.get((Object)ONE));
        Assertions.assertEquals((Object)TWENTY, (Object)map.get((Object)TWO));
        Assertions.assertEquals((Object)THIRTY, (Object)map.get((Object)THREE));
    }

    @Test
    public void testEntryIteratorSetValue2() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        Iterator it = map.entrySet().iterator();
        it.next();
        Map.Entry entry = (Map.Entry)it.next();
        entry.setValue("NewValue");
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)map.containsKey((Object)TWO));
        Assertions.assertTrue((boolean)map.containsKey((Object)THREE));
        Assertions.assertEquals((Object)TEN, (Object)map.get((Object)ONE));
        Assertions.assertEquals((Object)"NewValue", (Object)map.get((Object)TWO));
        Assertions.assertEquals((Object)THIRTY, (Object)map.get((Object)THREE));
    }

    @Test
    public void testEntryIteratorSetValue3() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        Iterator it = map.entrySet().iterator();
        it.next();
        it.next();
        Map.Entry entry = (Map.Entry)it.next();
        entry.setValue("NewValue");
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)map.containsKey((Object)TWO));
        Assertions.assertTrue((boolean)map.containsKey((Object)THREE));
        Assertions.assertEquals((Object)TEN, (Object)map.get((Object)ONE));
        Assertions.assertEquals((Object)TWENTY, (Object)map.get((Object)TWO));
        Assertions.assertEquals((Object)"NewValue", (Object)map.get((Object)THREE));
    }

    @Test
    public void testEntrySet() {
        this.putAndRemove(new LinkedHashMap());
        this.putAndRemove((Map<K, V>)new Flat3Map());
    }

    @Test
    public void testEquals1() {
        Flat3Map<K, V> map1 = this.makeObject();
        map1.put((Object)"a", (Object)"testA");
        map1.put((Object)"b", (Object)"testB");
        Flat3Map<K, V> map2 = this.makeObject();
        map2.put((Object)"a", (Object)"testB");
        map2.put((Object)"b", (Object)"testA");
        Assertions.assertFalse((boolean)map1.equals(map2));
    }

    @Test
    public void testEquals2() {
        Flat3Map<K, V> map1 = this.makeObject();
        map1.put((Object)"a", (Object)"testA");
        map1.put((Object)"b", (Object)"testB");
        Flat3Map<K, V> map2 = this.makeObject();
        map2.put((Object)"a", (Object)"testB");
        map2.put((Object)"c", (Object)"testA");
        Assertions.assertFalse((boolean)map1.equals(map2));
    }

    @Test
    public void testGet1() {
        Flat3Map m = new Flat3Map();
        m.put(null, (Object)ONE);
        Object obj = m.get(null);
        Assertions.assertSame((Object)ONE, (Object)obj);
    }

    @Test
    public void testGet2() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put(null, (Object)TWO);
        Object obj = m.get(null);
        Assertions.assertSame((Object)TWO, (Object)obj);
    }

    @Test
    public void testGet3() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put(null, (Object)THREE);
        Object obj = m.get(null);
        Assertions.assertSame((Object)THREE, (Object)obj);
    }

    @Test
    public void testMapIteratorSetValue1() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        MapIterator it = map.mapIterator();
        it.next();
        it.setValue((Object)"NewValue");
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)map.containsKey((Object)TWO));
        Assertions.assertTrue((boolean)map.containsKey((Object)THREE));
        Assertions.assertEquals((Object)"NewValue", (Object)map.get((Object)ONE));
        Assertions.assertEquals((Object)TWENTY, (Object)map.get((Object)TWO));
        Assertions.assertEquals((Object)THIRTY, (Object)map.get((Object)THREE));
    }

    @Test
    public void testMapIteratorSetValue2() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        MapIterator it = map.mapIterator();
        it.next();
        it.next();
        it.setValue((Object)"NewValue");
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)map.containsKey((Object)TWO));
        Assertions.assertTrue((boolean)map.containsKey((Object)THREE));
        Assertions.assertEquals((Object)TEN, (Object)map.get((Object)ONE));
        Assertions.assertEquals((Object)"NewValue", (Object)map.get((Object)TWO));
        Assertions.assertEquals((Object)THIRTY, (Object)map.get((Object)THREE));
    }

    @Test
    public void testMapIteratorSetValue3() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)THREE, (Object)THIRTY);
        MapIterator it = map.mapIterator();
        it.next();
        it.next();
        it.next();
        it.setValue((Object)"NewValue");
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)map.containsKey((Object)TWO));
        Assertions.assertTrue((boolean)map.containsKey((Object)THREE));
        Assertions.assertEquals((Object)TEN, (Object)map.get((Object)ONE));
        Assertions.assertEquals((Object)TWENTY, (Object)map.get((Object)TWO));
        Assertions.assertEquals((Object)"NewValue", (Object)map.get((Object)THREE));
    }

    @Test
    public void testNewInstance1() {
        HashMap<Integer, Integer> orig = new HashMap<Integer, Integer>();
        orig.put(ONE, ONE);
        orig.put(TWO, TWO);
        Flat3Map m = new Flat3Map(orig);
        Assertions.assertEquals(orig, (Object)m);
        Assertions.assertEquals((int)2, (int)m.size());
    }

    @Test
    public void testPut1() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put(null, (Object)THREE);
        Object old = m.put(null, (Object)ONE);
        Assertions.assertEquals((Object)THREE, (Object)old);
        Assertions.assertEquals((Integer)ONE, (Integer)((Integer)m.get(null)));
    }

    @Test
    public void testPut2() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put(null, (Object)THREE);
        Object old = m.put(null, (Object)ONE);
        Assertions.assertEquals((Object)THREE, (Object)old);
        Assertions.assertEquals((Integer)ONE, (Integer)((Integer)m.get(null)));
    }

    @Test
    public void testPut3() {
        Flat3Map m = new Flat3Map();
        m.put(null, (Object)THREE);
        Object old = m.put(null, (Object)ONE);
        Assertions.assertEquals((Object)THREE, (Object)old);
        Assertions.assertNull((Object)m.get((Object)ONE));
    }

    @Test
    public void testPut4() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put((Object)THREE, (Object)THREE);
        Object old = m.put((Object)THREE, (Object)ONE);
        Assertions.assertEquals((Object)THREE, (Object)old);
        Assertions.assertEquals((Integer)ONE, (Integer)((Integer)m.get((Object)THREE)));
    }

    @Test
    public void testPut5() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)THREE);
        Object old = m.put((Object)TWO, (Object)ONE);
        Assertions.assertEquals((Object)THREE, (Object)old);
        Assertions.assertEquals((Integer)ONE, (Integer)((Integer)m.get((Object)TWO)));
    }

    @Test
    public void testPut6() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)THREE);
        Object old = m.put((Object)ONE, (Object)ONE);
        Assertions.assertEquals((Object)THREE, (Object)old);
        Assertions.assertEquals((Integer)ONE, (Integer)((Integer)m.get((Object)ONE)));
    }

    @Test
    public void testRemove1() {
        Flat3Map m = new Flat3Map();
        Object obj = m.remove((Object)44);
        Assertions.assertNull((Object)obj);
        m.put((Object)ONE, (Object)ONE);
        obj = m.remove((Object)ONE);
        Assertions.assertSame((Object)ONE, (Object)obj);
        Assertions.assertEquals((int)0, (int)m.size());
        obj = m.get((Object)ONE);
        Assertions.assertNull((Object)obj);
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put((Object)THREE, (Object)THREE);
        obj = m.remove((Object)ONE);
        Assertions.assertSame((Object)ONE, (Object)obj);
        obj = m.get((Object)ONE);
        Assertions.assertNull((Object)obj);
        obj = m.get((Object)TWO);
        Assertions.assertSame((Object)TWO, (Object)obj);
    }

    @Test
    public void testRemove10() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        Object obj = m.remove(null);
        Assertions.assertNull((Object)obj);
    }

    @Test
    public void testRemove11() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put((Object)THREE, (Object)THREE);
        Object obj = m.remove(null);
        Assertions.assertNull((Object)obj);
    }

    @Test
    public void testRemove12() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put((Object)THREE, (Object)THREE);
        Object obj = m.remove((Object)42);
        Assertions.assertNull((Object)obj);
    }

    @Test
    public void testRemove13() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        Object obj = m.remove((Object)42);
        Assertions.assertNull((Object)obj);
    }

    @Test
    public void testRemove2() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put((Object)THREE, (Object)THREE);
        Object obj = m.remove((Object)ONE);
        Assertions.assertSame((Object)ONE, (Object)obj);
        obj = m.get((Object)ONE);
        Assertions.assertNull((Object)obj);
        obj = m.get((Object)TWO);
        Assertions.assertSame((Object)TWO, (Object)obj);
        obj = m.get((Object)THREE);
        Assertions.assertSame((Object)THREE, (Object)obj);
    }

    @Test
    public void testRemove3() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put((Object)THREE, (Object)THREE);
        Object obj = m.remove((Object)TWO);
        Assertions.assertSame((Object)TWO, (Object)obj);
        obj = m.get((Object)ONE);
        Assertions.assertSame((Object)ONE, (Object)obj);
        obj = m.get((Object)TWO);
        Assertions.assertNull((Object)obj);
        obj = m.get((Object)THREE);
        Assertions.assertSame((Object)THREE, (Object)obj);
    }

    @Test
    public void testRemove4() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put((Object)THREE, (Object)THREE);
        Object obj = m.remove((Object)THREE);
        Assertions.assertSame((Object)THREE, (Object)obj);
        obj = m.get((Object)ONE);
        Assertions.assertSame((Object)ONE, (Object)obj);
        obj = m.get((Object)TWO);
        Assertions.assertSame((Object)TWO, (Object)obj);
        obj = m.get((Object)THREE);
        Assertions.assertNull((Object)obj);
    }

    @Test
    public void testRemove5() {
        Flat3Map m = new Flat3Map();
        m.put(null, (Object)ONE);
        Object obj = m.remove(null);
        Assertions.assertSame((Object)ONE, (Object)obj);
        obj = m.get(null);
        Assertions.assertNull((Object)obj);
    }

    @Test
    public void testRemove6() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put(null, (Object)TWO);
        Object obj = m.remove(null);
        Assertions.assertSame((Object)TWO, (Object)obj);
        obj = m.get((Object)ONE);
        Assertions.assertSame((Object)ONE, (Object)obj);
        obj = m.get(null);
        Assertions.assertNull((Object)obj);
    }

    @Test
    public void testRemove7() {
        Flat3Map m = new Flat3Map();
        m.put(null, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        Object obj = m.remove(null);
        Assertions.assertSame((Object)ONE, (Object)obj);
        obj = m.get(null);
        Assertions.assertNull((Object)obj);
        obj = m.get((Object)TWO);
        Assertions.assertSame((Object)TWO, (Object)obj);
    }

    @Test
    public void testRemove8() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        m.put((Object)TWO, (Object)TWO);
        m.put(null, (Object)THREE);
        Object obj = m.remove(null);
        Assertions.assertSame((Object)THREE, (Object)obj);
        obj = m.get((Object)ONE);
        Assertions.assertSame((Object)ONE, (Object)obj);
        obj = m.get((Object)TWO);
        Assertions.assertSame((Object)TWO, (Object)obj);
        obj = m.get(null);
        Assertions.assertNull((Object)obj);
    }

    @Test
    public void testRemove9() {
        Flat3Map m = new Flat3Map();
        m.put((Object)ONE, (Object)ONE);
        Object obj = m.remove(null);
        Assertions.assertNull((Object)obj);
    }

    @Test
    public void testSerialisation0() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(map);
        byte[] bytes = bout.toByteArray();
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bin);
        Flat3Map ser = (Flat3Map)in.readObject();
        in.close();
        Assertions.assertEquals((int)0, (int)map.size());
        Assertions.assertEquals((int)0, (int)ser.size());
    }

    @Test
    public void testSerialisation2() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(map);
        byte[] bytes = bout.toByteArray();
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bin);
        Flat3Map ser = (Flat3Map)in.readObject();
        in.close();
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((int)2, (int)ser.size());
        Assertions.assertTrue((boolean)ser.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)ser.containsKey((Object)TWO));
        Assertions.assertEquals((Object)TEN, (Object)ser.get((Object)ONE));
        Assertions.assertEquals((Object)TWENTY, (Object)ser.get((Object)TWO));
    }

    @Test
    public void testSerialisation4() throws Exception {
        Flat3Map<K, V> map = this.makeObject();
        map.put((Object)ONE, (Object)TEN);
        map.put((Object)TWO, (Object)TWENTY);
        map.put((Object)TEN, (Object)ONE);
        map.put((Object)TWENTY, (Object)TWO);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(map);
        byte[] bytes = bout.toByteArray();
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bin);
        Flat3Map ser = (Flat3Map)in.readObject();
        in.close();
        Assertions.assertEquals((int)4, (int)map.size());
        Assertions.assertEquals((int)4, (int)ser.size());
        Assertions.assertTrue((boolean)ser.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)ser.containsKey((Object)TWO));
        Assertions.assertTrue((boolean)ser.containsKey((Object)TEN));
        Assertions.assertTrue((boolean)ser.containsKey((Object)TWENTY));
        Assertions.assertEquals((Object)TEN, (Object)ser.get((Object)ONE));
        Assertions.assertEquals((Object)TWENTY, (Object)ser.get((Object)TWO));
        Assertions.assertEquals((Object)ONE, (Object)ser.get((Object)TEN));
        Assertions.assertEquals((Object)TWO, (Object)ser.get((Object)TWENTY));
    }

    @Test
    public void testToString() {
        Flat3Map m = new Flat3Map();
        String string0 = m.toString();
        Assertions.assertNotNull((Object)string0);
        m.put((Object)1, (Object)1);
        String string1 = m.toString();
        Assertions.assertNotNull((Object)string1);
        Assertions.assertNotSame((Object)string0, (Object)string1);
        m.put((Object)0, (Object)0);
        String string2 = m.toString();
        Assertions.assertNotNull((Object)string2);
        Assertions.assertNotSame((Object)string0, (Object)string2);
        Assertions.assertNotSame((Object)string1, (Object)string2);
        m.put((Object)2, (Object)2);
        String string3 = m.toString();
        Assertions.assertNotNull((Object)string3);
        Assertions.assertNotSame((Object)string0, (Object)string3);
        Assertions.assertNotSame((Object)string1, (Object)string3);
        Assertions.assertNotSame((Object)string2, (Object)string3);
    }

    public class TestFlatMapIterator
    extends AbstractMapIteratorTest<K, V> {
        public TestFlatMapIterator() {
            super("TestFlatMapIterator");
        }

        @Override
        public V[] addSetValues() {
            return Flat3MapTest.this.getNewSampleValues();
        }

        @Override
        public Map<K, V> getConfirmedMap() {
            return Flat3MapTest.this.getConfirmed();
        }

        @Override
        public IterableMap<K, V> getMap() {
            return Flat3MapTest.this.getMap();
        }

        @Override
        public MapIterator<K, V> makeEmptyIterator() {
            Flat3MapTest.this.resetEmpty();
            return Flat3MapTest.this.getMap().mapIterator();
        }

        @Override
        public MapIterator<K, V> makeObject() {
            Flat3MapTest.this.resetFull();
            return Flat3MapTest.this.getMap().mapIterator();
        }

        @Override
        public boolean supportsRemove() {
            return Flat3MapTest.this.isRemoveSupported();
        }

        @Override
        public boolean supportsSetValue() {
            return Flat3MapTest.this.isSetValueSupported();
        }

        @Override
        public void verify() {
            super.verify();
            Flat3MapTest.this.verify();
        }
    }
}

