/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ObjectArrayIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectArrayIteratorTest<E>
extends AbstractIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three"};

    public ObjectArrayIteratorTest() {
        super(ObjectArrayIteratorTest.class.getSimpleName());
    }

    public ObjectArrayIterator<E> makeArrayIterator() {
        return new ObjectArrayIterator(new Object[0]);
    }

    public ObjectArrayIterator<E> makeArrayIterator(E[] array) {
        return new ObjectArrayIterator((Object[])array);
    }

    public ObjectArrayIterator<E> makeArrayIterator(E[] array, int index) {
        return new ObjectArrayIterator((Object[])array, index);
    }

    public ObjectArrayIterator<E> makeArrayIterator(E[] array, int start, int end) {
        return new ObjectArrayIterator((Object[])array, start, end);
    }

    @Override
    public ObjectArrayIterator<E> makeEmptyIterator() {
        return new ObjectArrayIterator(new Object[0]);
    }

    @Override
    public ObjectArrayIterator<E> makeObject() {
        return new ObjectArrayIterator((Object[])this.testArray);
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Test
    public void testIterator() {
        ObjectArrayIterator<E> iter = this.makeObject();
        for (String testValue : this.testArray) {
            Object iterValue = iter.next();
            Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        }
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Iterator should now be empty");
        try {
            iter.next();
        }
        catch (Exception e) {
            Assertions.assertEquals(e.getClass(), new NoSuchElementException().getClass(), (String)"NoSuchElementException must be thrown");
        }
    }

    @Test
    public void testNullArray() {
        Assertions.assertThrows(NullPointerException.class, () -> this.makeArrayIterator(null));
    }

    @Test
    public void testReset() {
        ObjectArrayIterator<Object> it = this.makeArrayIterator((Object[])this.testArray);
        it.next();
        it.reset();
        Assertions.assertEquals((Object)"One", (Object)it.next());
    }
}

