/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractOrderedMapIteratorTest<K, V>
extends AbstractMapIteratorTest<K, V> {
    public AbstractOrderedMapIteratorTest(String testName) {
        super(testName);
    }

    @Override
    public abstract OrderedMapIterator<K, V> makeEmptyIterator();

    @Override
    public abstract OrderedMapIterator<K, V> makeObject();

    @Override
    @Test
    public void testEmptyMapIterator() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        super.testEmptyMapIterator();
        OrderedMapIterator it = this.makeEmptyIterator();
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertThrows(NoSuchElementException.class, () -> it.previous());
    }

    @Override
    @Test
    public void testFullMapIterator() {
        Object value;
        Object key;
        if (!this.supportsFullIterator()) {
            return;
        }
        super.testFullMapIterator();
        OrderedMapIterator<K, V> it = this.makeObject();
        Map map = this.getMap();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertFalse((boolean)it.hasPrevious());
        HashSet<Object> set = new HashSet<Object>();
        while (it.hasNext()) {
            key = it.next();
            Assertions.assertSame((Object)key, (Object)it.getKey(), (String)"it.next() should equals getKey()");
            Assertions.assertTrue((boolean)map.containsKey(key), (String)"Key must be in map");
            Assertions.assertTrue((boolean)set.add(key), (String)"Key must be unique");
            value = it.getValue();
            if (!this.isGetStructuralModify()) {
                Assertions.assertSame(map.get(key), (Object)value, (String)"Value must be mapped to key");
            }
            Assertions.assertTrue((boolean)map.containsValue(value), (String)"Value must be in map");
            Assertions.assertTrue((boolean)it.hasPrevious());
            this.verify();
        }
        while (it.hasPrevious()) {
            key = it.previous();
            Assertions.assertSame((Object)key, (Object)it.getKey(), (String)"it.previous() should equals getKey()");
            Assertions.assertTrue((boolean)map.containsKey(key), (String)"Key must be in map");
            Assertions.assertTrue((boolean)set.remove(key), (String)"Key must be unique");
            value = it.getValue();
            if (!this.isGetStructuralModify()) {
                Assertions.assertSame(map.get(key), (Object)value, (String)"Value must be mapped to key");
            }
            Assertions.assertTrue((boolean)map.containsValue(value), (String)"Value must be in map");
            Assertions.assertTrue((boolean)it.hasNext());
            this.verify();
        }
    }

    @Test
    public void testMapIteratorOrder() {
        Object key;
        if (!this.supportsFullIterator()) {
            return;
        }
        OrderedMapIterator<K, V> it = this.makeObject();
        Map map = this.getMap();
        Assertions.assertEquals(new ArrayList(map.keySet()), new ArrayList(map.keySet()), (String)"keySet() not consistent");
        Iterator it2 = map.keySet().iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it2.hasNext());
        ArrayList<Object> list = new ArrayList<Object>();
        while (it.hasNext()) {
            key = it.next();
            Assertions.assertEquals(it2.next(), (Object)key);
            list.add(key);
        }
        Assertions.assertEquals((int)map.size(), (int)list.size());
        while (it.hasPrevious()) {
            key = it.previous();
            Assertions.assertEquals(list.get(list.size() - 1), (Object)key);
            list.remove(list.size() - 1);
        }
        Assertions.assertEquals((int)0, (int)list.size());
    }
}

