/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.function.ToDoubleBiFunction;
import java.util.function.ToIntBiFunction;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.SetOperations;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;
import org.apache.commons.collections4.bloomfilter.SparseBloomFilter;
import org.apache.commons.collections4.bloomfilter.TestingHashers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SetOperationsTest {
    private final Shape shape = Shape.fromKM((int)17, (int)72);

    private static void assertSymmetricOperation(double expected, ToDoubleBiFunction<BloomFilter, BloomFilter> operation, BloomFilter filter1, BloomFilter filter2) {
        Assertions.assertEquals((double)expected, (double)operation.applyAsDouble(filter1, filter2), (String)"op(filter1, filter2)");
        Assertions.assertEquals((double)expected, (double)operation.applyAsDouble(filter2, filter1), (String)"op(filter2, filter1)");
    }

    private static void assertSymmetricOperation(int expected, ToIntBiFunction<BloomFilter, BloomFilter> operation, BloomFilter filter1, BloomFilter filter2) {
        Assertions.assertEquals((int)expected, (int)operation.applyAsInt(filter1, filter2), (String)"op(filter1, filter2)");
        Assertions.assertEquals((int)expected, (int)operation.applyAsInt(filter2, filter1), (String)"op(filter2, filter1)");
    }

    private BloomFilter createFilter(Shape shape, Hasher hasher) {
        SimpleBloomFilter bf = new SimpleBloomFilter(shape);
        bf.merge(hasher);
        return bf;
    }

    private BloomFilter createFilter(Shape shape, IndexProducer producer) {
        SparseBloomFilter bf = new SparseBloomFilter(shape);
        bf.merge(producer);
        return bf;
    }

    @Test
    public final void testAndCardinality() {
        Shape shape = Shape.fromKM((int)3, (int)128);
        BloomFilter filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63, 64}));
        BloomFilter filter2 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 69}));
        SetOperationsTest.assertSymmetricOperation(1, SetOperations::andCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63}));
        filter2 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 69}));
        SetOperationsTest.assertSymmetricOperation(0, SetOperations::andCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 63}));
        filter2 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 69}));
        SetOperationsTest.assertSymmetricOperation(1, SetOperations::andCardinality, filter1, filter2);
    }

    @Test
    public final void testAndCardinalityWithDifferentLengthFilters() {
        Shape shape = Shape.fromKM((int)3, (int)128);
        Shape shape2 = Shape.fromKM((int)3, (int)192);
        BloomFilter filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63, 64}));
        BloomFilter filter2 = this.createFilter(shape2, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 169}));
        SetOperationsTest.assertSymmetricOperation(1, SetOperations::andCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63}));
        filter2 = this.createFilter(shape2, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 169}));
        SetOperationsTest.assertSymmetricOperation(0, SetOperations::andCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 63}));
        filter2 = this.createFilter(shape2, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 169}));
        SetOperationsTest.assertSymmetricOperation(1, SetOperations::andCardinality, filter1, filter2);
    }

    @Test
    public final void testCommutativityOnMismatchedSizes() {
        BitMapProducer p1 = BitMapProducer.fromBitMapArray((long[])new long[]{3L, 5L});
        BitMapProducer p2 = BitMapProducer.fromBitMapArray((long[])new long[]{1L});
        Assertions.assertEquals((int)SetOperations.orCardinality((BitMapProducer)p1, (BitMapProducer)p2), (int)SetOperations.orCardinality((BitMapProducer)p2, (BitMapProducer)p1));
        Assertions.assertEquals((int)SetOperations.xorCardinality((BitMapProducer)p1, (BitMapProducer)p2), (int)SetOperations.xorCardinality((BitMapProducer)p2, (BitMapProducer)p1));
        Assertions.assertEquals((int)SetOperations.andCardinality((BitMapProducer)p1, (BitMapProducer)p2), (int)SetOperations.andCardinality((BitMapProducer)p2, (BitMapProducer)p1));
        Assertions.assertEquals((int)SetOperations.hammingDistance((BitMapProducer)p1, (BitMapProducer)p2), (int)SetOperations.hammingDistance((BitMapProducer)p2, (BitMapProducer)p1));
        Assertions.assertEquals((double)SetOperations.cosineDistance((BitMapProducer)p1, (BitMapProducer)p2), (double)SetOperations.cosineDistance((BitMapProducer)p2, (BitMapProducer)p1));
        Assertions.assertEquals((double)SetOperations.cosineSimilarity((BitMapProducer)p1, (BitMapProducer)p2), (double)SetOperations.cosineSimilarity((BitMapProducer)p2, (BitMapProducer)p1));
        Assertions.assertEquals((double)SetOperations.jaccardDistance((BitMapProducer)p1, (BitMapProducer)p2), (double)SetOperations.jaccardDistance((BitMapProducer)p2, (BitMapProducer)p1));
        Assertions.assertEquals((double)SetOperations.jaccardSimilarity((BitMapProducer)p1, (BitMapProducer)p2), (double)SetOperations.jaccardSimilarity((BitMapProducer)p2, (BitMapProducer)p1));
    }

    @Test
    public final void testCosineDistance() {
        BloomFilter filter1 = this.createFilter(this.shape, TestingHashers.FROM1);
        BloomFilter filter2 = this.createFilter(this.shape, TestingHashers.FROM1);
        double expected = 0.0;
        SetOperationsTest.assertSymmetricOperation(expected, SetOperations::cosineDistance, filter1, filter2);
        Shape shape2 = Shape.fromKM((int)2, (int)72);
        filter1 = this.createFilter(shape2, TestingHashers.FROM1);
        filter2 = this.createFilter(shape2, new IncrementingHasher(2L, 1L));
        int dotProduct = 1;
        int cardinalityA = 2;
        int cardinalityB = 2;
        expected = 1.0 - (double)dotProduct / Math.sqrt(cardinalityA * cardinalityB);
        SetOperationsTest.assertSymmetricOperation(expected, SetOperations::cosineDistance, filter1, filter2);
        filter1 = this.createFilter(this.shape, TestingHashers.FROM1);
        filter2 = this.createFilter(this.shape, TestingHashers.FROM11);
        dotProduct = 7;
        cardinalityA = 17;
        cardinalityB = 17;
        expected = 1.0 - (double)dotProduct / Math.sqrt(cardinalityA * cardinalityB);
        SetOperationsTest.assertSymmetricOperation(expected, SetOperations::cosineDistance, filter1, filter2);
        filter1 = this.createFilter(this.shape, TestingHashers.FROM1);
        filter2 = new SimpleBloomFilter(this.shape);
        dotProduct = 0;
        cardinalityA = 2;
        cardinalityB = 0;
        expected = 1.0;
        SetOperationsTest.assertSymmetricOperation(expected, SetOperations::cosineDistance, filter1, filter2);
        dotProduct = 0;
        cardinalityA = 0;
        cardinalityB = 0;
        expected = 1.0;
        SetOperationsTest.assertSymmetricOperation(expected, SetOperations::cosineDistance, filter1, filter2);
    }

    @Test
    public final void testCosineSimilarity() {
        BloomFilter filter1 = this.createFilter(this.shape, TestingHashers.FROM1);
        BloomFilter filter2 = this.createFilter(this.shape, TestingHashers.FROM1);
        int dotProduct = 17;
        int cardinalityA = 17;
        int cardinalityB = 17;
        double expected = 1.0;
        SetOperationsTest.assertSymmetricOperation(expected, SetOperations::cosineSimilarity, filter1, filter2);
        dotProduct = 7;
        cardinalityA = 17;
        cardinalityB = 17;
        expected = (double)dotProduct / Math.sqrt(cardinalityA * cardinalityB);
        filter2 = this.createFilter(this.shape, TestingHashers.FROM11);
        SetOperationsTest.assertSymmetricOperation(expected, SetOperations::cosineSimilarity, filter1, filter2);
        filter1 = new SimpleBloomFilter(this.shape);
        filter2 = new SimpleBloomFilter(this.shape);
        BloomFilter filter3 = this.createFilter(this.shape, TestingHashers.FROM1);
        SetOperationsTest.assertSymmetricOperation(0.0, SetOperations::cosineSimilarity, filter1, filter2);
        SetOperationsTest.assertSymmetricOperation(0.0, SetOperations::cosineSimilarity, filter1, filter3);
    }

    @Test
    public final void testHammingDistance() {
        BloomFilter filter1 = this.createFilter(this.shape, TestingHashers.FROM1);
        BloomFilter filter2 = this.createFilter(this.shape, TestingHashers.FROM1);
        int hammingDistance = 0;
        SetOperationsTest.assertSymmetricOperation(hammingDistance, SetOperations::hammingDistance, filter1, filter2);
        filter2 = this.createFilter(this.shape, TestingHashers.FROM11);
        hammingDistance = 20;
        SetOperationsTest.assertSymmetricOperation(hammingDistance, SetOperations::hammingDistance, filter1, filter2);
    }

    @Test
    public final void testJaccardDistance() {
        BloomFilter filter1 = this.createFilter(this.shape, TestingHashers.FROM1);
        BloomFilter filter2 = this.createFilter(this.shape, TestingHashers.FROM1);
        SetOperationsTest.assertSymmetricOperation(0.0, SetOperations::jaccardDistance, filter1, filter2);
        filter2 = this.createFilter(this.shape, TestingHashers.FROM11);
        double intersection = 7.0;
        int union = 27;
        double expected = 0.7407407407407407;
        SetOperationsTest.assertSymmetricOperation(0.7407407407407407, SetOperations::jaccardDistance, filter1, filter2);
        filter1 = new SimpleBloomFilter(this.shape);
        filter2 = new SimpleBloomFilter(this.shape);
        BloomFilter filter3 = this.createFilter(this.shape, TestingHashers.FROM1);
        SetOperationsTest.assertSymmetricOperation(1.0, SetOperations::jaccardDistance, filter1, filter2);
        SetOperationsTest.assertSymmetricOperation(1.0, SetOperations::jaccardDistance, filter1, filter3);
    }

    @Test
    public final void testJaccardSimilarity() {
        BloomFilter filter1 = this.createFilter(this.shape, TestingHashers.FROM1);
        BloomFilter filter2 = this.createFilter(this.shape, TestingHashers.FROM1);
        double intersection = 17.0;
        int union = 17;
        double expected = intersection / (double)union;
        SetOperationsTest.assertSymmetricOperation(expected, SetOperations::jaccardSimilarity, filter1, filter2);
        filter2 = this.createFilter(this.shape, TestingHashers.FROM11);
        intersection = 7.0;
        union = 27;
        expected = intersection / (double)union;
        SetOperationsTest.assertSymmetricOperation(expected, SetOperations::jaccardSimilarity, filter1, filter2);
        filter1 = new SimpleBloomFilter(this.shape);
        filter2 = new SimpleBloomFilter(this.shape);
        SetOperationsTest.assertSymmetricOperation(0.0, SetOperations::jaccardSimilarity, filter1, filter2);
        intersection = 0.0;
        union = 17;
        expected = intersection / (double)union;
        SetOperationsTest.assertSymmetricOperation(expected, SetOperations::jaccardSimilarity, filter1, filter2);
    }

    @Test
    public final void testOrCardinality() {
        Shape shape = Shape.fromKM((int)3, (int)128);
        BloomFilter filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63, 64}));
        BloomFilter filter2 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 69}));
        SetOperationsTest.assertSymmetricOperation(5, SetOperations::orCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63}));
        filter2 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 69}));
        SetOperationsTest.assertSymmetricOperation(5, SetOperations::orCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 63}));
        filter2 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 69}));
        SetOperationsTest.assertSymmetricOperation(4, SetOperations::orCardinality, filter1, filter2);
    }

    @Test
    public final void testOrCardinalityWithDifferentLengthFilters() {
        Shape shape = Shape.fromKM((int)3, (int)128);
        Shape shape2 = Shape.fromKM((int)3, (int)192);
        BloomFilter filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63, 64}));
        BloomFilter filter2 = this.createFilter(shape2, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 169}));
        SetOperationsTest.assertSymmetricOperation(5, SetOperations::orCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63}));
        filter2 = this.createFilter(shape2, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 169}));
        SetOperationsTest.assertSymmetricOperation(5, SetOperations::orCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 63}));
        filter2 = this.createFilter(shape2, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 169}));
        SetOperationsTest.assertSymmetricOperation(4, SetOperations::orCardinality, filter1, filter2);
    }

    @Test
    public final void testXorCardinality() {
        Shape shape = Shape.fromKM((int)3, (int)128);
        BloomFilter filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63, 64}));
        BloomFilter filter2 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 69}));
        SetOperationsTest.assertSymmetricOperation(4, SetOperations::xorCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63}));
        filter2 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 69}));
        SetOperationsTest.assertSymmetricOperation(5, SetOperations::xorCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 63}));
        filter2 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 69}));
        SetOperationsTest.assertSymmetricOperation(3, SetOperations::xorCardinality, filter1, filter2);
        Shape bigShape = Shape.fromKM((int)3, (int)192);
        filter1 = this.createFilter(bigShape, IndexProducer.fromIndexArray((int[])new int[]{1, 63, 185}));
        filter2 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 63, 69}));
        SetOperationsTest.assertSymmetricOperation(4, SetOperations::xorCardinality, filter1, filter2);
    }

    @Test
    public final void testXorCardinalityWithDifferentLengthFilters() {
        Shape shape = Shape.fromKM((int)3, (int)128);
        Shape shape2 = Shape.fromKM((int)3, (int)192);
        BloomFilter filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63, 64}));
        BloomFilter filter2 = this.createFilter(shape2, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 169}));
        SetOperationsTest.assertSymmetricOperation(4, SetOperations::xorCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{1, 63}));
        filter2 = this.createFilter(shape2, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 169}));
        SetOperationsTest.assertSymmetricOperation(5, SetOperations::xorCardinality, filter1, filter2);
        filter1 = this.createFilter(shape, IndexProducer.fromIndexArray((int[])new int[]{5, 63}));
        filter2 = this.createFilter(shape2, IndexProducer.fromIndexArray((int[])new int[]{5, 64, 169}));
        SetOperationsTest.assertSymmetricOperation(3, SetOperations::xorCardinality, filter1, filter2);
    }
}

