/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.collections4.bloomfilter.AbstractBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.DefaultBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.LayerManager;
import org.apache.commons.collections4.bloomfilter.LayeredBloomFilter;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;
import org.apache.commons.collections4.bloomfilter.SparseBloomFilter;
import org.apache.commons.collections4.bloomfilter.TestingHashers;
import org.apache.commons.collections4.bloomfilter.WrappedBloomFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LayeredBloomFilterTest
extends AbstractBloomFilterTest<LayeredBloomFilter> {
    private static List<String> dbgInstrument = new ArrayList<String>();
    private Predicate<BloomFilter> dbg = bf -> {
        TimestampedBloomFilter tbf = (TimestampedBloomFilter)((Object)bf);
        long ts = System.currentTimeMillis();
        dbgInstrument.add(String.format("T:%s (Elapsed:%s)- EstN:%s (Card:%s)\n", tbf.timestamp, ts - tbf.timestamp, tbf.estimateN(), tbf.cardinality()));
        return true;
    };

    static LayeredBloomFilter createTimedLayeredFilter(Shape shape, long duration, TimeUnit dUnit, long quanta, TimeUnit qUnit) {
        LayerManager layerManager = LayerManager.builder().setSupplier(() -> new TimestampedBloomFilter((BloomFilter)new SimpleBloomFilter(shape))).setCleanup(LayerManager.Cleanup.removeEmptyTarget().andThen(new CleanByTime(duration, dUnit))).setExtendCheck(new AdvanceOnTimeQuanta(quanta, qUnit).or(LayerManager.ExtendCheck.advanceOnSaturation((double)shape.estimateMaxN()))).build();
        return new LayeredBloomFilter(shape, layerManager);
    }

    @Override
    protected LayeredBloomFilter createEmptyFilter(Shape shape) {
        return LayeredBloomFilter.fixed((Shape)shape, (int)10);
    }

    protected BloomFilter makeFilter(Hasher h) {
        SparseBloomFilter bf = new SparseBloomFilter(this.getTestShape());
        bf.merge(h);
        return bf;
    }

    protected BloomFilter makeFilter(IndexProducer p) {
        SparseBloomFilter bf = new SparseBloomFilter(this.getTestShape());
        bf.merge(p);
        return bf;
    }

    protected BloomFilter makeFilter(int ... values) {
        return this.makeFilter(IndexProducer.fromIndexArray((int[])values));
    }

    private LayeredBloomFilter setupFindTest() {
        LayeredBloomFilter filter = LayeredBloomFilter.fixed((Shape)this.getTestShape(), (int)10);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        filter.merge((Hasher)new IncrementingHasher(11L, 2L));
        filter.merge((BloomFilter)TestingHashers.populateFromHashersFrom1AndFrom11(new SimpleBloomFilter(this.getTestShape())));
        return filter;
    }

    @Override
    @Test
    public void testCardinalityAndIsEmpty() {
        LayerManager layerManager = LayerManager.builder().setExtendCheck(LayerManager.ExtendCheck.neverAdvance()).setSupplier(() -> new SimpleBloomFilter(this.getTestShape())).build();
        this.testCardinalityAndIsEmpty((BloomFilter)new LayeredBloomFilter(this.getTestShape(), layerManager));
    }

    @Test
    public final void testEstimateUnionCrossTypes() {
        Object bf = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        DefaultBloomFilterTest.SparseDefaultBloomFilter bf2 = new DefaultBloomFilterTest.SparseDefaultBloomFilter(this.getTestShape());
        bf2.merge(TestingHashers.FROM11);
        Assertions.assertEquals((int)2, (int)bf.estimateUnion((BloomFilter)bf2));
        Assertions.assertEquals((int)2, (int)bf2.estimateUnion((BloomFilter)bf));
    }

    @Test
    public void testExpiration() throws InterruptedException {
        int i;
        ArrayList lst = new ArrayList();
        Shape shape = Shape.fromNM((int)4, (int)64);
        LayeredBloomFilter underTest = LayeredBloomFilterTest.createTimedLayeredFilter(shape, 600L, TimeUnit.MILLISECONDS, 150L, TimeUnit.MILLISECONDS);
        for (i = 0; i < 10; ++i) {
            underTest.merge(TestingHashers.randomHasher());
        }
        underTest.forEachBloomFilter(this.dbg.and(x -> lst.add(((TimestampedBloomFilter)x).timestamp)));
        Assertions.assertTrue((underTest.getDepth() > 1 ? 1 : 0) != 0);
        Thread.sleep(300L);
        for (i = 0; i < 10; ++i) {
            underTest.merge(TestingHashers.randomHasher());
        }
        dbgInstrument.add("=== AFTER 300 milliseconds ====\n");
        underTest.forEachBloomFilter(this.dbg);
        Thread.sleep(150L);
        for (i = 0; i < 10; ++i) {
            underTest.merge(TestingHashers.randomHasher());
        }
        dbgInstrument.add("=== AFTER 450 milliseconds ====\n");
        underTest.forEachBloomFilter(this.dbg);
        Thread.sleep(200L);
        underTest.merge(TestingHashers.randomHasher());
        dbgInstrument.add("=== AFTER 600 milliseconds ====\n");
        Assertions.assertTrue((boolean)underTest.forEachBloomFilter(this.dbg.and(x -> !lst.contains(((TimestampedBloomFilter)x).timestamp))), (String)("Found filter that should have been deleted: " + dbgInstrument.get(dbgInstrument.size() - 1)));
    }

    @Test
    public void testFindBitMapProducer() {
        LayeredBloomFilter filter = this.setupFindTest();
        IndexProducer idxProducer = TestingHashers.FROM1.indices(this.getTestShape());
        BitMapProducer producer = BitMapProducer.fromIndexProducer((IndexProducer)idxProducer, (int)this.getTestShape().getNumberOfBits());
        int[] expected = new int[]{0, 3};
        int[] result = filter.find(producer);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
        expected = new int[]{1, 3};
        idxProducer = TestingHashers.FROM11.indices(this.getTestShape());
        producer = BitMapProducer.fromIndexProducer((IndexProducer)idxProducer, (int)this.getTestShape().getNumberOfBits());
        result = filter.find(producer);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
    }

    @Test
    public void testFindBloomFilter() {
        LayeredBloomFilter filter = this.setupFindTest();
        int[] expected = new int[]{0, 3};
        int[] result = filter.find(TestingHashers.FROM1);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
        expected = new int[]{1, 3};
        result = filter.find(TestingHashers.FROM11);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
    }

    @Test
    public void testFindIndexProducer() {
        IndexProducer producer = TestingHashers.FROM1.indices(this.getTestShape());
        LayeredBloomFilter filter = this.setupFindTest();
        int[] expected = new int[]{0, 3};
        int[] result = filter.find(producer);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
        expected = new int[]{1, 3};
        producer = TestingHashers.FROM11.indices(this.getTestShape());
        result = filter.find(producer);
        Assertions.assertArrayEquals((int[])expected, (int[])result);
    }

    @Test
    public final void testGetLayer() {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.getTestShape());
        bf.merge(TestingHashers.FROM11);
        LayeredBloomFilter filter = LayeredBloomFilter.fixed((Shape)this.getTestShape(), (int)10);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        filter.merge((Hasher)new IncrementingHasher(11L, 2L));
        filter.merge((BloomFilter)TestingHashers.populateFromHashersFrom1AndFrom11(new SimpleBloomFilter(this.getTestShape())));
        Assertions.assertArrayEquals((long[])bf.asBitMapArray(), (long[])filter.get(1).asBitMapArray());
    }

    @Test
    public void testMultipleFilters() {
        LayeredBloomFilter filter = LayeredBloomFilter.fixed((Shape)this.getTestShape(), (int)10);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        Assertions.assertEquals((int)2, (int)filter.getDepth());
        Assertions.assertTrue((boolean)filter.contains(this.makeFilter(TestingHashers.FROM1)));
        Assertions.assertTrue((boolean)filter.contains(this.makeFilter(TestingHashers.FROM11)));
        BloomFilter t1 = this.makeFilter(6, 7, 17, 18, 19);
        Assertions.assertFalse((boolean)filter.contains(t1));
        Assertions.assertFalse((boolean)filter.copy().contains(t1));
        Assertions.assertTrue((boolean)filter.flatten().contains(t1));
    }

    @Test
    public final void testNext() {
        LayerManager layerManager = LayerManager.builder().setSupplier(() -> new SimpleBloomFilter(this.getTestShape())).build();
        LayeredBloomFilter filter = new LayeredBloomFilter(this.getTestShape(), layerManager);
        filter.merge(TestingHashers.FROM1);
        filter.merge(TestingHashers.FROM11);
        Assertions.assertEquals((int)1, (int)filter.getDepth());
        filter.next();
        filter.merge((Hasher)new IncrementingHasher(11L, 2L));
        Assertions.assertEquals((int)2, (int)filter.getDepth());
        Assertions.assertTrue((boolean)filter.get(0).contains(TestingHashers.FROM1));
        Assertions.assertTrue((boolean)filter.get(0).contains(TestingHashers.FROM11));
        Assertions.assertFalse((boolean)filter.get(0).contains((Hasher)new IncrementingHasher(11L, 2L)));
        Assertions.assertFalse((boolean)filter.get(1).contains(TestingHashers.FROM1));
        Assertions.assertFalse((boolean)filter.get(1).contains(TestingHashers.FROM11));
        Assertions.assertTrue((boolean)filter.get(1).contains((Hasher)new IncrementingHasher(11L, 2L)));
    }

    static class CleanByTime
    implements Consumer<LinkedList<BloomFilter>> {
        long elapsedTime;

        CleanByTime(long duration, TimeUnit unit) {
            this.elapsedTime = unit.toMillis(duration);
        }

        @Override
        public void accept(LinkedList<BloomFilter> t) {
            long min = System.currentTimeMillis() - this.elapsedTime;
            while (!t.isEmpty() && ((TimestampedBloomFilter)t.getFirst()).getTimestamp() < min) {
                TimestampedBloomFilter bf = (TimestampedBloomFilter)t.getFirst();
                dbgInstrument.add(String.format("Removing old entry: T:%s (Aged: %s) \n", bf.getTimestamp(), min - bf.getTimestamp()));
                t.removeFirst();
            }
        }
    }

    static class AdvanceOnTimeQuanta
    implements Predicate<LayerManager> {
        long quanta;

        AdvanceOnTimeQuanta(long quanta, TimeUnit unit) {
            this.quanta = unit.toMillis(quanta);
        }

        @Override
        public boolean test(LayerManager lm) {
            TimestampedBloomFilter bf = (TimestampedBloomFilter)lm.get(lm.getDepth() - 1);
            return bf.timestamp + this.quanta < System.currentTimeMillis();
        }
    }

    static class TimestampedBloomFilter
    extends WrappedBloomFilter {
        final long timestamp = System.currentTimeMillis();

        TimestampedBloomFilter(BloomFilter bf) {
            super(bf);
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

