/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class IndexProducerTest {
    @Test
    public void fromBitMapProducerTest() {
        TestingBitMapProducer producer = new TestingBitMapProducer(new long[]{1L, 2L, 3L});
        IndexProducer underTest = IndexProducer.fromBitMapProducer((BitMapProducer)producer);
        ArrayList lst = new ArrayList();
        underTest.forEachIndex(lst::add);
        Assertions.assertEquals((int)4, (int)lst.size());
        Assertions.assertEquals((Integer)0, (Integer)((Integer)lst.get(0)));
        Assertions.assertEquals((Integer)65, (Integer)((Integer)lst.get(1)));
        Assertions.assertEquals((Integer)128, (Integer)((Integer)lst.get(2)));
        Assertions.assertEquals((Integer)129, (Integer)((Integer)lst.get(3)));
        producer = new TestingBitMapProducer(new long[]{-1L});
        underTest = IndexProducer.fromBitMapProducer((BitMapProducer)producer);
        lst = new ArrayList();
        underTest.forEachIndex(lst::add);
        Assertions.assertEquals((int)64, (int)lst.size());
        for (int i = 0; i < 64; ++i) {
            Assertions.assertEquals((Integer)i, (Integer)((Integer)lst.get(i)));
        }
    }

    @ParameterizedTest
    @ValueSource(ints={32, 33})
    void testAsIndexArray(int n) {
        IndexProducer ip = i -> {
            for (int j = 0; j < n; ++j) {
                i.test(0);
            }
            return true;
        };
        Assertions.assertArrayEquals((int[])new int[n], (int[])ip.asIndexArray());
    }

    private static final class TestingBitMapProducer
    implements BitMapProducer {
        long[] values;

        TestingBitMapProducer(long[] values) {
            this.values = values;
        }

        public boolean forEachBitMap(LongPredicate consumer) {
            for (long l : this.values) {
                if (consumer.test(l)) continue;
                return false;
            }
            return true;
        }
    }
}

