/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.AbstractIndexProducerTest;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class IndexProducerFromBitmapProducerTest
extends AbstractIndexProducerTest {
    @Override
    protected IndexProducer createEmptyProducer() {
        TestingBitMapProducer producer = new TestingBitMapProducer(new long[0]);
        return IndexProducer.fromBitMapProducer((BitMapProducer)producer);
    }

    @Override
    protected IndexProducer createProducer() {
        TestingBitMapProducer producer = new TestingBitMapProducer(new long[]{1L, 2L, 3L});
        return IndexProducer.fromBitMapProducer((BitMapProducer)producer);
    }

    @Override
    protected int getAsIndexArrayBehaviour() {
        return 3;
    }

    @Override
    protected int[] getExpectedIndices() {
        return new int[]{0, 65, 128, 129};
    }

    @Test
    public final void testFromBitMapProducerTest() {
        IndexProducer underTest = this.createProducer();
        ArrayList lst = new ArrayList();
        underTest.forEachIndex(lst::add);
        Assert.assertEquals((long)4L, (long)lst.size());
        Assert.assertEquals((Object)0, lst.get(0));
        Assert.assertEquals((Object)65, lst.get(1));
        Assert.assertEquals((Object)128, lst.get(2));
        Assert.assertEquals((Object)129, lst.get(3));
        TestingBitMapProducer producer = new TestingBitMapProducer(new long[]{-1L});
        underTest = IndexProducer.fromBitMapProducer((BitMapProducer)producer);
        lst = new ArrayList();
        underTest.forEachIndex(lst::add);
        Assert.assertEquals((long)64L, (long)lst.size());
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((Object)i, lst.get(i));
        }
    }

    private static final class TestingBitMapProducer
    implements BitMapProducer {
        long[] values;

        TestingBitMapProducer(long[] values) {
            this.values = values;
        }

        public boolean forEachBitMap(LongPredicate consumer) {
            for (long l : this.values) {
                if (consumer.test(l)) continue;
                return false;
            }
            return true;
        }
    }
}

