/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.AbstractIndexProducerTest;
import org.apache.commons.collections4.bloomfilter.ArrayCountingBloomFilter;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.Shape;

public class IndexProducerFromArrayCountingBloomFilterTest
extends AbstractIndexProducerTest {
    protected Shape shape = Shape.fromKM((int)17, (int)72);

    @Override
    protected IndexProducer createEmptyProducer() {
        return new ArrayCountingBloomFilter(this.shape);
    }

    @Override
    protected IndexProducer createProducer() {
        ArrayCountingBloomFilter filter = new ArrayCountingBloomFilter(this.shape);
        filter.merge((Hasher)new IncrementingHasher(0L, 1L));
        filter.merge((Hasher)new IncrementingHasher(5L, 1L));
        return filter;
    }

    @Override
    protected int getAsIndexArrayBehaviour() {
        return 3;
    }

    @Override
    protected int[] getExpectedIndices() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    }
}

