/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import java.util.function.IntPredicate;
import org.apache.commons.collections4.bloomfilter.BitMap;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.Shape;

public final class IncrementingHasher
implements Hasher {
    private final long initial;
    private final long increment;

    public IncrementingHasher(long initial, long increment) {
        this.initial = initial;
        this.increment = increment;
    }

    public IndexProducer indices(final Shape shape) {
        Objects.requireNonNull(shape, "shape");
        return new IndexProducer(){

            public int[] asIndexArray() {
                int[] result = new int[shape.getNumberOfHashFunctions()];
                int[] idx = new int[1];
                this.forEachIndex(i -> {
                    int n = idx[0];
                    idx[0] = n + 1;
                    result[n] = i;
                    return true;
                });
                return result;
            }

            public boolean forEachIndex(IntPredicate consumer) {
                Objects.requireNonNull(consumer, "consumer");
                int bits = shape.getNumberOfBits();
                long index = BitMap.mod((long)IncrementingHasher.this.initial, (int)bits);
                int inc = BitMap.mod((long)IncrementingHasher.this.increment, (int)bits);
                for (int functionalCount = 0; functionalCount < shape.getNumberOfHashFunctions(); ++functionalCount) {
                    if (!consumer.test((int)index)) {
                        return false;
                    }
                    index = (index += (long)inc) >= (long)bits ? index - (long)bits : index;
                }
                return true;
            }
        };
    }
}

