/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.AbstractCellProducerTest;
import org.apache.commons.collections4.bloomfilter.CellProducer;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.LayeredBloomFilter;
import org.apache.commons.collections4.bloomfilter.Shape;

public class CellProducerFromLayeredBloomFilterTest
extends AbstractCellProducerTest {
    protected Shape shape = Shape.fromKM((int)17, (int)72);

    @Override
    protected CellProducer createEmptyProducer() {
        return CellProducer.from((IndexProducer)LayeredBloomFilter.fixed((Shape)this.shape, (int)10));
    }

    @Override
    protected CellProducer createProducer() {
        IncrementingHasher hasher = new IncrementingHasher(3L, 2L);
        LayeredBloomFilter bf = LayeredBloomFilter.fixed((Shape)this.shape, (int)10);
        bf.merge((Hasher)hasher);
        return CellProducer.from((IndexProducer)bf);
    }

    @Override
    protected int[] getExpectedIndices() {
        return new int[]{3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35};
    }

    @Override
    protected int[] getExpectedValues() {
        return new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    }
}

