/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import org.apache.commons.collections4.bloomfilter.AbstractBitMapProducerTest;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BitMapProducerFromLongArrayTest
extends AbstractBitMapProducerTest {
    @Test
    public void constructorTest() {
        ArrayList lst = new ArrayList();
        this.createProducer().forEachBitMap(lst::add);
        Assertions.assertEquals((Long)1L, (Long)((Long)lst.get(0)));
        Assertions.assertEquals((Long)2L, (Long)((Long)lst.get(1)));
        Assertions.assertEquals((Long)3L, (Long)((Long)lst.get(2)));
        Assertions.assertEquals((Long)4L, (Long)((Long)lst.get(3)));
        Assertions.assertEquals((Long)5L, (Long)((Long)lst.get(4)));
    }

    @Override
    protected BitMapProducer createEmptyProducer() {
        return BitMapProducer.fromBitMapArray((long[])new long[0]);
    }

    @Override
    protected BitMapProducer createProducer() {
        long[] ary = new long[]{1L, 2L, 3L, 4L, 5L};
        return BitMapProducer.fromBitMapArray((long[])ary);
    }

    @Override
    protected boolean emptyIsZeroLength() {
        return true;
    }

    @Test
    public void testFromIndexProducer() {
        int limit = 96;
        IndexProducer iProducer = consumer -> {
            for (int i = 0; i < 96; ++i) {
                if (consumer.test(i)) continue;
                return false;
            }
            return true;
        };
        BitMapProducer producer = BitMapProducer.fromIndexProducer((IndexProducer)iProducer, (int)96);
        ArrayList lst = new ArrayList();
        producer.forEachBitMap(lst::add);
        long expected = -1L;
        Assertions.assertEquals((long)expected, (long)((Long)lst.get(0)));
        Assertions.assertEquals((long)(expected &= 0xFFFFFFFFL), (long)((Long)lst.get(1)));
    }
}

