/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import java.util.function.IntPredicate;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.Shape;

public final class ArrayHasher
implements Hasher {
    private final int[] values;

    public ArrayHasher(int ... values) {
        this.values = values;
    }

    public IndexProducer indices(Shape shape) {
        Objects.requireNonNull(shape, "shape");
        return new Producer(shape);
    }

    private final class Producer
    implements IndexProducer {
        Shape shape;

        Producer(Shape shape) {
            this.shape = shape;
        }

        public boolean forEachIndex(IntPredicate consumer) {
            Objects.requireNonNull(consumer, "consumer");
            int pos = 0;
            for (int i = 0; i < this.shape.getNumberOfHashFunctions(); ++i) {
                int result = ArrayHasher.this.values[pos++] % this.shape.getNumberOfBits();
                pos %= ArrayHasher.this.values.length;
                if (consumer.test(result)) continue;
                return false;
            }
            return true;
        }
    }
}

