/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.collections4.bloomfilter.AbstractIndexProducerTest;
import org.apache.commons.collections4.bloomfilter.CellProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractCellProducerTest
extends AbstractIndexProducerTest {
    private static final CellProducer.CellConsumer TRUE_CONSUMER = (i, j) -> true;
    private static final CellProducer.CellConsumer FALSE_CONSUMER = (i, j) -> false;

    protected abstract CellProducer createEmptyProducer();

    protected abstract CellProducer createProducer();

    @Override
    protected final int getAsIndexArrayBehaviour() {
        return 3;
    }

    protected abstract int[] getExpectedValues();

    @Test
    public final void testBehaviourForEachCell() {
        AbstractIndexProducerTest.IntList list = new AbstractIndexProducerTest.IntList();
        this.createProducer().forEachCell((i, j) -> list.add(i));
        int[] actual = list.toArray();
        int[] expected = Arrays.stream(actual).sorted().toArray();
        Assertions.assertArrayEquals((int[])expected, (int[])actual);
        long count = Arrays.stream(actual).distinct().count();
        Assertions.assertEquals((long)count, (long)actual.length);
    }

    @Test
    public final void testEmptyCellProducer() {
        CellProducer empty = this.createEmptyProducer();
        int[] ary = empty.asIndexArray();
        Assertions.assertEquals((int)0, (int)ary.length);
        Assertions.assertTrue((boolean)empty.forEachCell((i, j) -> {
            Assertions.fail((String)"forEachCell consumer should not be called");
            return false;
        }));
    }

    @Test
    public void testForEachCellEarlyExit() {
        int[] passes = new int[1];
        Assertions.assertTrue((boolean)this.createEmptyProducer().forEachCell((i, j) -> {
            passes[0] = passes[0] + 1;
            return false;
        }));
        Assertions.assertEquals((int)0, (int)passes[0]);
        Assertions.assertFalse((boolean)this.createProducer().forEachCell((i, j) -> {
            passes[0] = passes[0] + 1;
            return false;
        }));
        Assertions.assertEquals((int)1, (int)passes[0]);
    }

    @Test
    public final void testForEachCellPredicates() {
        CellProducer populated = this.createProducer();
        CellProducer empty = this.createEmptyProducer();
        Assertions.assertFalse((boolean)populated.forEachCell(FALSE_CONSUMER), (String)"non-empty should be false");
        Assertions.assertTrue((boolean)empty.forEachCell(FALSE_CONSUMER), (String)"empty should be true");
        Assertions.assertTrue((boolean)populated.forEachCell(TRUE_CONSUMER), (String)"non-empty should be true");
        Assertions.assertTrue((boolean)empty.forEachCell(TRUE_CONSUMER), (String)"empty should be true");
    }

    @Test
    public void testForEachCellValues() {
        int[] expectedIdx = this.getExpectedIndices();
        int[] expectedValue = this.getExpectedValues();
        Assertions.assertEquals((int)expectedIdx.length, (int)expectedValue.length, (String)"expected index length and value length do not match");
        int[] idx = new int[]{0};
        this.createProducer().forEachCell((i, j) -> {
            Assertions.assertEquals((int)expectedIdx[idx[0]], (int)i, (String)("bad index at " + idx[0]));
            Assertions.assertEquals((int)expectedValue[idx[0]], (int)j, (String)("bad value at " + idx[0]));
            idx[0] = idx[0] + 1;
            return true;
        });
    }

    @Test
    public final void testIndexConsistency() {
        CellProducer producer = this.createProducer();
        BitSet bs1 = new BitSet();
        BitSet bs2 = new BitSet();
        producer.forEachIndex(i -> {
            bs1.set(i);
            return true;
        });
        producer.forEachCell((i, j) -> {
            bs2.set(i);
            return true;
        });
        Assertions.assertEquals((Object)bs1, (Object)bs2);
    }
}

