/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.collections4.bloomfilter.ArrayHasher;
import org.apache.commons.collections4.bloomfilter.BitMap;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.DefaultIndexProducerTest;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;
import org.apache.commons.collections4.bloomfilter.SparseBloomFilter;
import org.apache.commons.collections4.bloomfilter.TestingHashers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractBloomFilterTest<T extends BloomFilter> {
    private void assertFailedIndexProducerConstructor(Shape shape, int[] values) {
        IndexProducer indices = IndexProducer.fromIndexArray((int[])values);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createFilter(shape, indices));
    }

    private void assertIndexProducerMerge(Shape shape, int[] values, int[] expected) {
        IndexProducer indices = IndexProducer.fromIndexArray((int[])values);
        T filter = this.createFilter(shape, indices);
        ArrayList lst = new ArrayList();
        filter.forEachIndex(x -> {
            lst.add(x);
            return true;
        });
        Assertions.assertEquals((int)expected.length, (int)lst.size());
        for (int value : expected) {
            Assertions.assertTrue((boolean)lst.contains(value), (String)("Missing " + value));
        }
    }

    protected abstract T createEmptyFilter(Shape var1);

    protected final T createFilter(Shape shape, BitMapProducer producer) {
        T bf = this.createEmptyFilter(shape);
        bf.merge(producer);
        return bf;
    }

    protected final T createFilter(Shape shape, Hasher hasher) {
        T bf = this.createEmptyFilter(shape);
        bf.merge(hasher);
        return bf;
    }

    protected final T createFilter(Shape shape, IndexProducer producer) {
        T bf = this.createEmptyFilter(shape);
        bf.merge(producer);
        return bf;
    }

    protected Shape getTestShape() {
        return Shape.fromKM((int)17, (int)72);
    }

    @Test
    public final void testAsBitMapArray() {
        IncrementingHasher hasher = new IncrementingHasher(63L, 1L);
        T bf = this.createFilter(Shape.fromKM((int)2, (int)72), hasher);
        long[] lb = bf.asBitMapArray();
        Assertions.assertEquals((int)2, (int)lb.length);
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)lb[0]);
        Assertions.assertEquals((long)1L, (long)lb[1]);
    }

    @Test
    public void testBitMapProducerSize() {
        int[] idx = new int[1];
        this.createFilter(this.getTestShape(), TestingHashers.FROM1).forEachBitMap(i -> {
            idx[0] = idx[0] + 1;
            return true;
        });
        Assertions.assertEquals((int)BitMap.numberOfBitMaps((int)this.getTestShape().getNumberOfBits()), (int)idx[0]);
        idx[0] = 0;
        this.createEmptyFilter(this.getTestShape()).forEachBitMap(i -> {
            idx[0] = idx[0] + 1;
            return true;
        });
        Assertions.assertEquals((int)BitMap.numberOfBitMaps((int)this.getTestShape().getNumberOfBits()), (int)idx[0]);
    }

    @Test
    public void testCardinalityAndIsEmpty() {
        this.testCardinalityAndIsEmpty((BloomFilter)this.createEmptyFilter(this.getTestShape()));
    }

    protected void testCardinalityAndIsEmpty(BloomFilter bf) {
        int i;
        Assertions.assertTrue((boolean)bf.isEmpty());
        Assertions.assertEquals((int)0, (int)bf.cardinality());
        for (i = 0; i < this.getTestShape().getNumberOfBits(); ++i) {
            bf.merge(IndexProducer.fromIndexArray((int[])new int[]{i}));
            Assertions.assertFalse((boolean)bf.isEmpty(), (String)("Wrong value at " + i));
            Assertions.assertEquals((int)(i + 1), (int)bf.cardinality(), (String)("Wrong value at " + i));
        }
        bf.clear();
        Assertions.assertEquals((int)0, (int)bf.cardinality());
        Assertions.assertTrue((boolean)bf.isEmpty());
        for (i = 0; i < this.getTestShape().getNumberOfBits(); ++i) {
            bf.merge(IndexProducer.fromIndexArray((int[])new int[]{i}));
            Assertions.assertEquals((int)(i + 1), (int)bf.cardinality(), (String)("Wrong value at " + i));
            Assertions.assertFalse((boolean)bf.isEmpty(), (String)("Wrong value at " + i));
        }
    }

    @Test
    public void testClear() {
        T bf1 = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        Assertions.assertNotEquals((int)0, (int)bf1.cardinality());
        bf1.clear();
        Assertions.assertEquals((int)0, (int)bf1.cardinality());
    }

    @Test
    public final void testContains() {
        T bf1 = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        T bf2 = TestingHashers.populateFromHashersFrom1AndFrom11(this.createEmptyFilter(this.getTestShape()));
        Assertions.assertTrue((boolean)bf1.contains(bf1), (String)"BF1 Should contain itself");
        Assertions.assertTrue((boolean)bf2.contains(bf2), (String)"BF2 Should contain itself");
        Assertions.assertFalse((boolean)bf1.contains(bf2), (String)"BF1 should not contain BF2");
        Assertions.assertTrue((boolean)bf2.contains(bf1), (String)"BF2 should contain BF1");
        Assertions.assertTrue((boolean)bf2.contains((Hasher)new IncrementingHasher(1L, 1L)), (String)"BF2 Should contain this hasher");
        Assertions.assertFalse((boolean)bf2.contains((Hasher)new IncrementingHasher(1L, 3L)), (String)"BF2 Should not contain this hasher");
        IndexProducer indexProducer = new IncrementingHasher(1L, 1L).indices(this.getTestShape());
        Assertions.assertTrue((boolean)bf2.contains(indexProducer), (String)"BF2 Should contain this hasher");
        indexProducer = new IncrementingHasher(1L, 3L).indices(this.getTestShape());
        Assertions.assertFalse((boolean)bf2.contains(indexProducer), (String)"BF2 Should not contain this hasher");
        BitMapProducer bitMapProducer = BitMapProducer.fromIndexProducer((IndexProducer)new IncrementingHasher(1L, 1L).indices(this.getTestShape()), (int)this.getTestShape().getNumberOfBits());
        Assertions.assertTrue((boolean)bf2.contains(bitMapProducer), (String)"BF2 Should contain this hasher");
        bitMapProducer = BitMapProducer.fromIndexProducer((IndexProducer)new IncrementingHasher(1L, 3L).indices(this.getTestShape()), (int)this.getTestShape().getNumberOfBits());
        Assertions.assertFalse((boolean)bf2.contains(bitMapProducer), (String)"BF2 Should not contain this hasher");
        bf1 = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        T bf3 = this.createFilter(Shape.fromKM((int)this.getTestShape().getNumberOfHashFunctions(), (int)63), TestingHashers.FROM1);
        Assertions.assertTrue((boolean)bf1.contains(bf3));
        Assertions.assertTrue((boolean)bf3.contains(bf1));
        T bf4 = TestingHashers.populateRange(this.createEmptyFilter(Shape.fromKM((int)this.getTestShape().getNumberOfHashFunctions(), (int)63)), 1, 11 + this.getTestShape().getNumberOfHashFunctions());
        Assertions.assertFalse((boolean)bf1.contains(bf4));
        Assertions.assertTrue((boolean)bf4.contains(bf1));
    }

    @Test
    public void testEmptyAfterMergeWithNothing() {
        T bf = this.createEmptyFilter(this.getTestShape());
        bf.merge(IndexProducer.fromIndexArray((int[])new int[0]));
        Assertions.assertTrue((boolean)bf.isEmpty());
    }

    @Test
    public final void testEstimateIntersection() {
        T bf = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        T bf2 = TestingHashers.populateFromHashersFrom1AndFrom11(this.createEmptyFilter(this.getTestShape()));
        T bf3 = TestingHashers.populateEntireFilter(this.createEmptyFilter(this.getTestShape()));
        Assertions.assertEquals((int)1, (int)bf.estimateIntersection(bf2));
        Assertions.assertEquals((int)1, (int)bf2.estimateIntersection(bf));
        Assertions.assertEquals((int)1, (int)bf.estimateIntersection(bf3));
        Assertions.assertEquals((int)1, (int)bf2.estimateIntersection(bf));
        Assertions.assertEquals((int)2, (int)bf3.estimateIntersection(bf2));
        T bf4 = this.createEmptyFilter(this.getTestShape());
        Assertions.assertEquals((int)0, (int)bf.estimateIntersection(bf4));
        Assertions.assertEquals((int)0, (int)bf4.estimateIntersection(bf));
        int midPoint = this.getTestShape().getNumberOfBits() / 2;
        Object bf5 = TestingHashers.populateRange(this.createEmptyFilter(this.getTestShape()), 0, midPoint);
        Object bf6 = TestingHashers.populateRange(this.createEmptyFilter(this.getTestShape()), midPoint + 1, this.getTestShape().getNumberOfBits() - 1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> bf5.estimateIntersection(bf6));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)bf3.estimateIntersection(bf3));
    }

    @Test
    public final void testEstimateN() {
        T filter1 = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        Assertions.assertEquals((int)1, (int)filter1.estimateN());
        filter1.merge((Hasher)new IncrementingHasher(4L, 1L));
        Assertions.assertEquals((int)1, (int)filter1.estimateN());
        filter1.merge((Hasher)new IncrementingHasher(17L, 1L));
        Assertions.assertEquals((int)3, (int)filter1.estimateN());
        filter1 = TestingHashers.populateEntireFilter(this.createEmptyFilter(this.getTestShape()));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)filter1.estimateN());
    }

    @Test
    public final void testEstimateUnion() {
        T bf = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        T bf2 = this.createFilter(this.getTestShape(), TestingHashers.FROM11);
        Assertions.assertEquals((int)2, (int)bf.estimateUnion(bf2));
        Assertions.assertEquals((int)2, (int)bf2.estimateUnion(bf));
        T bf3 = this.createEmptyFilter(this.getTestShape());
        Assertions.assertEquals((int)1, (int)bf.estimateUnion(bf3));
        Assertions.assertEquals((int)1, (int)bf3.estimateUnion(bf));
    }

    @Test
    public void testIndexProducerMerge() {
        Shape shape = Shape.fromKM((int)5, (int)10);
        this.assertIndexProducerMerge(shape, new int[]{0, 2, 4, 6, 8}, new int[]{0, 2, 4, 6, 8});
        this.assertIndexProducerMerge(shape, new int[]{0, 2, 4, 2, 8}, new int[]{0, 2, 4, 8});
        this.assertFailedIndexProducerConstructor(shape, new int[]{0, 2, 4, -2, 8});
        this.assertFailedIndexProducerConstructor(shape, new int[]{0, 2, 4, 12, 8});
        this.assertIndexProducerMerge(shape, new int[0], new int[0]);
    }

    @Test
    public final void testIsFull() {
        T filter = this.createEmptyFilter(this.getTestShape());
        Assertions.assertFalse((boolean)filter.isFull(), (String)"Should not be full");
        filter = TestingHashers.populateEntireFilter(filter);
        Assertions.assertTrue((boolean)filter.isFull(), (String)"Should be full");
        filter = this.createFilter(this.getTestShape(), new IncrementingHasher(1L, 3L));
        Assertions.assertFalse((boolean)filter.isFull(), (String)"Should not be full");
    }

    @Test
    public final void testMerge() {
        Object bf1 = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        T bf2 = this.createFilter(this.getTestShape(), TestingHashers.FROM11);
        BloomFilter bf3 = bf1.copy();
        bf3.merge(bf2);
        long[] bf1Val = bf1.asBitMapArray();
        long[] bf2Val = bf2.asBitMapArray();
        for (int i = 0; i < bf1Val.length; ++i) {
            int n = i;
            bf1Val[n] = bf1Val[n] | bf2Val[i];
        }
        bf1.merge(bf2);
        long[] bf1New = bf1.asBitMapArray();
        for (int i = 0; i < bf1Val.length; ++i) {
            Assertions.assertEquals((long)bf1Val[i], (long)bf1New[i], (String)("Bad value at " + i));
        }
        Assertions.assertTrue((boolean)bf1.contains(bf2), (String)"Should contain bf2");
        Assertions.assertTrue((boolean)bf1.contains(bf3), (String)"Should contain bf3");
        T bf4 = this.createFilter(this.getTestShape(), TestingHashers.FROM1);
        bf4.merge(TestingHashers.FROM11);
        Assertions.assertTrue((boolean)bf4.contains(bf2), (String)"Should contain Bf2");
        Assertions.assertTrue((boolean)bf4.contains(bf3), (String)"Should contain Bf3");
        Assertions.assertThrows(IllegalArgumentException.class, () -> bf1.merge((Hasher)new BadHasher(bf1.getShape().getNumberOfBits())));
        Assertions.assertThrows(IllegalArgumentException.class, () -> bf1.merge((Hasher)new BadHasher(-1)));
        Shape s = Shape.fromKM((int)this.getTestShape().getNumberOfHashFunctions(), (int)(this.getTestShape().getNumberOfBits() * 3));
        IncrementingHasher h = new IncrementingHasher(this.getTestShape().getNumberOfBits() * 2, 1L);
        SimpleBloomFilter bf5 = new SimpleBloomFilter(s);
        bf5.merge((Hasher)h);
        Assertions.assertThrows(IllegalArgumentException.class, () -> AbstractBloomFilterTest.lambda$testMerge$7(bf1, (BloomFilter)bf5));
        SparseBloomFilter bf6 = new SparseBloomFilter(s);
        bf6.merge((Hasher)h);
        Assertions.assertThrows(IllegalArgumentException.class, () -> AbstractBloomFilterTest.lambda$testMerge$8(bf1, (BloomFilter)bf6));
    }

    @Test
    public void testMergeWithBadHasher() {
        T f = this.createEmptyFilter(this.getTestShape());
        Assertions.assertThrows(IllegalArgumentException.class, () -> f.merge((Hasher)new BadHasher(this.getTestShape().getNumberOfBits())));
        Object f2 = this.createEmptyFilter(this.getTestShape());
        Assertions.assertThrows(IllegalArgumentException.class, () -> f2.merge((Hasher)new BadHasher(-1)));
    }

    @Test
    public void testMergeWithBitMapProducer() {
        int bitMapCount = BitMap.numberOfBitMaps((int)this.getTestShape().getNumberOfBits());
        for (int i = 0; i < 5; ++i) {
            long[] values = new long[bitMapCount];
            for (int idx : DefaultIndexProducerTest.generateIntArray(this.getTestShape().getNumberOfHashFunctions(), this.getTestShape().getNumberOfBits())) {
                BitMap.set((long[])values, (int)idx);
            }
            T f = this.createFilter(this.getTestShape(), BitMapProducer.fromBitMapArray((long[])values));
            ArrayList<Long> lst = new ArrayList<Long>();
            for (long l2 : values) {
                lst.add(l2);
            }
            Assertions.assertTrue((boolean)f.forEachBitMap(l -> lst.remove(l)));
            Assertions.assertTrue((boolean)lst.isEmpty());
        }
        long[] values = new long[bitMapCount];
        Arrays.fill(values, Long.MAX_VALUE);
        BitMapProducer badProducer = BitMapProducer.fromBitMapArray((long[])values);
        Object bf = this.createEmptyFilter(this.getTestShape());
        Assertions.assertThrows(IllegalArgumentException.class, () -> bf.merge(badProducer));
        BitMapProducer badProducer2 = BitMapProducer.fromBitMapArray((long[])new long[]{Long.MIN_VALUE});
        Object bf2 = this.createEmptyFilter(Shape.fromKM((int)3, (int)32));
        Assertions.assertThrows(IllegalArgumentException.class, () -> bf2.merge(badProducer2));
    }

    @Test
    public void testMergeWithHasher() {
        for (int i = 0; i < 5; ++i) {
            T f = this.createEmptyFilter(this.getTestShape());
            int[] expected = DefaultIndexProducerTest.generateIntArray(this.getTestShape().getNumberOfHashFunctions(), this.getTestShape().getNumberOfBits());
            ArrayHasher hasher = new ArrayHasher(expected);
            f.merge((Hasher)hasher);
            Assertions.assertArrayEquals((int[])DefaultIndexProducerTest.unique(expected), (int[])f.asIndexArray());
        }
    }

    @Test
    public void testMergeWithIndexProducer() {
        for (int i = 0; i < 5; ++i) {
            int[] values = DefaultIndexProducerTest.generateIntArray(this.getTestShape().getNumberOfHashFunctions(), this.getTestShape().getNumberOfBits());
            T f = this.createFilter(this.getTestShape(), IndexProducer.fromIndexArray((int[])values));
            BitSet uniqueValues = DefaultIndexProducerTest.uniqueSet(values);
            Assertions.assertTrue((boolean)f.forEachIndex(idx -> {
                boolean result = uniqueValues.get(idx);
                uniqueValues.clear(idx);
                return result;
            }));
            Assertions.assertTrue((boolean)uniqueValues.isEmpty());
        }
        T f1 = this.createEmptyFilter(this.getTestShape());
        Assertions.assertThrows(IllegalArgumentException.class, () -> f1.merge(IndexProducer.fromIndexArray((int[])new int[]{this.getTestShape().getNumberOfBits()})));
        Object f2 = this.createEmptyFilter(this.getTestShape());
        Assertions.assertThrows(IllegalArgumentException.class, () -> f2.merge(IndexProducer.fromIndexArray((int[])new int[]{-1})));
    }

    @Test
    public final void testNegativeIntersection() {
        IndexProducer p1 = IndexProducer.fromIndexArray((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 20, 26, 28, 30, 32, 34, 35, 36, 37, 39, 40, 41, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71});
        IndexProducer p2 = IndexProducer.fromIndexArray((int[])new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27});
        T filter1 = this.createEmptyFilter(Shape.fromKM((int)17, (int)72));
        filter1.merge(p1);
        T filter2 = this.createEmptyFilter(Shape.fromKM((int)17, (int)72));
        filter2.merge(p2);
        Assertions.assertEquals((int)0, (int)filter1.estimateIntersection(filter2));
    }

    private static /* synthetic */ void lambda$testMerge$8(BloomFilter bf1, BloomFilter bf6) throws Throwable {
        bf1.merge(bf6);
    }

    private static /* synthetic */ void lambda$testMerge$7(BloomFilter bf1, BloomFilter bf5) throws Throwable {
        bf1.merge(bf5);
    }

    public static class BadHasher
    implements Hasher {
        IndexProducer producer;

        public BadHasher(int value) {
            this.producer = IndexProducer.fromIndexArray((int[])new int[]{value});
        }

        public IndexProducer indices(Shape shape) {
            return this.producer;
        }
    }
}

