/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.LongBiPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractBitMapProducerTest {
    static final LongPredicate FALSE_CONSUMER = arg0 -> false;
    static final LongPredicate TRUE_CONSUMER = arg0 -> true;

    protected abstract BitMapProducer createEmptyProducer();

    protected abstract BitMapProducer createProducer();

    protected boolean emptyIsZeroLength() {
        return false;
    }

    @Test
    public final void testAsBitMapArray() {
        long[] array = this.createEmptyProducer().asBitMapArray();
        for (int i = 0; i < array.length; ++i) {
            Assertions.assertEquals((long)0L, (long)array[i], (String)("Wrong value at " + i));
        }
        array = this.createProducer().asBitMapArray();
        Assertions.assertFalse((array.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public final void testForEachBitMap() {
        Assertions.assertFalse((boolean)this.createProducer().forEachBitMap(FALSE_CONSUMER), (String)"non-empty should be false");
        if (this.emptyIsZeroLength()) {
            Assertions.assertTrue((boolean)this.createEmptyProducer().forEachBitMap(FALSE_CONSUMER), (String)"empty should be true");
        } else {
            Assertions.assertFalse((boolean)this.createEmptyProducer().forEachBitMap(FALSE_CONSUMER), (String)"empty should be false");
        }
        Assertions.assertTrue((boolean)this.createProducer().forEachBitMap(TRUE_CONSUMER), (String)"non-empty should be true");
        Assertions.assertTrue((boolean)this.createEmptyProducer().forEachBitMap(TRUE_CONSUMER), (String)"empty should be true");
    }

    @Test
    public void testForEachBitMapEarlyExit() {
        int[] passes = new int[1];
        Assertions.assertFalse((boolean)this.createProducer().forEachBitMap(l -> {
            passes[0] = passes[0] + 1;
            return false;
        }));
        Assertions.assertEquals((int)1, (int)passes[0]);
        passes[0] = 0;
        if (this.emptyIsZeroLength()) {
            Assertions.assertTrue((boolean)this.createEmptyProducer().forEachBitMap(l -> {
                passes[0] = passes[0] + 1;
                return false;
            }));
            Assertions.assertEquals((int)0, (int)passes[0]);
        } else {
            Assertions.assertFalse((boolean)this.createEmptyProducer().forEachBitMap(l -> {
                passes[0] = passes[0] + 1;
                return false;
            }));
            Assertions.assertEquals((int)1, (int)passes[0]);
        }
    }

    @Test
    public final void testForEachBitMapPair() {
        LongBiPredicate func = (x, y) -> x == y;
        Assertions.assertTrue((boolean)this.createEmptyProducer().forEachBitMapPair(this.createEmptyProducer(), func), (String)"empty == empty failed");
        Assertions.assertFalse((boolean)this.createEmptyProducer().forEachBitMapPair(this.createProducer(), func), (String)"empty == not_empty failed");
        Assertions.assertFalse((boolean)this.createProducer().forEachBitMapPair(this.createEmptyProducer(), func), (String)"not_empty == empty passed");
        Assertions.assertTrue((boolean)this.createProducer().forEachBitMapPair(this.createProducer(), func), (String)"not_empty == not_empty failed");
        int[] count = new int[3];
        LongBiPredicate lbp = (x, y) -> {
            if (x == 0L) {
                count[0] = count[0] + 1;
            }
            if (y == 0L) {
                count[1] = count[1] + 1;
            }
            count[2] = count[2] + 1;
            return true;
        };
        this.createEmptyProducer().forEachBitMapPair(this.createProducer(), lbp);
        Assertions.assertEquals((int)count[2], (int)count[0]);
        Arrays.fill(count, 0);
        this.createProducer().forEachBitMapPair(this.createEmptyProducer(), lbp);
        Assertions.assertEquals((int)count[2], (int)count[1]);
        int[] limit = new int[1];
        LongBiPredicate shortFunc = (x, y) -> {
            limit[0] = limit[0] + 1;
            return limit[0] < 2;
        };
        BitMapProducer shortProducer = l -> true;
        Assertions.assertFalse((boolean)this.createProducer().forEachBitMapPair(shortProducer, shortFunc));
    }

    @Test
    public void testForEachBitMapPairEarlyExit() {
        int[] count = new int[1];
        LongBiPredicate lbp = (x, y) -> {
            count[0] = count[0] + 1;
            return false;
        };
        this.createProducer().forEachBitMapPair(this.createEmptyProducer(), lbp);
        Assertions.assertEquals((int)1, (int)count[0]);
        Arrays.fill(count, 0);
        this.createEmptyProducer().forEachBitMapPair(this.createProducer(), lbp);
        Assertions.assertEquals((int)1, (int)count[0]);
    }
}

