/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Arrays;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.bag.AbstractBagTest;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.bag.UnmodifiableBag;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableBagTest<E>
extends AbstractBagTest<E> {
    public UnmodifiableBagTest() {
        super(UnmodifiableBagTest.class.getSimpleName());
    }

    @Override
    public Bag<E> getCollection() {
        return super.getCollection();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public Bag<E> makeFullCollection() {
        HashBag bag = new HashBag();
        bag.addAll(Arrays.asList(this.getFullElements()));
        return UnmodifiableBag.unmodifiableBag((Bag)bag);
    }

    @Override
    public Bag<E> makeObject() {
        return UnmodifiableBag.unmodifiableBag((Bag)new HashBag());
    }

    @Test
    public void testDecorateFactory() {
        Bag<E> queue = this.makeFullCollection();
        Assertions.assertSame(queue, (Object)UnmodifiableBag.unmodifiableBag(queue));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableBag.unmodifiableBag(null));
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }
}

