/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.bag.AbstractBagTest;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.bag.TransformedBag;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformedBagTest<T>
extends AbstractBagTest<T> {
    public TransformedBagTest() {
        super(TransformedBagTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public Bag<T> makeObject() {
        return TransformedBag.transformingBag((Bag)new HashBag(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Test
    public void testTransformedBag() {
        Bag bag = TransformedBag.transformingBag((Bag)new HashBag(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertTrue((boolean)bag.isEmpty());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (int i = 0; i < els.length; ++i) {
            bag.add(els[i]);
            Assertions.assertEquals((int)(i + 1), (int)bag.size());
            Assertions.assertTrue((boolean)bag.contains((Object)Integer.valueOf((String)els[i])));
            Assertions.assertFalse((boolean)bag.contains(els[i]));
        }
        Assertions.assertFalse((boolean)bag.remove(els[0]));
        Assertions.assertTrue((boolean)bag.remove((Object)Integer.valueOf((String)els[0])));
    }

    @Test
    public void testTransformedBag_decorateTransform() {
        Object[] els;
        HashBag originalBag = new HashBag();
        for (Object el : els = new Object[]{"1", "3", "5", "7", "2", "4", "6"}) {
            originalBag.add(el);
        }
        Bag bag = TransformedBag.transformedBag((Bag)originalBag, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)els.length, (int)bag.size());
        for (Object el : els) {
            Assertions.assertTrue((boolean)bag.contains((Object)Integer.valueOf((String)el)));
            Assertions.assertFalse((boolean)bag.contains(el));
        }
        Assertions.assertFalse((boolean)bag.remove(els[0]));
        Assertions.assertTrue((boolean)bag.remove((Object)Integer.valueOf((String)els[0])));
    }
}

