/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.TestUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.functors.ConstantTransformer;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.functors.ExceptionTransformer;
import org.apache.commons.collections4.functors.FalsePredicate;
import org.apache.commons.collections4.functors.NOPTransformer;
import org.apache.commons.collections4.functors.StringValueTransformer;
import org.apache.commons.collections4.functors.TruePredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class TransformerUtilsTest {
    private static final Object cObject = new Object();
    private static final Object cString = "Hello";
    private static final Object cInteger = 6;

    @Test
    public void testChainedTransformer() {
        Transformer a = TransformerUtils.constantTransformer((Object)"A");
        Transformer b = TransformerUtils.constantTransformer((Object)"B");
        Assertions.assertEquals((Object)"A", (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{b, a}).transform(null));
        Assertions.assertEquals((Object)"B", (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{a, b}).transform(null));
        Assertions.assertEquals((Object)"A", (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{b, a}).transform(null));
        ArrayList<Transformer> coll = new ArrayList<Transformer>();
        coll.add(b);
        coll.add(a);
        Assertions.assertEquals((Object)"A", (Object)TransformerUtils.chainedTransformer(coll).transform(null));
        Assertions.assertSame((Object)NOPTransformer.INSTANCE, (Object)TransformerUtils.chainedTransformer((Transformer[])new Transformer[0]));
        Assertions.assertSame((Object)NOPTransformer.INSTANCE, (Object)TransformerUtils.chainedTransformer(Collections.emptyList()));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{null, null})), () -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.chainedTransformer((Transformer[])null)), () -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.chainedTransformer((Collection)null)), () -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.chainedTransformer((Transformer[])new Transformer[]{null, null})), () -> Assertions.assertThrows(NullPointerException.class, () -> {
            ArrayList<Object> coll1 = new ArrayList<Object>();
            coll1.add(null);
            coll1.add(null);
            TransformerUtils.chainedTransformer(coll1);
        })});
    }

    @Test
    public void testCloneTransformer() {
        Assertions.assertNull((Object)TransformerUtils.cloneTransformer().transform(null));
        Assertions.assertEquals((Object)cString, (Object)TransformerUtils.cloneTransformer().transform(cString));
        Assertions.assertEquals((Object)cInteger, (Object)TransformerUtils.cloneTransformer().transform(cInteger));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Assertions.assertEquals((Object)cObject, (Object)TransformerUtils.cloneTransformer().transform(cObject)));
    }

    @Test
    public void testConstantTransformer() {
        Assertions.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(null));
        Assertions.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(cObject));
        Assertions.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(cString));
        Assertions.assertEquals((Object)cObject, (Object)TransformerUtils.constantTransformer((Object)cObject).transform(cInteger));
        Assertions.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.constantTransformer(null));
    }

    @Test
    public void testExceptionTransformer() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)TransformerUtils.exceptionTransformer()), () -> Assertions.assertSame((Object)TransformerUtils.exceptionTransformer(), (Object)TransformerUtils.exceptionTransformer()), () -> Assertions.assertThrows(FunctorException.class, () -> TransformerUtils.exceptionTransformer().transform(null)), () -> Assertions.assertThrows(FunctorException.class, () -> TransformerUtils.exceptionTransformer().transform(cString))});
    }

    @Test
    public void testExecutorTransformer() {
        Assertions.assertNull((Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(null));
        Assertions.assertEquals((Object)cObject, (Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(cObject));
        Assertions.assertEquals((Object)cString, (Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(cString));
        Assertions.assertEquals((Object)cInteger, (Object)TransformerUtils.asTransformer((Closure)ClosureUtils.nopClosure()).transform(cInteger));
        Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.asTransformer((Closure)null));
    }

    @Test
    public void testFactoryTransformer() {
        Assertions.assertNull((Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(null));
        Assertions.assertNull((Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(cObject));
        Assertions.assertNull((Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(cString));
        Assertions.assertNull((Object)TransformerUtils.asTransformer((Factory)FactoryUtils.nullFactory()).transform(cInteger));
        Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.asTransformer((Factory)null));
    }

    @Test
    public void testIfTransformer() {
        Transformer a = TransformerUtils.constantTransformer((Object)"A");
        Transformer b = TransformerUtils.constantTransformer((Object)"B");
        Transformer c = TransformerUtils.constantTransformer((Object)"C");
        Assertions.assertEquals((Object)"A", (Object)TransformerUtils.ifTransformer((Predicate)TruePredicate.truePredicate(), (Transformer)a, (Transformer)b).transform(null));
        Assertions.assertEquals((Object)"B", (Object)TransformerUtils.ifTransformer((Predicate)FalsePredicate.falsePredicate(), (Transformer)a, (Transformer)b).transform(null));
        Predicate lessThanFivePredicate = value -> value < 5;
        Assertions.assertEquals((Object)"A", (Object)TransformerUtils.ifTransformer((Predicate)lessThanFivePredicate, (Transformer)a, (Transformer)b).transform((Object)1));
        Assertions.assertEquals((Object)"B", (Object)TransformerUtils.ifTransformer((Predicate)lessThanFivePredicate, (Transformer)a, (Transformer)b).transform((Object)5));
        Predicate equalsAPredicate = EqualPredicate.equalPredicate((Object)"A");
        Assertions.assertEquals((Object)"C", (Object)TransformerUtils.ifTransformer((Predicate)equalsAPredicate, (Transformer)c).transform((Object)"A"));
        Assertions.assertEquals((Object)"B", (Object)TransformerUtils.ifTransformer((Predicate)equalsAPredicate, (Transformer)c).transform((Object)"B"));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.ifTransformer(null, null)), () -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.ifTransformer((Predicate)TruePredicate.truePredicate(), null)), () -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.ifTransformer(null, (Transformer)ConstantTransformer.constantTransformer((Object)"A"))), () -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.ifTransformer(null, null, null))});
    }

    @Test
    public void testInstantiateTransformerNull() {
        Transformer trans;
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IllegalArgumentException.class, () -> TransformerUtils.instantiateTransformer(null, (Object[])new Object[]{"str"})), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> TransformerUtils.instantiateTransformer((Class[])new Class[0], (Object[])new Object[]{"str"}))});
        Transformer finalTrans = trans = TransformerUtils.instantiateTransformer((Class[])new Class[]{Long.class}, (Object[])new Object[]{null});
        Assertions.assertThrows(FunctorException.class, () -> finalTrans.transform(String.class));
        trans = TransformerUtils.instantiateTransformer();
        Assertions.assertEquals((Object)"", (Object)trans.transform(String.class));
        trans = TransformerUtils.instantiateTransformer((Class[])new Class[]{Long.TYPE}, (Object[])new Object[]{1000L});
        Assertions.assertEquals((Object)new Date(1000L), (Object)trans.transform(Date.class));
    }

    @Test
    public void testInvokerTransformer() {
        ArrayList<Object> list = new ArrayList<Object>();
        Assertions.assertEquals((Object)0, (Object)TransformerUtils.invokerTransformer((String)"size").transform(list));
        list.add(new Object());
        Assertions.assertEquals((Object)1, (Object)TransformerUtils.invokerTransformer((String)"size").transform(list));
        Assertions.assertNull((Object)TransformerUtils.invokerTransformer((String)"size").transform(null));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.invokerTransformer(null)), () -> Assertions.assertThrows(FunctorException.class, () -> TransformerUtils.invokerTransformer((String)"noSuchMethod").transform(new Object()))});
    }

    @Test
    public void testInvokerTransformer2() {
        ArrayList<Object> list = new ArrayList<Object>();
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)TransformerUtils.invokerTransformer((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(list));
        list.add(cString);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.invokerTransformer((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(list));
        Assertions.assertNull((Object)TransformerUtils.invokerTransformer((String)"contains", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(null));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.invokerTransformer(null, null, null)), () -> Assertions.assertThrows(FunctorException.class, () -> TransformerUtils.invokerTransformer((String)"noSuchMethod", (Class[])new Class[]{Object.class}, (Object[])new Object[]{cString}).transform(new Object())), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> TransformerUtils.invokerTransformer((String)"badArgs", null, (Object[])new Object[]{cString})), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> TransformerUtils.invokerTransformer((String)"badArgs", (Class[])new Class[]{Object.class}, null)), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> TransformerUtils.invokerTransformer((String)"badArgs", (Class[])new Class[0], (Object[])new Object[]{cString}))});
    }

    @Test
    public void testMapTransformer() {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        map.put(null, 0);
        map.put(cObject, 1);
        map.put(cString, 2);
        Assertions.assertEquals((Integer)0, (Integer)((Integer)TransformerUtils.mapTransformer(map).transform(null)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)TransformerUtils.mapTransformer(map).transform(cObject)));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)TransformerUtils.mapTransformer(map).transform(cString)));
        Assertions.assertNull((Object)TransformerUtils.mapTransformer(map).transform(cInteger));
        Assertions.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.mapTransformer(null));
    }

    @Test
    public void testNopTransformer() {
        Assertions.assertNotNull((Object)TransformerUtils.nullTransformer());
        Assertions.assertSame((Object)TransformerUtils.nullTransformer(), (Object)TransformerUtils.nullTransformer());
        Assertions.assertNull((Object)TransformerUtils.nopTransformer().transform(null));
        Assertions.assertEquals((Object)cObject, (Object)TransformerUtils.nopTransformer().transform(cObject));
        Assertions.assertEquals((Object)cString, (Object)TransformerUtils.nopTransformer().transform(cString));
        Assertions.assertEquals((Object)cInteger, (Object)TransformerUtils.nopTransformer().transform(cInteger));
    }

    @Test
    public void testNullTransformer() {
        Assertions.assertNotNull((Object)TransformerUtils.nullTransformer());
        Assertions.assertSame((Object)TransformerUtils.nullTransformer(), (Object)TransformerUtils.nullTransformer());
        Assertions.assertNull((Object)TransformerUtils.nullTransformer().transform(null));
        Assertions.assertNull((Object)TransformerUtils.nullTransformer().transform(cObject));
        Assertions.assertNull((Object)TransformerUtils.nullTransformer().transform(cString));
        Assertions.assertNull((Object)TransformerUtils.nullTransformer().transform(cInteger));
    }

    @Test
    public void testPredicateTransformer() {
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(null));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(cObject));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(cString));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)TransformerUtils.asTransformer((Predicate)TruePredicate.truePredicate()).transform(cInteger));
        Assertions.assertThrows(IllegalArgumentException.class, () -> TransformerUtils.asTransformer((Predicate)null));
    }

    @Test
    public void testSingletonPatternInSerialization() {
        Object[] singletons;
        for (Object original : singletons = new Object[]{ExceptionTransformer.INSTANCE, NOPTransformer.INSTANCE, StringValueTransformer.stringValueTransformer()}) {
            TestUtils.assertSameAfterSerialization("Singleton pattern broken for " + original.getClass(), original);
        }
    }

    @Test
    public void testStringValueTransformer() {
        Assertions.assertNotNull((Object)"StringValueTransformer should NEVER return a null value.", (String)((String)TransformerUtils.stringValueTransformer().transform(null)));
        Assertions.assertEquals((Object)"null", (Object)TransformerUtils.stringValueTransformer().transform(null), (String)"StringValueTransformer should return \"null\" when given a null argument.");
        Assertions.assertEquals((Object)"6", (Object)TransformerUtils.stringValueTransformer().transform((Object)6), (String)"StringValueTransformer should return toString value");
    }

    @Test
    public void testSwitchMapTransformer() {
        Transformer a = TransformerUtils.constantTransformer((Object)"A");
        Transformer b = TransformerUtils.constantTransformer((Object)"B");
        Transformer c = TransformerUtils.constantTransformer((Object)"C");
        HashMap<String, Transformer> map = new HashMap<String, Transformer>();
        map.put("HELLO", a);
        map.put("THERE", b);
        Assertions.assertNull((Object)TransformerUtils.switchMapTransformer(map).transform((Object)"WELL"));
        Assertions.assertEquals((Object)"A", (Object)TransformerUtils.switchMapTransformer(map).transform((Object)"HELLO"));
        Assertions.assertEquals((Object)"B", (Object)TransformerUtils.switchMapTransformer(map).transform((Object)"THERE"));
        map.put(null, c);
        Assertions.assertEquals((Object)"C", (Object)TransformerUtils.switchMapTransformer(map).transform((Object)"WELL"));
        Assertions.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchMapTransformer(new HashMap()));
        map = new HashMap();
        map.put(null, null);
        Assertions.assertSame((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchMapTransformer(map));
        Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.switchMapTransformer(null));
    }

    @Test
    public void testSwitchTransformer() {
        Transformer a = TransformerUtils.constantTransformer((Object)"A");
        Transformer b = TransformerUtils.constantTransformer((Object)"B");
        Transformer c = TransformerUtils.constantTransformer((Object)"C");
        Assertions.assertEquals((Object)"A", (Object)TransformerUtils.switchTransformer((Predicate)TruePredicate.truePredicate(), (Transformer)a, (Transformer)b).transform(null));
        Assertions.assertEquals((Object)"B", (Object)TransformerUtils.switchTransformer((Predicate)FalsePredicate.falsePredicate(), (Transformer)a, (Transformer)b).transform(null));
        Assertions.assertNull((Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}).transform((Object)"WELL"));
        Assertions.assertEquals((Object)"A", (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}).transform((Object)"HELLO"));
        Assertions.assertEquals((Object)"B", (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}).transform((Object)"THERE"));
        Assertions.assertEquals((Object)"C", (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[]{EqualPredicate.equalPredicate((Object)"HELLO"), EqualPredicate.equalPredicate((Object)"THERE")}, (Transformer[])new Transformer[]{a, b}, (Transformer)c).transform((Object)"WELL"));
        HashMap<Predicate, Transformer> map = new HashMap<Predicate, Transformer>();
        map.put(EqualPredicate.equalPredicate((Object)"HELLO"), a);
        map.put(EqualPredicate.equalPredicate((Object)"THERE"), b);
        Assertions.assertNull((Object)TransformerUtils.switchTransformer(map).transform((Object)"WELL"));
        Assertions.assertEquals((Object)"A", (Object)TransformerUtils.switchTransformer(map).transform((Object)"HELLO"));
        Assertions.assertEquals((Object)"B", (Object)TransformerUtils.switchTransformer(map).transform((Object)"THERE"));
        map.put(null, c);
        Assertions.assertEquals((Object)"C", (Object)TransformerUtils.switchTransformer(map).transform((Object)"WELL"));
        Assertions.assertEquals((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchTransformer((Predicate[])new Predicate[0], (Transformer[])new Transformer[0]));
        Assertions.assertEquals((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchTransformer(new HashMap()));
        map = new HashMap();
        map.put(null, null);
        Assertions.assertEquals((Object)ConstantTransformer.NULL_INSTANCE, (Object)TransformerUtils.switchTransformer(map));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.switchTransformer(null, null)), () -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.switchTransformer(null, (Transformer[])null)), () -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.switchTransformer(null)), () -> Assertions.assertThrows(NullPointerException.class, () -> TransformerUtils.switchTransformer((Predicate[])new Predicate[2], (Transformer[])new Transformer[2])), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> TransformerUtils.switchTransformer((Predicate[])new Predicate[]{TruePredicate.truePredicate()}, (Transformer[])new Transformer[]{a, b}))});
    }
}

