/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.TestUtils;
import org.apache.commons.collections4.functors.ConstantFactory;
import org.apache.commons.collections4.functors.ExceptionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FactoryUtilsTest {
    @Test
    public void testConstantFactoryConstant() {
        Integer constant = 9;
        Factory factory = FactoryUtils.constantFactory((Object)constant);
        Assertions.assertNotNull((Object)factory);
        Integer created = (Integer)factory.create();
        Assertions.assertSame((Object)constant, (Object)created);
    }

    @Test
    public void testConstantFactoryNull() {
        Factory factory = FactoryUtils.constantFactory(null);
        Assertions.assertNotNull((Object)factory);
        Object created = factory.create();
        Assertions.assertNull((Object)created);
    }

    @Test
    public void testExceptionFactory() {
        Assertions.assertNotNull((Object)FactoryUtils.exceptionFactory());
        Assertions.assertSame((Object)FactoryUtils.exceptionFactory(), (Object)FactoryUtils.exceptionFactory());
        Assertions.assertThrows(FunctorException.class, () -> FactoryUtils.exceptionFactory().create());
    }

    @Test
    public void testInstantiateFactoryComplex() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        Factory factory = FactoryUtils.instantiateFactory(Date.class, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{70, 0, 2});
        Assertions.assertNotNull((Object)factory);
        Date created = (Date)factory.create();
        Assertions.assertEquals((Object)new Date(86400000L), (Object)created);
    }

    @Test
    public void testInstantiateFactoryMismatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FactoryUtils.instantiateFactory(Date.class, null, (Object[])new Object[]{null}));
    }

    @Test
    public void testInstantiateFactoryNoConstructor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FactoryUtils.instantiateFactory(Date.class, (Class[])new Class[]{Long.class}, (Object[])new Object[]{null}));
    }

    @Test
    public void testInstantiateFactoryNull() {
        Assertions.assertThrows(NullPointerException.class, () -> FactoryUtils.instantiateFactory(null));
    }

    @Test
    public void testInstantiateFactorySimple() {
        Factory factory = FactoryUtils.instantiateFactory(Mock3.class);
        Assertions.assertNotNull((Object)factory);
        Mock3 created = (Mock3)factory.create();
        Assertions.assertEquals((int)0, (int)created.getValue());
        created = (Mock3)factory.create();
        Assertions.assertEquals((int)1, (int)created.getValue());
    }

    @Test
    public void testNullFactory() {
        Factory factory = FactoryUtils.nullFactory();
        Assertions.assertNotNull((Object)factory);
        Object created = factory.create();
        Assertions.assertNull((Object)created);
    }

    @Test
    public void testPrototypeFactoryNull() {
        Assertions.assertSame((Object)ConstantFactory.NULL_INSTANCE, (Object)FactoryUtils.prototypeFactory(null));
    }

    @Test
    public void testPrototypeFactoryPublicBad() {
        Object proto = new Object();
        Assertions.assertThrows(IllegalArgumentException.class, () -> FactoryUtils.prototypeFactory((Object)proto));
    }

    @Test
    public void testPrototypeFactoryPublicCloneMethod() throws Exception {
        Date proto = new Date();
        Factory factory = FactoryUtils.prototypeFactory((Object)proto);
        Assertions.assertNotNull((Object)factory);
        Date created = (Date)factory.create();
        Assertions.assertNotSame((Object)proto, (Object)created);
        Assertions.assertEquals((Object)proto, (Object)created);
    }

    @Test
    public void testPrototypeFactoryPublicCopyConstructor() throws Exception {
        Mock1 proto = new Mock1(6);
        Factory factory = FactoryUtils.prototypeFactory((Object)proto);
        Assertions.assertNotNull((Object)factory);
        Object created = factory.create();
        Assertions.assertNotSame((Object)proto, (Object)created);
        Assertions.assertEquals((Object)proto, (Object)created);
    }

    @Test
    public void testPrototypeFactoryPublicSerialization() throws Exception {
        Integer proto = 9;
        Factory factory = FactoryUtils.prototypeFactory((Object)proto);
        Assertions.assertNotNull((Object)factory);
        Integer created = (Integer)factory.create();
        Assertions.assertNotSame((Object)proto, (Object)created);
        Assertions.assertEquals((Integer)proto, (Integer)created);
    }

    @Test
    public void testPrototypeFactoryPublicSerializationError() {
        Mock2 proto = new Mock2(new Object());
        Factory factory = FactoryUtils.prototypeFactory((Object)proto);
        Assertions.assertNotNull((Object)factory);
        FunctorException thrown = (FunctorException)Assertions.assertThrows(FunctorException.class, () -> factory.create());
        Assertions.assertTrue((boolean)(thrown.getCause() instanceof IOException));
    }

    @Test
    public void testSingletonPatternInSerialization() {
        Object[] singletons;
        for (Object original : singletons = new Object[]{ExceptionFactory.INSTANCE}) {
            TestUtils.assertSameAfterSerialization("Singleton pattern broken for " + original.getClass(), original);
        }
    }

    public static class Mock3 {
        private static int cCounter;
        private final int iVal = cCounter++;

        public int getValue() {
            return this.iVal;
        }
    }

    public static class Mock1 {
        private final int iVal;

        public Mock1(int val) {
            this.iVal = val;
        }

        public Mock1(Mock1 mock) {
            this.iVal = mock.iVal;
        }

        public boolean equals(Object obj) {
            return obj instanceof Mock1 && this.iVal == ((Mock1)obj).iVal;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class Mock2
    implements Serializable {
        private static final long serialVersionUID = 4899282162482588924L;
        private final Object iVal;

        public Mock2(Object val) {
            this.iVal = val;
        }

        public boolean equals(Object obj) {
            return obj instanceof Mock2 && this.iVal == ((Mock2)obj).iVal;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

