/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.set.AbstractNavigableSetTest;
import org.apache.commons.collections4.set.UnmodifiableNavigableSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableNavigableSetTest<E>
extends AbstractNavigableSetTest<E> {
    protected UnmodifiableNavigableSet<E> set;
    protected ArrayList<E> array;

    public UnmodifiableNavigableSetTest() {
        super(UnmodifiableNavigableSetTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public UnmodifiableNavigableSet<E> makeFullCollection() {
        TreeSet set = new TreeSet(Arrays.asList(this.getFullElements()));
        return (UnmodifiableNavigableSet)UnmodifiableNavigableSet.unmodifiableNavigableSet(set);
    }

    @Override
    public NavigableSet<E> makeObject() {
        return UnmodifiableNavigableSet.unmodifiableNavigableSet(new TreeSet());
    }

    protected void setupSet() {
        this.set = this.makeFullCollection();
        this.array = new ArrayList();
        this.array.add(1);
    }

    @Test
    public void testComparator() {
        this.setupSet();
        Comparator c = this.set.comparator();
        Assertions.assertNull((Object)c, (String)"natural order, so comparator should be null");
    }

    @Test
    public void testDecorateFactory() {
        UnmodifiableNavigableSet<E> set = this.makeFullCollection();
        Assertions.assertSame(set, (Object)UnmodifiableNavigableSet.unmodifiableNavigableSet(set));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableNavigableSet.unmodifiableNavigableSet(null));
    }

    @Test
    public void testUnmodifiable() {
        this.setupSet();
        this.verifyUnmodifiable((Set<E>)this.set);
        this.verifyUnmodifiable(this.set.descendingSet());
        this.verifyUnmodifiable(this.set.headSet((Object)1));
        this.verifyUnmodifiable(this.set.headSet((Object)1, true));
        this.verifyUnmodifiable(this.set.tailSet((Object)1));
        this.verifyUnmodifiable(this.set.tailSet((Object)1, false));
        this.verifyUnmodifiable(this.set.subSet((Object)1, (Object)3));
        this.verifyUnmodifiable(this.set.subSet((Object)1, false, (Object)3, false));
        this.verifyUnmodifiable(this.set.subSet((Object)1, true, (Object)3, true));
    }

    public void verifyUnmodifiable(Set<E> set) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.add("value"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.addAll(new TreeSet()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.clear());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.iterator().remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.remove("x"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.removeAll(this.array));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.removeIf(element -> true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> set.retainAll(this.array));
        if (set instanceof NavigableSet) {
            NavigableSet navigableSet = (NavigableSet)set;
            Assertions.assertThrows(UnsupportedOperationException.class, () -> navigableSet.pollFirst());
            Assertions.assertThrows(UnsupportedOperationException.class, () -> navigableSet.pollLast());
        }
    }
}

