/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.LazyMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LazyMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    private static final Factory<Integer> oneFactory = FactoryUtils.constantFactory((Object)1);

    public LazyMapTest() {
        super(LazyMapTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public LazyMap<K, V> makeObject() {
        return LazyMap.lazyMap(new HashMap(), (Factory)FactoryUtils.nullFactory());
    }

    @Override
    @Test
    public void testMapGet() {
    }

    @Test
    public void testMapGetWithFactory() {
        LazyMap map = LazyMap.lazyMap(new HashMap(), oneFactory);
        Assertions.assertEquals((int)0, (int)map.size());
        Number i1 = (Number)map.get("Five");
        Assertions.assertEquals((Object)1, (Object)i1);
        Assertions.assertEquals((int)1, (int)map.size());
        Number i2 = (Number)map.get(new String(new char[]{'F', 'i', 'v', 'e'}));
        Assertions.assertEquals((Object)1, (Object)i2);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertSame((Object)i1, (Object)i2);
        map = LazyMap.lazyMap(new HashMap(), (Factory)FactoryUtils.nullFactory());
        Object o = map.get("Five");
        Assertions.assertNull(o);
        Assertions.assertEquals((int)1, (int)map.size());
    }

    @Test
    public void testMapGetWithTransformer() {
        Transformer intConverter = Number::intValue;
        LazyMap map = LazyMap.lazyMap(new HashMap(), (Transformer)intConverter);
        Assertions.assertEquals((int)0, (int)map.size());
        Number i1 = (Number)map.get(123L);
        Assertions.assertEquals((Object)123, (Object)i1);
        Assertions.assertEquals((int)1, (int)map.size());
    }
}

