/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.TransformedList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformedListTest<E>
extends AbstractListTest<E> {
    public TransformedListTest() {
        super(TransformedListTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public List<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public List<E> makeConfirmedFullCollection() {
        return new ArrayList(Arrays.asList(this.getFullElements()));
    }

    @Override
    public List<E> makeFullCollection() {
        ArrayList list = new ArrayList(Arrays.asList(this.getFullElements()));
        return TransformedList.transformingList(list, TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Override
    public List<E> makeObject() {
        return TransformedList.transformingList(new ArrayList(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Test
    public void testSubList() {
        Collection list = this.makeObject();
        List subList = list.subList(0, 0);
        Assertions.assertNotNull(subList);
        list.add("zero");
        subList = list.subList(0, 0);
        Assertions.assertNotNull(subList);
        Assertions.assertEquals((int)0, (int)subList.size());
        subList = list.subList(0, 1);
        Assertions.assertEquals((int)1, (int)subList.size());
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("one");
        elements.add("two");
        elements.add("three");
        list.addAll(1, elements);
        subList = list.subList(0, list.size());
        Assertions.assertEquals((int)list.size(), (int)subList.size());
    }

    @Test
    public void testTransformedList() {
        int i;
        TransformedList list = TransformedList.transformingList(new ArrayList(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)0, (int)list.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (i = 0; i < els.length; ++i) {
            list.add(els[i]);
            Assertions.assertEquals((int)(i + 1), (int)list.size());
            Assertions.assertTrue((boolean)list.contains(Integer.valueOf((String)els[i])));
            Assertions.assertFalse((boolean)list.contains(els[i]));
        }
        Assertions.assertFalse((boolean)list.remove(els[0]));
        Assertions.assertTrue((boolean)list.remove(Integer.valueOf((String)els[0])));
        list.clear();
        for (i = 0; i < els.length; ++i) {
            list.add(0, els[i]);
            Assertions.assertEquals((int)(i + 1), (int)list.size());
            Assertions.assertEquals((Object)Integer.valueOf((String)els[i]), list.get(0));
        }
        list.set(0, "22");
        Assertions.assertEquals((Object)22, list.get(0));
        ListIterator<String> it = list.listIterator();
        it.next();
        it.set("33");
        Assertions.assertEquals((Object)33, list.get(0));
        it.add("44");
        Assertions.assertEquals((Object)44, list.get(1));
        ArrayList<String> adds = new ArrayList<String>();
        adds.add("1");
        adds.add("2");
        list.clear();
        list.addAll(adds);
        Assertions.assertEquals((Object)1, list.get(0));
        Assertions.assertEquals((Object)2, list.get(1));
        adds.clear();
        adds.add("3");
        list.addAll(1, adds);
        Assertions.assertEquals((Object)1, list.get(0));
        Assertions.assertEquals((Object)3, list.get(1));
        Assertions.assertEquals((Object)2, list.get(2));
    }

    @Test
    public void testTransformedList_decorateTransform() {
        ArrayList originalList = new ArrayList();
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        Collections.addAll(originalList, els);
        TransformedList list = TransformedList.transformedList(originalList, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)els.length, (int)list.size());
        for (Object el : els) {
            Assertions.assertTrue((boolean)list.contains(Integer.valueOf((String)el)));
            Assertions.assertFalse((boolean)list.contains(el));
        }
        Assertions.assertFalse((boolean)list.remove(els[0]));
        Assertions.assertTrue((boolean)list.remove(Integer.valueOf((String)els[0])));
    }
}

