/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.FixedSizeList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FixedSizeListTest<E>
extends AbstractListTest<E> {
    public FixedSizeListTest() {
        super(FixedSizeListTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    private FixedSizeList<String> initFixedSizeList() {
        ArrayList<String> decoratedList = new ArrayList<String>();
        decoratedList.add("item 1");
        decoratedList.add("item 2");
        return FixedSizeList.fixedSizeList(decoratedList);
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public List<E> makeFullCollection() {
        ArrayList list = new ArrayList(Arrays.asList(this.getFullElements()));
        return FixedSizeList.fixedSizeList(list);
    }

    @Override
    public List<E> makeObject() {
        return FixedSizeList.fixedSizeList(new ArrayList());
    }

    @Test
    public void testAdd() {
        FixedSizeList<String> fixedSizeList = this.initFixedSizeList();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> fixedSizeList.add(2, (Object)"New Value"));
    }

    @Test
    public void testAddAll() {
        FixedSizeList<String> fixedSizeList = this.initFixedSizeList();
        ArrayList<String> addList = new ArrayList<String>();
        addList.add("item 3");
        addList.add("item 4");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> fixedSizeList.addAll(2, (Collection)addList));
    }

    @Test
    public void testIsFull() {
        FixedSizeList<String> fixedSizeList = this.initFixedSizeList();
        Assertions.assertTrue((boolean)fixedSizeList.isFull());
    }

    @Test
    public void testListAllowsMutationOfUnderlyingCollection() {
        ArrayList<String> decoratedList = new ArrayList<String>();
        decoratedList.add("item 1");
        decoratedList.add("item 2");
        FixedSizeList fixedSizeList = FixedSizeList.fixedSizeList(decoratedList);
        int sizeBefore = fixedSizeList.size();
        boolean changed = decoratedList.add("New Value");
        Assertions.assertTrue((boolean)changed);
        Assertions.assertEquals((int)(sizeBefore + 1), (int)fixedSizeList.size(), (String)"Modifying an the underlying list is allowed");
    }

    @Test
    public void testMaxSize() {
        FixedSizeList<String> fixedSizeList = this.initFixedSizeList();
        Assertions.assertEquals((int)2, (int)fixedSizeList.maxSize());
    }

    @Test
    public void testRemove() {
        FixedSizeList<String> fixedSizeList = this.initFixedSizeList();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> fixedSizeList.remove(1));
    }

    @Test
    public void testSubList() {
        FixedSizeList<String> fixedSizeList = this.initFixedSizeList();
        List subFixedSizeList = fixedSizeList.subList(1, 1);
        Assertions.assertNotNull((Object)subFixedSizeList);
        Assertions.assertEquals((int)0, (int)subFixedSizeList.size());
    }
}

